/*
 * Decompiled with CFR 0.152.
 */
package dbaut.text;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public interface UndoRedoText {
    public static final UndoManager undoManager = new UndoManager();
    public static final UndoHandler undoHandler = new UndoHandler();
    public static final UndoAction undoAction = new UndoAction();
    public static final RedoAction redoAction = new RedoAction();
    public static final KeyStroke undoKeystroke = KeyStroke.getKeyStroke(90, 2);
    public static final KeyStroke redoKeystroke = KeyStroke.getKeyStroke(89, 2);

    public void setupUndoRedo();

    public static class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -731716311693118517L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                undoManager.redo();
            }
            catch (CannotRedoException ex) {
                ex.printStackTrace();
            }
            this.update();
            undoAction.update();
        }

        protected void update() {
            if (undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    public static class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 130221570602668519L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.update();
            redoAction.update();
        }

        protected void update() {
            if (undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    public static class UndoHandler
    implements UndoableEditListener {
        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            undoManager.addEdit(e.getEdit());
            undoAction.update();
            redoAction.update();
        }
    }
}

