/*
 * Decompiled with CFR 0.152.
 */
package dbaut.comp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class WizardTextPane
extends JPanel {
    private int FirstLineFontSize = 18;
    private int OtherLineFontSize = 12;
    private WizardTextArea titlearea = new WizardTextArea();
    private WizardTextArea bodyarea = new WizardTextArea();

    public WizardTextPane(int first, int other) {
        this(first, other, Color.WHITE, null);
    }

    public WizardTextPane(int first, int other, String source) {
        this(first, other, Color.WHITE, source);
    }

    public WizardTextPane(int first, int other, Color background) {
        this(first, other, background, null);
    }

    public WizardTextPane(int first, int other, Color background, String source) {
        this.setLayout(new BorderLayout(0, 0));
        if (source != null) {
            int jumpLine = source.indexOf(10);
            if (jumpLine < 0) {
                this.titlearea = new WizardTextArea(source);
                this.bodyarea = new WizardTextArea();
            } else {
                this.titlearea = new WizardTextArea(source.substring(0, jumpLine));
                this.bodyarea = new WizardTextArea(source.substring(jumpLine + 1));
            }
        } else {
            this.titlearea = new WizardTextArea();
            this.bodyarea = new WizardTextArea();
        }
        Color bg = background == null ? UIManager.getColor("Button.background") : background;
        this.setBackground(bg);
        this.titlearea.setBackground(bg);
        this.bodyarea.setBackground(bg);
        if (first > 0) {
            this.FirstLineFontSize = first;
        }
        if (other > 0) {
            this.OtherLineFontSize = other;
        }
        this.titlearea.setFont(new Font(this.titlearea.getFont().getName(), 1, this.FirstLineFontSize));
        this.bodyarea.setFont(new Font(this.bodyarea.getFont().getName(), 0, this.OtherLineFontSize));
        this.bodyarea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.titlearea, "North");
        this.add((Component)this.bodyarea, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (source != null) {
            this.setText(source);
        }
    }

    public void setText(String source) {
        if (source == null) {
            return;
        }
        int jumpLine = source.indexOf(10);
        if (jumpLine < 0) {
            this.titlearea.setText(source);
        } else {
            this.titlearea.setText(source.substring(0, jumpLine));
            this.bodyarea.setText(source.substring(jumpLine + 1));
            this.bodyarea.setCaretPosition(0);
        }
        this.titlearea.setCaretPosition(0);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.titlearea != null) {
            this.titlearea.setBackground(color);
        }
        if (this.bodyarea != null) {
            this.bodyarea.setBackground(color);
        }
    }

    private class WizardTextArea
    extends JTextArea {
        public WizardTextArea() {
            this(null);
        }

        public WizardTextArea(String text) {
            this.setEditable(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setBorder(BorderFactory.createEmptyBorder());
            if (text != null) {
                this.setText(text);
            }
        }
    }
}

