/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import dbaut.svrmgrlib;
import java.util.Vector;

public class JdmTape {
    public static final int DM_FULL_BACKUP_TAPE = 1;
    public static final int DM_FULL_RESTORE_TAPE = 2;
    public static final int ERR_TAPE_ENDTAPE = 10002;
    private static final int LEN_FNAME = 256;
    private long[] desc = null;
    private long[] offset = null;
    private String devname;
    private String dbname;
    private int lastrip = -1;
    private svrmgrlib cfun = new svrmgrlib();

    public int beginBackupTape(String devname, String dbname, int type) {
        this.devname = devname;
        this.dbname = dbname;
        this.desc = new long[1];
        this.offset = new long[1];
        this.offset[0] = 0L;
        return this.cfun.utBeginBackupTape(this.desc, devname.getBytes(), dbname.getBytes(), type);
    }

    public int prepareTapeFile(String logfile, String phyfile) {
        return this.cfun.utPrepareTapeFile(this.desc, logfile.getBytes(), phyfile.getBytes());
    }

    public int ejectTape(String devname) {
        return this.cfun.utEjectTape(devname.getBytes(), this.desc);
    }

    public int loadBackupTape(String devname) {
        int rc = this.cfun.utLoadBackupTape(devname.getBytes(), this.desc);
        if (rc != 0) {
            this.ejectTape(devname);
        }
        return rc;
    }

    public int writeToTape() {
        return this.cfun.utWriteToTape(this.desc, this.offset);
    }

    public int endBackupTape() {
        int rc = this.cfun.utEndBackupTape(this.desc);
        this.desc = null;
        this.offset = null;
        return rc;
    }

    public int beginRestoreTape(String devname, int type) {
        this.devname = devname;
        this.desc = new long[1];
        this.offset = new long[1];
        this.offset[0] = 0L;
        int rc = this.cfun.utBeginRestoreTape(this.desc, devname.getBytes(), type);
        return rc;
    }

    public int setTapeFile(String logfile, String phyfile) {
        return this.cfun.utSetTapeFile(this.desc, logfile.getBytes(), phyfile.getBytes());
    }

    public int endRestoreTape() {
        int rc = this.cfun.utEndRestoreTape(this.desc);
        this.desc = null;
        return rc;
    }

    public Object[] getNextFile() {
        byte[] logbuf = new byte[256];
        byte[] phybuf = new byte[256];
        int[] size = new int[1];
        int rc = this.cfun.utGetNextFile(this.desc, logbuf, phybuf, size);
        Object[] obj = new Object[]{new String(logbuf).trim(), new String(phybuf).trim(), new Integer(size[0])};
        return obj;
    }

    public Vector getFiles() {
        int[] size;
        byte[] phybuf;
        byte[] logbuf;
        int rc;
        Vector<Object[]> v = new Vector<Object[]>();
        int count = this.getFileCount();
        for (int i = 0; i < count && (rc = this.cfun.utGetNextFile(this.desc, logbuf = new byte[256], phybuf = new byte[256], size = new int[1])) == 0; ++i) {
            Object[] obj = new Object[]{new String(logbuf).trim(), new String(phybuf).trim(), new Integer(size[0])};
            v.addElement(obj);
        }
        return v;
    }

    public int readFromTape() {
        int rc = this.cfun.utReadFromTape(this.desc, this.offset);
        return rc;
    }

    public int getFileCount() {
        int[] count = new int[1];
        int rc = this.cfun.utGetFileCount(this.desc, count);
        return count[0];
    }

    public String getTimeStamp() {
        byte[] timestamp = new byte[256];
        int rc = this.cfun.utGetTimeStamp(this.desc, timestamp);
        if (rc != 0) {
            return new String("");
        }
        return new String(timestamp);
    }

    public String getDBName() {
        byte[] dbname = new byte[256];
        int rc = this.cfun.utGetDBName(this.desc, dbname);
        if (rc != 0) {
            return new String("");
        }
        return new String(dbname);
    }

    public String getError(int error) {
        byte[] buffer = new byte[1024];
        int rc = this.cfun.utGetTapeError(error, buffer);
        String s = new String(buffer);
        return s.trim();
    }

    public int getBackupType() {
        int[] type = new int[1];
        int rc = this.cfun.utGetBackupType(this.desc, type);
        return type[0];
    }
}

