/*
 * Decompiled with CFR 0.152.
 */
package dbaut.CommonUt;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class ColumnTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[0];
    private Vector data = new Vector();

    public ColumnTableModel(String[] header) {
        this.columnNames = header;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object[] rowData = (Object[])this.data.elementAt(row);
        return rowData[col];
    }

    public Class getColumnClass(int c) {
        Object[] rowData = (Object[])this.data.elementAt(0);
        return rowData[c].getClass();
    }

    public void addValue(Object[] newData) {
        this.data.addElement(newData);
    }

    public void switchOrder(int godown, int goup) {
        Object downRow = this.data.elementAt(godown);
        Object upRow = this.data.elementAt(goup);
        this.data.setElementAt(downRow, goup);
        this.data.setElementAt(upRow, godown);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Object[] rowData = (Object[])this.data.elementAt(row);
        rowData[col] = value;
    }

    public void removeRow(int row) {
        this.data.removeElementAt(row);
    }

    public void removeAll() {
        this.data.removeAllElements();
    }

    public void addAll(Vector v) {
        this.data.addAll(v);
    }

    public Object getRowValue(int row) {
        return this.data.elementAt(row);
    }
}

