/*
 * Decompiled with CFR 0.152.
 */
package dbatool.tableCell;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import dbatool.DbFrame;
import dbatool.Table.DataTableModel;
import dbatool.tableCell.BlobCellObject;
import dbatool.tableCell.BlobEditor;
import dbatool.tableCell.BlobEditorButtonInterface;
import dbatool.tableCell.JSONJTextPane;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.WebBrowser;
import dbaut.comp.DbaFileChooser;
import dbaut.comp.DbaMenu;
import dbaut.comp.DbaMenuItem;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbaut.system.BackupFile;
import dbaut.text.TextArea;
import dbaut.util.JdbcUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.widget.ScrollingImagePanel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class BlobEditorButton
extends JButton
implements BlobEditorButtonInterface {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.ToolRes", LocaleManager.getLocale());
    private BlobCellObject object = null;
    private BlobEditor editor = null;
    private JTable table = null;
    private DataTableModel model = null;
    private static int displayClobMaxSize = 10240;
    private static int bufferSize = 1024;
    private static int displayBlobMaxSize = 0x300000;
    private Object[] images = new Object[]{new String[]{"BMP", this.res.getString("BMP"), "BMP"}, new String[]{"JPG", this.res.getString("JPG"), "JPEG"}, new String[]{"GIF", this.res.getString("GIF"), "GIF"}, new String[]{"TIF", this.res.getString("TIF"), "TIFF"}};
    private Object[] tmpfiles = new Object[]{new String[]{this.res.getString("html"), "H", "html"}, new String[]{this.res.getString("word_document"), "W", "DOC"}, new String[]{this.res.getString("pdf_document"), "P", "PDF"}, new String[]{this.res.getString("rtf_document"), "R", "RTF"}, new String[]{this.res.getString("wav_audio"), "U", "WAV"}, new String[]{this.res.getString("avi_video"), "V", "AVI"}, new String[]{this.res.getString("ppt_document"), "T", "PPT"}};

    public BlobEditorButton() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setTableAndModel(JTable table, DataTableModel model) {
        this.table = table;
        this.model = model;
    }

    @Override
    public void setEditor(BlobEditor editor) {
        this.editor = editor;
    }

    @Override
    public BlobCellObject getValue() {
        return this.object;
    }

    @Override
    public void setValue(BlobCellObject object) {
        this.object = object;
        if (object != null) {
            this.setText(object.toString());
        }
    }

    private void jbInit() throws Exception {
        this.setBorder(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BlobEditorButton.this.this_mouseClicked(e);
            }
        });
    }

    public void systemfo_actionPerformed(ActionEvent e) {
        this.importblob_actionPerformed(true);
    }

    public void userfo_actionPerformed(ActionEvent e) {
        this.importblob_actionPerformed(false);
    }

    public void setnull_actionPerformed(ActionEvent e) {
        this.object.isNull = true;
        this.object.filename = "";
        int row = this.table.getEditingRow();
        int col = this.table.getEditingColumn();
        this.table.editingStopped(null);
        this.table.editCellAt(row, col);
    }

    public void exportblob_actionPerformed(ActionEvent e) {
        DbaFileChooser chooser = new DbaFileChooser();
        if (DbFrame.frame.px.getBlobFilePath() != null) {
            chooser.setCurrentDirectory(DbFrame.frame.px.getBlobFilePath());
        }
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        DBAResourceBundle res1 = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.BlobDlgRes", LocaleManager.getLocale());
        int state = chooser.showDialog(this, res1.getString("Save"));
        if (state == 0) {
            String s = chooser.getSelectedFile().getAbsolutePath();
            s = s.substring(0, s.indexOf(chooser.getSelectedFile().getName()));
            DbFrame.frame.px.updateVariables(7, s);
            if (this.object.filename != null && this.object.filename.length() > 0) {
                if (!BackupFile.copy(this.object.filename, chooser.getSelectedFile().getPath())) {
                    GuiUt.showErrorDlg(DbFrame.frame, this.object.filename + this.res.getString("Cannot_export") + chooser.getSelectedFile().getPath(), null);
                    return;
                }
            } else if (this.object.oid != null && this.object.oid.length() > 0) {
                this.copyfile(chooser.getSelectedFile());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void auto_actionPerformed(ActionEvent e) {
        int i;
        String ext = null;
        if (this.object.oid == null || this.object.oid.length() == 0) {
            if (this.object.filename == null && this.object.filename.length() <= 0) {
                System.out.println("nothing to display");
                return;
            }
            ext = this.object.filename.toUpperCase();
        } else {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
                String query = "SELECT GETEXTNAME(" + GuiUt.getIDString(this.object.column_name) + ") FROM \"" + this.object.table_owner + "\".\"" + this.object.table_name + "\" WHERE OID = '" + this.object.oid + "'x";
                rs = stmt.executeQuery(query);
                if (rs.next()) {
                    ext = rs.getString(1).trim();
                }
                rs.close();
                stmt.close();
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
                DbaObject.close(rs);
                DbaObject.close(stmt);
                GuiUt.showSQLException(this, null, sqle);
                return;
            }
        }
        String[] s = null;
        for (i = 0; i < this.images.length; ++i) {
            s = (String[])this.images[i];
            if (!ext.endsWith(s[0]) && !ext.endsWith(s[2])) continue;
            this.showImage(s[2]);
            return;
        }
        if (ext.endsWith("HTML") || ext.endsWith("HTM")) {
            this.showTempFile("html");
            return;
        }
        i = 1;
        while (true) {
            if (i >= this.tmpfiles.length) {
                this.text_actionPerformed(e);
                return;
            }
            s = (String[])this.tmpfiles[i];
            if (ext.endsWith(s[2])) {
                this.showTempFile(s[2]);
                return;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void text_actionPerformed(ActionEvent e) {
        String s2;
        String title = null;
        InputStream in = null;
        Statement stmt = null;
        ResultSet rs = null;
        byte[] ba = null;
        String total = null;
        Reader reader = null;
        long len = -1L;
        try {
            if (this.object.filename != null && this.object.filename.length() > 0) {
                title = this.object.filename;
                in = new FileInputStream(this.object.filename);
                ba = new byte[((InputStream)in).available()];
                ((InputStream)in).read(ba);
                total = this.object.type.equalsIgnoreCase("jsoncols") ? new String(ba, "UTF-8") : new String(ba);
            } else if (this.object.oid != null && this.object.oid.length() > 0) {
                String query;
                title = this.object.column_name;
                if (!this.object.isView && (rs = (stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement()).executeQuery(query = "SELECT " + GuiUt.getIDString(this.object.column_name) + " FROM \"" + this.object.table_owner + "\".\"" + this.object.table_name + "\" WHERE OID = '" + this.object.oid + "'x")).next()) {
                    if (this.object.type.equalsIgnoreCase("long varchar") || this.object.type.equalsIgnoreCase("clob") || this.object.type.equalsIgnoreCase("longvarchar")) {
                        in = rs.getAsciiStream(1);
                    } else if (this.object.type.equalsIgnoreCase("nclob")) {
                        Clob c = rs.getClob(1);
                        len = c.length();
                        reader = rs.getCharacterStream(1);
                    } else {
                        in = rs.getBinaryStream(1);
                    }
                }
                if (this.object.isView) {
                    ResultSet vResultSet = this.object.getResultSet();
                    int rowNum = this.object.getRowNum();
                    int colNum = this.object.getColNum();
                    if (vResultSet != null && vResultSet.absolute(rowNum)) {
                        Clob c;
                        if (this.object.type.equalsIgnoreCase("long varchar") || this.object.type.equalsIgnoreCase("clob") || this.object.type.equalsIgnoreCase("longvarchar")) {
                            c = vResultSet.getClob(colNum);
                            len = c.length();
                            in = vResultSet.getAsciiStream(colNum);
                        } else if (this.object.type.equalsIgnoreCase("nclob")) {
                            c = vResultSet.getClob(colNum);
                            len = c.length();
                            reader = vResultSet.getCharacterStream(colNum);
                        } else {
                            Blob b = vResultSet.getBlob(colNum);
                            len = b.length();
                            in = vResultSet.getBinaryStream(colNum);
                        }
                    }
                }
                if (reader != null) {
                    if (len > (long)displayClobMaxSize) {
                        String s1 = this.res.getString("Blob_lenght_is_too_big");
                        s2 = GuiUt.mapStringForProperty(s1, Long.toString(len));
                        GuiUt.showWarningDlg(DbFrame.frame, this.res.getString("Warning"), s2);
                        len = displayClobMaxSize;
                    }
                    char[] cbuf = new char[(int)len / 2];
                    reader.read(cbuf);
                    total = new String(cbuf);
                } else if (in != null) {
                    int i = ((InputStream)in).available();
                    if (i > displayClobMaxSize) {
                        String s1 = this.res.getString("Blob_lenght_is_too_big");
                        String s22 = GuiUt.mapStringForProperty(s1, Integer.toString(i));
                        GuiUt.showWarningDlg(DbFrame.frame, this.res.getString("Warning"), s22);
                        i = displayClobMaxSize;
                    }
                    ba = new byte[i];
                    ((InputStream)in).read(ba);
                    total = this.object.type.equalsIgnoreCase("jsoncols") ? new String(ba, "UTF-8") : new String(ba).trim();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUt.showErrorDlg(DbFrame.frame, ex.getMessage(), null);
        }
        finally {
            DbaObject.close(in);
            DbaObject.close(reader);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        if (total.length() == 0 && ba.length > 0) {
            String s1 = this.res.getString("Cannot_show_as_text_file_format");
            s2 = GuiUt.mapStringForProperty(s1, title);
            GuiUt.showErrorDlg(DbFrame.frame, s2, null);
            return;
        }
        JComponent panel0 = null;
        JScrollPane jsoncolsPanel = null;
        if (total.startsWith("{") && total.endsWith("}") || total.startsWith("[") && total.endsWith("]")) {
            try {
                JsonElement root = new JsonParser().parse(total);
                jsoncolsPanel = new JScrollPane(new JSONJTextPane(root));
            }
            catch (Exception root) {
                // empty catch block
            }
        }
        JScrollPane textPanel = new JScrollPane();
        textPanel.setName("TextContentsPanel");
        TextArea area = new TextArea(total);
        area.setName("TextAreaContents");
        area.setEditable(false);
        textPanel.getViewport().add(area);
        if (jsoncolsPanel != null) {
            JTabbedPane tabbedPanel = new JTabbedPane();
            tabbedPanel.addTab("Text", textPanel);
            tabbedPanel.addTab("Json", jsoncolsPanel);
            panel0 = tabbedPanel;
        } else {
            panel0 = textPanel;
        }
        JDialog dlg = null;
        dlg = this.object.comp != null ? new JDialog((JDialog)this.object.comp, title, true) : new JDialog(DbFrame.frame, title, true);
        dlg.setName("TextContentsDialog");
        dlg.getContentPane().add(panel0);
        dlg.setPreferredSize(new Dimension(400, 300));
        dlg.setSize(400, 300);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.setVisible(true);
        dlg.dispose();
    }

    public void image_actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        String[] t = null;
        for (int i = 0; i < this.images.length; ++i) {
            t = (String[])this.images[i];
            if (!s.equals(t[1])) continue;
            this.showImage(t[2]);
            return;
        }
    }

    public void tmpfile_actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        String[] t = null;
        for (int i = 0; i < this.tmpfiles.length; ++i) {
            t = (String[])this.tmpfiles[i];
            if (!s.equals(t[0])) continue;
            this.showTempFile(t[2]);
            return;
        }
    }

    private void showTempFile(String ext) {
        if (this.object.filename != null && this.object.filename.length() > 0) {
            WebBrowser.displayURL(DbFrame.frame, this.object.filename);
            return;
        }
        if (this.object.oid != null && this.object.oid.length() > 0 && !this.object.isNull) {
            try {
                File f = File.createTempFile(this.object.column_name + this.object.oid, "." + ext);
                this.copyfile(f);
                WebBrowser.displayURL(DbFrame.frame, f.getPath());
                return;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                GuiUt.showErrorDlg(DbFrame.frame, ioe.getMessage(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showImage(String type) {
        String title = null;
        RenderedOp img = null;
        try {
            block14: {
                block13: {
                    if (this.object.filename == null || this.object.filename.length() <= 0) break block13;
                    img = JAI.create((String)"fileload", (Object)this.object.filename);
                    title = this.object.filename;
                    break block14;
                }
                if (this.object.oid != null && this.object.oid.length() > 0) {
                    InputStream in;
                    ResultSet rs;
                    Statement stmt;
                    block12: {
                        title = this.object.oid;
                        stmt = null;
                        rs = null;
                        in = null;
                        try {
                            String query;
                            if (!this.object.isView && (rs = (stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement()).executeQuery(query = "SELECT " + GuiUt.getIDString(this.object.column_name) + " FROM \"" + this.object.table_owner + "\".\"" + this.object.table_name + "\" WHERE OID = '" + this.object.oid + "'x")).next()) {
                                in = rs.getBinaryStream(1);
                            }
                            if (this.object.isView) {
                                ResultSet vResultSet = this.object.getResultSet();
                                int rowNum = this.object.getRowNum();
                                int colNum = this.object.getColNum();
                                if (vResultSet != null && vResultSet.absolute(rowNum)) {
                                    in = vResultSet.getBinaryStream(colNum);
                                }
                            }
                            if (in == null) break block12;
                            int len = in.available();
                            if (len > displayBlobMaxSize) {
                                String str1 = this.res.getString("The_length_of_blob");
                                String str2 = this.res.getString("bytes");
                                String str3 = this.res.getString("Suggest_to_export");
                                String str = str1 + len + str2 + str3;
                                GuiUt.showWarningDlg(DbFrame.frame, this.res.getString("Warning"), str);
                                break block12;
                            }
                            byte[] ba = new byte[in.available()];
                            in.mark(0);
                            in.read(ba);
                            ByteArraySeekableStream bass = new ByteArraySeekableStream(ba);
                            img = JAI.create((String)type, (Object)bass);
                            in.reset();
                        }
                        catch (Exception ex) {
                            try {
                                ex.printStackTrace();
                                GuiUt.showErrorDlg(DbFrame.frame, ex.getMessage(), null);
                            }
                            catch (Throwable throwable) {
                                DbaObject.close(in);
                                DbaObject.close(rs);
                                DbaObject.close(stmt);
                                throw throwable;
                            }
                            DbaObject.close(in);
                            DbaObject.close(rs);
                            DbaObject.close(stmt);
                        }
                    }
                    DbaObject.close(in);
                    DbaObject.close(rs);
                    DbaObject.close(stmt);
                }
            }
            if (img == null) {
                return;
            }
            ScrollingImagePanel display = new ScrollingImagePanel((RenderedImage)img, 400, 300);
            final JDialog dlg = new JDialog(DbFrame.frame, title, true);
            dlg.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    dlg.dispose();
                    System.gc();
                }
            });
            dlg.getContentPane().add((Component)display);
            dlg.setSize(400, 300);
            GuiUt.setCenterLocation(DbFrame.frame, dlg);
            dlg.setVisible(true);
            dlg.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
            GuiUt.showErrorDlg(DbFrame.frame, this.res.getString("Fail_to_show_as") + " " + type + " " + this.res.getString("Fail_image"), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyfile(File dest) {
        Statement stmt = null;
        ResultSet rs = null;
        FileOutputStream out = null;
        long len = 0L;
        Blob b = null;
        try {
            String query;
            if (!this.object.isView && (rs = (stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement()).executeQuery(query = "SELECT " + GuiUt.getIDString(this.object.column_name) + " FROM \"" + this.object.table_owner + "\".\"" + this.object.table_name + "\" WHERE OID = '" + this.object.oid + "'x")).next()) {
                b = rs.getBlob(1);
            }
            if (this.object.isView) {
                ResultSet vResultSet = this.object.getResultSet();
                int rowNum = this.object.getRowNum();
                int colNum = this.object.getColNum();
                if (vResultSet != null && vResultSet.absolute(rowNum)) {
                    b = vResultSet.getBlob(colNum);
                }
            }
            if (b != null) {
                out = new FileOutputStream(dest);
                len = b.length();
                byte[] buffer = null;
                for (long pos = 1L; pos < len + 1L; pos += (long)bufferSize) {
                    long offset;
                    buffer = len + 1L < (long)bufferSize ? b.getBytes(pos, (int)len) : ((offset = len + 1L - pos) < (long)bufferSize ? b.getBytes(pos, (int)offset) : b.getBytes(pos, bufferSize));
                    ((OutputStream)out).write(buffer);
                }
                out.flush();
                ((OutputStream)out).close();
                JdbcUtil.free(b);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            GuiUt.showSQLException(this, null, sqle);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            GuiUt.showErrorDlg(DbFrame.frame, ioe.getMessage(), null);
        }
        finally {
            DbaObject.close(out);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
    }

    private void importblob_actionPerformed(boolean asSystemFileObject) {
        DbaFileChooser chooser = new DbaFileChooser();
        if (DbFrame.frame.px.getBlobFilePath() != null) {
            chooser.setCurrentDirectory(DbFrame.frame.px.getBlobFilePath());
        }
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        int state = chooser.showOpenDialog(this);
        if (state == 0) {
            this.object.filename = chooser.getSelectedFile().getPath();
            this.object.asSystemFileObject = asSystemFileObject;
            this.object.size = 0L;
            int row = this.table.getEditingRow();
            int col = this.table.getEditingColumn();
            this.table.editingStopped(null);
            this.table.setRowSelectionInterval(row, row);
            this.table.editCellAt(row, col);
            String s = chooser.getSelectedFile().getAbsolutePath();
            s = s.substring(0, s.indexOf(chooser.getSelectedFile().getName()));
            DbFrame.frame.px.updateVariables(7, s);
        }
    }

    private void this_mouseClicked(MouseEvent e) {
        int i;
        JPopupMenu menu = new JPopupMenu();
        menu.setName("BlobEditorButtonPopupMenu");
        if (!this.object.isView) {
            JMenuItem importblob;
            if (this.object.type.equalsIgnoreCase("FILE")) {
                importblob = new DbaMenu(this.res.getString("import"), 'i');
                importblob.setName("ImportMenuItem");
                ((JMenu)importblob).add(new DbaMenuItem(this.res.getString("Store_content"), 'C', new ReflectionAction(this, "systemfo_actionPerformed")));
                ((JMenu)importblob).add(new DbaMenuItem(this.res.getString("Store_file_name"), 'F', new ReflectionAction(this, "userfo_actionPerformed")));
                menu.add(importblob);
                importblob.setEnabled(this.model.isEditable);
            } else {
                importblob = new DbaMenuItem(this.res.getString("import"), 'i', new ReflectionAction(this, "systemfo_actionPerformed"));
                importblob.setName("ImportMenuItem");
                menu.add(importblob);
                importblob.setEnabled(this.model.isEditable);
            }
        }
        DbaMenuItem exportblob = new DbaMenuItem(this.res.getString("export"), 'e', new ReflectionAction(this, "exportblob_actionPerformed"));
        exportblob.setName("ExportMenuItem");
        DbaMenuItem setnull = new DbaMenuItem(this.res.getString("Set_null"), 'u', new ReflectionAction(this, "setnull_actionPerformed"));
        setnull.setName("SetNullMenuItem");
        menu.add(exportblob);
        if (!this.object.isView) {
            menu.add(setnull);
            menu.addSeparator();
        }
        DbaMenu viewer_menu = new DbaMenu(this.res.getString("view_of"), 'v');
        DbaMenuItem auto = new DbaMenuItem(this.res.getString("auto"), 'a', new ReflectionAction(this, "auto_actionPerformed"));
        DbaMenuItem text = new DbaMenuItem(this.res.getString("text"), 't', new ReflectionAction(this, "text_actionPerformed"));
        text.setName("TextMenuItem");
        if (!this.object.isView) {
            viewer_menu.add(auto);
            viewer_menu.addSeparator();
        }
        viewer_menu.add(text);
        String[] t = null;
        for (i = 0; i < this.images.length; ++i) {
            t = (String[])this.images[i];
            viewer_menu.add(new DbaMenuItem(t[1], t[1].charAt(0), new ReflectionAction(this, "image_actionPerformed")));
        }
        viewer_menu.addSeparator();
        if (DbFrame.isWindows) {
            for (i = 0; i < this.tmpfiles.length; ++i) {
                t = (String[])this.tmpfiles[i];
                viewer_menu.add(new DbaMenuItem(t[0], t[1].charAt(0), new ReflectionAction(this, "tmpfile_actionPerformed")));
            }
        }
        if (this.object.filename != null && this.object.filename.length() > 0 || this.object.oid != null && this.object.oid.length() > 0 && !this.object.isNull) {
            exportblob.setEnabled(true);
            viewer_menu.setEnabled(true);
            setnull.setEnabled(this.model.isEditable);
        } else {
            exportblob.setEnabled(false);
            viewer_menu.setEnabled(false);
            setnull.setEnabled(false);
        }
        menu.add(viewer_menu);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }
}

