/*
 * Decompiled with CFR 0.152.
 */
package dbatool.View;

import dbatool.DbFrame;
import dbatool.View.ViewPermissionRowInfo;
import dbatool.tableModel.ColumnSorting;
import dbaut.resource.DBAResourceBundle;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class ViewPermissionTableModel
extends AbstractTableModel
implements ColumnSorting {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private String[] columnNames = new String[]{this.res.getString("Type"), this.res.getString("User_Group"), this.res.getString("Select")};
    private Vector data = new Vector();
    public boolean isEditable = false;
    private String view_owner = null;
    private String view_name = null;

    public ViewPermissionTableModel(String view_owner, String view_name) {
        this.view_name = view_name;
        this.view_owner = view_owner;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        ViewPermissionRowInfo rowData = (ViewPermissionRowInfo)this.data.elementAt(row);
        return rowData.getValueAt(col);
    }

    public Class getColumnClass(int c) {
        ViewPermissionRowInfo rowData = (ViewPermissionRowInfo)this.data.elementAt(0);
        return rowData.getValueAt(c).getClass();
    }

    public void addValue(ViewPermissionRowInfo newData) {
        this.data.addElement(newData);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        ViewPermissionRowInfo rowData = (ViewPermissionRowInfo)this.data.elementAt(row);
        if (!this.isEditable) {
            rowData.setValueAt(value, col);
            return;
        }
        rowData.setValueAt(value, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!this.isEditable) {
            return false;
        }
        if (col == ViewPermissionRowInfo.NAME || col == ViewPermissionRowInfo.TYPE) {
            return false;
        }
        Boolean dba = (Boolean)this.getValueAt(row, ViewPermissionRowInfo.DBA);
        Boolean resource = (Boolean)this.getValueAt(row, ViewPermissionRowInfo.RESOURCE);
        String user = (String)this.getValueAt(row, ViewPermissionRowInfo.NAME);
        if (dba.booleanValue()) {
            return false;
        }
        return resource == false || !user.equals(this.view_owner);
    }

    public void removeAll() {
        this.data.removeAllElements();
    }

    public Vector getUpdatingPermission(String table_owner, String table_name) {
        Vector<String> vector = new Vector<String>();
        ViewPermissionRowInfo aRow = null;
        int count = this.data.size();
        for (int i = 0; i < count; ++i) {
            String revoke;
            aRow = (ViewPermissionRowInfo)this.data.elementAt(i);
            String grant = aRow.getGrantInfo(table_owner, table_name);
            if (grant.length() > 0) {
                vector.addElement(grant);
            }
            if ((revoke = aRow.getRevokeInfo(table_owner, table_name)).length() <= 0) continue;
            vector.addElement(revoke);
        }
        return vector;
    }

    public ViewPermissionRowInfo getRowByGrantee(String grantee) {
        int count = this.data.size();
        String name = null;
        for (int i = 0; i < count; ++i) {
            name = (String)this.getValueAt(i, ViewPermissionRowInfo.NAME);
            if (!name.equals(grantee)) continue;
            return (ViewPermissionRowInfo)this.data.elementAt(i);
        }
        return null;
    }

    @Override
    public void switchOrder(int godown, int goup) {
        Object downRow = this.data.elementAt(godown);
        Object upRow = this.data.elementAt(goup);
        this.data.setElementAt(downRow, goup);
        this.data.setElementAt(upRow, godown);
    }
}

