/*
 * Decompiled with CFR 0.152.
 */
package dbatool.TreeNode;

import dbatool.DbFrame;
import dbatool.Popupmenu.List_Popupmenu;
import dbatool.TreeNode.DBATreeNode;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;

public class DatabaseTreeNode
extends DBATreeNode {
    protected DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private boolean isFreeze = false;
    private static final String[] helpids = new String[]{"tablespace.list", "table.list", "view.list", "lock.info", "status.info", "session.info", "pendingtransaction.info", "monitor.info", "user.list", "group.list", "synonym.list", "domain.list", "index.list", "textindex.list", "foreignkey.list", "trigger.list", "storedcommand.list", "storedprocedure.list", "databaselink.list", "schedule.list", "replication.list", "ivftextindex.list", "schema.list", "acl.list", "sysconfig.info", "updatestatistics.info", "JournalStatus.info"};
    private static final String[] resources = new String[]{"Tablespaces", "Tables", "Views", "Lock", "Status", "Session", "Pending_Transaction", "Database_Monitor", "User", "Group", "Synonym", "Domain", "Indexes", "Text_Indexes", "Foreign_Key", "Triggers", "Stored_Command", "Stored_Procedure", "Database_Link", "Schedule", "Replication", "Ivf_Text_Indexes", "Schema", "Acl", "SysConfig", "UpdateStatistics", "JournalStatus"};
    String[] images = new String[]{"/jdbaimages/tablespace.gif", "/jdbaimages/table.gif", "/jdbaimages/view.gif", "/jdbaimages/lock.gif", "/jdbaimages/status.gif", "/jdbaimages/session.gif", "/jdbaimages/pending_tranx.gif", "/jdbaimages/database_monitor.gif", "/jdbaimages/user.gif", "/jdbaimages/group.gif", "/jdbaimages/synonym.gif", "/jdbaimages/domain.gif", "/jdbaimages/index.gif", "/jdbaimages/text_index.gif", "/jdbaimages/foreign_key.gif", "/jdbaimages/trigger.gif", "/jdbaimages/stored_command.gif", "/jdbaimages/stored_procedure.gif", "/jdbaimages/database_link.gif", "/jdbaimages/schedule.gif", "/jdbaimages/replication.gif", "/jdbaimages/ivf_text_index.gif", "/jdbaimages/schema.gif", "/jdbaimages/acl.gif", "/jdbaimages/sysConfig.gif", "/jdbaimages/session.gif", "/jdbaimages/journalstatus.gif"};
    private static final String[] classnames = new String[]{"dbatool.Tablespace.TableSpaceList", "dbatool.Table.TableList", "dbatool.View.ViewList", "dbatool.Monitor.LockInfo", "dbatool.Monitor.StatusInfo", "dbatool.Monitor.SessionInfo", "dbatool.Monitor.PendingTranxInfo", "dbatool.Monitor.MonitorInfo", "dbatool.User.UserList", "dbatool.Group.GroupList", "dbatool.Synonym.SynonymList", "dbatool.Domain.DomainList", "dbatool.Index.IndexList", "dbatool.TextIndex.TextIndexList", "dbatool.ForeignKey.ForeignKeyList", "dbatool.Trigger.TriggerList", "dbatool.StoredCommand.StoredCommandList", "dbatool.StoredProcedure.StoredProcedureList", "dbatool.DatabaseLink.DatabaseLinkList", "dbatool.Schedule.ScheduleList", "dbatool.Replication.ReplicationList", "dbatool.IVFTextIndex.IVFTextIndexList", "dbatool.Schema.SchemaList", "dbatool.Acl.AclList", "dbatool.Monitor.SysConfigInfo", "dbatool.Monitor.UpdateStatisticsInfo", "dbatool.Monitor.JournalStatus"};
    public final int type;
    private ImageIcon icon = null;
    private String toString = null;
    public static final int TABLESPACE = 0;
    public static final int TABLE = 1;
    public static final int VIEW = 2;
    public static final int LOCK = 3;
    public static final int STATUS = 4;
    public static final int SESSION = 5;
    public static final int PENDINGTRANX = 6;
    public static final int MONITOR = 7;
    public static final int USER = 8;
    public static final int GROUP = 9;
    public static final int SYNONYM = 10;
    public static final int DOMAIN = 11;
    public static final int INDEX = 12;
    public static final int TEXTINDEX = 13;
    public static final int FOREIGNKEY = 14;
    public static final int TRIGGER = 15;
    public static final int COMMAND = 16;
    public static final int PROCEDURE = 17;
    public static final int DATABASELINK = 18;
    public static final int SCHEDULE = 19;
    public static final int REPLICATION = 20;
    public static final int IVFTEXTINDEX = 21;
    public static final int SCHEMA = 22;
    public static final int ACL = 23;
    public static final int SYSCONFIG = 24;
    public static final int UPDATESTATISTICS = 25;
    public static final int JOURNALSTATUS = 26;
    private static final int INTERNAL_MASK = 100;
    public static final int TABLESPACE_INFO = 100;
    public static final int TABLE_INFO = 101;
    public static final int TABLE_SCHEMA = 201;
    public static final int TABLE_PROPERTIES = 301;
    public static final int TABLE_PERMISSION = 401;
    public static final int TABLE_DEPENDENCY = 501;
    public static final int TABLE_STATISTICS = 601;
    public static final int TABLE_DATA = 701;
    public static final int VIEW_INFO = 102;
    public static final int USER_INFO = 108;
    public static final int COMMAND_INFO = 116;

    public DatabaseTreeNode(int type) {
        this.type = type;
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
        this.icon = DBAImageResource.getResource(this.getClass(), this.images[type]);
        this.toString = this.res.getString(resources[type]);
    }

    public int getType() {
        return this.type;
    }

    @Override
    public String getHelpID() {
        return helpids[this.type];
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = DbFrame.frame.getResourceBundle();
        this.toString = this.res.getString(resources[this.type]);
    }

    @Override
    public ImageIcon getImageIcon() {
        return this.icon;
    }

    @Override
    public void displayObject() {
        try {
            JTabbedPane tp = (JTabbedPane)Class.forName(classnames[this.type]).newInstance();
            DbFrame.frame.setContentPanel(tp);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    @Override
    public void displayMenu(MouseEvent e) {
        List_Popupmenu popup = new List_Popupmenu(this);
        popup.show(e.getComponent(), e.getX(), e.getY());
        popup = null;
    }

    @Override
    public void refresh() {
        switch (this.type) {
            case 0: {
                DbFrame.frame.treePanel.refreshTableSpaceTree();
                break;
            }
            case 1: {
                DbFrame.frame.treePanel.refreshTableTree();
                break;
            }
            case 2: {
                DbFrame.frame.treePanel.refreshViewTree();
                break;
            }
            case 8: {
                DbFrame.frame.treePanel.refreshUserTree();
                break;
            }
            case 9: {
                DbFrame.frame.treePanel.refreshGroupTree();
                break;
            }
            case 16: {
                DbFrame.frame.treePanel.refreshCommandTree();
                break;
            }
            case 17: {
                DbFrame.frame.treePanel.refreshProcedureTree();
                break;
            }
            case 19: {
                DbFrame.frame.treePanel.refreshScheduleTree();
                break;
            }
            case 20: {
                DbFrame.frame.treePanel.refreshTableSpaceTree();
                break;
            }
            case 15: {
                DbFrame.frame.treePanel.refreshTriggerTree();
                break;
            }
        }
        this.displayObject();
    }
}

