/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Tablespace;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.ComponentRole;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbatool.tableModel.FileSize;
import dbaut.DbaObject;
import dbaut.DbaUtDef;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;

public class TableSpaceList
extends DbaTabbedPane
implements ComponentPrivilege,
ComponentRole {
    public static final String DEFAULT_TS = "DEFTABLESPACE";
    public static final String SYSTEM_TS = "SYSTABLESPACE";
    public static final String TEMP_TS = "TMPTABLESPACE";
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private DbaTableModel model1 = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table1 = null;
    private DbaButton Tablespace_Create_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Tablespace_Create_Button_actionPerformed"));
    private DbaButton Tablespace_Drop_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Tablespace_Drop_Button_actionPerformed"));
    private int byteperpage = DbFrame.conn_DatabaseConnection.getDbPageSize();
    private int byteperframe = DbFrame.conn_DatabaseConnection.getBlobFrameSize();
    private int bepeIndex = DbFrame.conn_DatabaseConnection.getBePeIndex();
    private int NAME = 0;
    private int TYPE = 1;
    private int READ_ONLY_MODE = 2;
    private int NUM_OF_FILES = 3;
    private int TOTAL_PAGES = 4;
    private int FREE_PAGES = 5;
    private int TOTAL_FRAMES = 6;
    private int FREE_FRAMES = 7;
    private int CREATE_TIME = 8;

    public TableSpaceList() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String[] columnNames = new String[]{this.res.getString("Name"), this.res.getString("Type"), this.res.getString("Read_Only_Mode_a"), this.res.getString("num_of_files"), this.res.getString("Total_Pages"), this.res.getString("Free_Pages"), this.res.getString("Total_Frames"), this.res.getString("Free_Frames"), this.res.getString("Creation_Time")};
        this.model1 = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model1);
        this.table1 = new JTable(this.absModel);
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "tablespace.list");
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setName("TablespacesTablePanel");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setName("TablespacesButtonPanel");
        this.model1.setTargetTableValueChanged(this, "table1_valueChanged");
        this.setPreferredSize(new Dimension(420, 420));
        jPanel1.setLayout(new BorderLayout());
        jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        this.table1.setSelectionMode(0);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table1_valueChanged"));
        this.table1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableSpaceList.this.table1_mouseClicked(e);
            }
        });
        this.add((Component)jPanel1, this.res.getTitle("Tablespaces"));
        jPanel1.add((Component)jScrollPane1, "Center");
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.Tablespace_Create_Button, null);
        jPanel2.add((Component)this.Tablespace_Drop_Button, null);
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.getTableSpaceList();
        this.table1.setAutoResizeMode(4);
        this.initColumnSizes(this.table1);
        this.authority = DbaAuthorityFactory.create(this);
        if (DbFrame.frame.isLocalHost) {
            this.authority.authoriseOnce();
        } else {
            this.grantOnce(false);
        }
        this.grant(false);
        this.setName("TablespacesTabbedPane");
        this.Tablespace_Drop_Button.setName("DropButton");
        this.Tablespace_Create_Button.setName("CreateButton");
        this.table1.setName("TablespacesTable");
    }

    @Override
    public int getComponentType() {
        return 0;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Tablespace_Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Tablespace_Drop_Button.setEnabled(enabled);
    }

    @Override
    public boolean isAuthorised() {
        int selectedRow = this.table1.getSelectedRow();
        String s = this.absModel.getValueAt(selectedRow, 0).toString().trim();
        return !s.equals(SYSTEM_TS) && !s.equals(DEFAULT_TS);
    }

    public void table1_valueChanged(ListSelectionEvent e) {
        if (this.absModel.getRowCount() <= 0) {
            this.grant(false);
        } else {
            this.authority.authorise();
        }
    }

    private void getTableSpaceList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select TS_NAME, TS_TYPE, NUM_FILES, NUM_PAGES, NUM_FREE_PAGES, NUM_FRAMES, NUM_FREE_FRAMES, DWTOSTR(CREATE_TIME) from SYSTEM.SYSTABLESPACE";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.model1.addValue(new DBARowInfo(this.getRowInfo(rs.getString(1), rs.getShort(2), rs.getShort(2), rs.getInt(3), rs.getInt(4), rs.getInt(5), rs.getInt(6), rs.getInt(7), rs.getString(8))));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            DbFrame.frame.setStatusDisc(this.res.getString("Number_of_tablespaces") + " " + this.model1.getRowCount());
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        Object comp = null;
        int[] sizes = new int[]{120, 80, 100, 60, 80, 80, 80, 80, 100};
        for (int i = 0; i < 9; ++i) {
            column = table.getColumnModel().getColumn(i);
            column.setPreferredWidth(sizes[i]);
        }
    }

    private Object[] getRowInfo(String name, short type, short read_only, int num_of_files, int total_pages, int free_pages, int total_frames, int free_frames, String create_time) {
        Object[] data = new Object[9];
        data[this.NAME] = GuiUt.rightTrim(name);
        switch (type) {
            case 0: {
                data[this.TYPE] = new String(this.res.getString("Regular"));
                data[this.READ_ONLY_MODE] = new String(this.res.getString("Read_Write"));
                break;
            }
            case 1: {
                data[this.TYPE] = new String(this.res.getString("Auto_Extend"));
                data[this.READ_ONLY_MODE] = new String(this.res.getString("Read_Write"));
                break;
            }
            case 2: {
                data[this.TYPE] = new String(this.res.getString("Regular"));
                data[this.READ_ONLY_MODE] = new String(this.res.getString("Read_Only"));
                break;
            }
            case 3: {
                data[this.TYPE] = new String(this.res.getString("Auto_Extend"));
                data[this.READ_ONLY_MODE] = new String(this.res.getString("Read_Only"));
            }
        }
        data[this.NUM_OF_FILES] = new Integer(num_of_files);
        data[this.TOTAL_PAGES] = new FileSize(total_pages, (long)total_pages * (long)this.byteperpage);
        data[this.FREE_PAGES] = new FileSize(free_pages, (long)free_pages * (long)this.byteperpage);
        long BE = (long)Math.ceil((double)total_frames / (double)(1 + DbaUtDef.PE_PER_BE[this.bepeIndex] * (DbaUtDef.PG_PER_PE[this.bepeIndex] + 1)));
        long PE = (long)Math.ceil((double)((long)total_frames - BE) / (double)(DbaUtDef.PG_PER_PE[this.bepeIndex] + 1));
        long temp = (long)total_frames * (long)this.byteperframe - (long)(this.byteperframe - this.byteperpage) * (PE + BE);
        data[this.TOTAL_FRAMES] = new FileSize(total_frames, temp);
        data[this.FREE_FRAMES] = new FileSize(free_frames, (long)free_frames * (long)this.byteperframe);
        data[this.CREATE_TIME] = create_time;
        return data;
    }

    public void Tablespace_Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(0);
        DbFrame.frame.treePanel.refreshTableSpaceTree();
    }

    public void Tablespace_Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        String ts_name = (String)this.model1.getValueAt(row, this.NAME);
        if (DbFrame.conn_DatabaseConnection.dropTablespace(ts_name, false)) {
            DbFrame.frame.treePanel.afterDropObject(0);
        }
    }

    void table1_mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            int row = this.table1.getSelectedRow();
            if (row < 0 || row >= this.absModel.getRowCount()) {
                return;
            }
            String ts_name = (String)this.absModel.getValueAt(row, 0);
            DbFrame.frame.treePanel.openTablespaceTree(ts_name);
        }
    }

    public static boolean isSystemTS(String tsName) {
        boolean is = false;
        is = tsName.equals(DEFAULT_TS) ? true : (tsName.equals(SYSTEM_TS) ? true : tsName.equals(TEMP_TS));
        return is;
    }
}

