/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Tablespace;

import dbatool.DbFrame;
import dbatool.HelpButton;
import dbaut.CommonUt.CheckingStatusRenderer;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MoveTableSpaceDialog
extends JDialog {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private DbaButton okButton = new DbaButton(new Dimension(80, 24), this.res.getString("OK"), 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "okButtonActionPerformed"));
    private DbaButton cancelButton = new DbaButton(new Dimension(80, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private DbaButton finishButton = new DbaButton(new Dimension(80, 24), this.res.getString("Finish"), 'F', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "finishButtonActionPerformed"));
    private JCheckBox fastcopyBox = new JCheckBox();
    private HelpButton helpButton = new HelpButton();
    private Frame frame = null;
    private WindowAdapter closeListener = null;
    private JComboBox tsNameComboBox = new JComboBox();
    private ArrayList<String[]> tables = null;
    private String currentTsName = null;
    private int refreshTableCell = 0;
    private JTable table = null;
    private JTable infoTable1 = new JTable(1, 3);
    private JTable infoTable2 = new JTable(2, 4);
    private String defualtTsName = null;
    private DefaultTableModel tableModel = null;
    private Boolean isIndex = false;
    private Boolean stopFlag = false;
    private Boolean hasAlert = false;
    Thread t = null;

    public MoveTableSpaceDialog(Frame frame, String tsName, ArrayList<String[]> tables, String defualtTsName, Boolean isIndex) {
        super(frame, true);
        this.isIndex = isIndex;
        this.frame = frame;
        this.currentTsName = tsName;
        this.tables = tables;
        this.defualtTsName = defualtTsName;
        this.init();
        this.setPreferredSize(new Dimension(600, 500));
        this.pack();
        GuiUt.setCenterLocation(frame, this);
        this.setVisible(true);
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.okButton.requestFocus();
        }
    }

    private void init() {
        this.setName("MoveTableSpaceDialog");
        this.tsNameComboBox.setName("TSNameComboBox");
        this.fastcopyBox.setName("FastCopyBox");
        this.okButton.setName("OKButton");
        this.cancelButton.setName("CancelButton");
        if (this.isIndex.booleanValue()) {
            this.setTitle(this.res.getString("Move_Index"));
        } else {
            this.setTitle(this.res.getString("Move_Tables"));
        }
        this.tableModel = new DefaultTableModel((Object[][])null, new String[]{this.res.getString("Table"), this.res.getString("Status"), this.res.getString("Message"), this.res.getString("Index")});
        this.setDefaultCloseOperation(0);
        this.closeListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MoveTableSpaceDialog.this.finishButtonActionPerformed(null);
            }
        };
        this.addWindowListener(this.closeListener);
        DbFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "MoveTablesDialog", null);
        this.table = new JTable(this.tableModel);
        this.table.setEnabled(false);
        ImageObserver observer = new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if ((infoflags & 0x30) != 0) {
                    Rectangle re = MoveTableSpaceDialog.this.table.getCellRect(MoveTableSpaceDialog.this.refreshTableCell, 1, false);
                    MoveTableSpaceDialog.this.table.repaint(re);
                }
                return (infoflags & 0xA0) == 0;
            }
        };
        TableColumnModel tcmodel = this.table.getColumnModel();
        TableColumn col = tcmodel.getColumn(0);
        col.setPreferredWidth(130);
        tcmodel.getColumn(1).setCellRenderer(new CheckingStatusRenderer(observer));
        tcmodel.getColumn(1).setPreferredWidth(50);
        tcmodel.getColumn(2).setPreferredWidth(300);
        tcmodel.getColumn(3).setPreferredWidth(90);
        Container container = this.getContentPane();
        JPanel tsNamePanel = new JPanel();
        tsNamePanel.setBorder(BorderFactory.createEtchedBorder());
        tsNamePanel.add(new JLabel(this.res.getString("Move_To_Tablespace")));
        this.tsNameComboBox.setPreferredSize(new Dimension(160, 24));
        this.tsNameComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveTableSpaceDialog.this.tsNameComboBoxActionPerformed(e);
            }
        });
        tsNamePanel.add(this.tsNameComboBox);
        this.fastcopyBox.setText(this.res.getString("Fast_Copy"));
        this.fastcopyBox.setSelected(false);
        tsNamePanel.add(this.fastcopyBox);
        container.add((Component)tsNamePanel, "North");
        JPanel contentPanel = new JPanel(new BorderLayout());
        JPanel infoPanel = new JPanel();
        this.initInfoPanel(infoPanel);
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        jScrollPane1.getViewport().add((Component)this.table, null);
        contentPanel.add((Component)infoPanel, "North");
        contentPanel.add(jScrollPane1);
        contentPanel.setBorder(new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(5, 15, 5, 15);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        });
        container.add(contentPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.finishButton);
        this.finishButton.setVisible(false);
        buttonPanel.add(this.helpButton);
        this.cancelButton.setVisible(false);
        container.add((Component)buttonPanel, "South");
        this.initTSName();
        this.initTables();
    }

    private void tsNameComboBoxActionPerformed(ActionEvent e) {
        if (this.tsNameComboBox.getSelectedItem() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    public void okButtonActionPerformed(ActionEvent e) {
        final String tsName = (String)this.tsNameComboBox.getSelectedItem();
        Connection dbconn = DbFrame.conn_DatabaseConnection.getDbConnection();
        try {
            if (this.fastcopyBox.isSelected()) {
                ((JdbcOdbcConnection)dbconn).setOption(1441, 1);
            } else {
                ((JdbcOdbcConnection)dbconn).setOption(1441, 0);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        this.t = new Thread(){

            @Override
            public void run() {
                MoveTableSpaceDialog.this.process(tsName);
                try {
                    ((JdbcOdbcConnection)DbFrame.conn_DatabaseConnection.getDbConnection()).setOption(1441, 0);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        };
        this.t.start();
    }

    private void process(String tsName) {
        String sql;
        Connection con = DbFrame.conn_DatabaseConnection.getDbConnection();
        String allSQL = "";
        String[] allsql = new String[this.tables.size()];
        for (int i = 0; i < this.tables.size(); ++i) {
            String[] data = this.tables.get(i);
            String ownName = data[0];
            String tbName = data[1];
            sql = "";
            if (this.isIndex.booleanValue()) {
                String idxName = data[2];
                sql = "rebuild index " + GuiUt.getIDString(idxName) + " for " + GuiUt.getIDString(ownName) + "." + GuiUt.getIDString(tbName) + " in " + GuiUt.getIDString(tsName);
            } else {
                sql = "alter table " + GuiUt.getIDString(ownName) + "." + GuiUt.getIDString(tbName) + " move tablespace " + GuiUt.getIDString(tsName);
            }
            allSQL = this.isWindows() ? allSQL + sql + ";\r\n" : allSQL + sql + ";\n";
            allsql[i] = sql;
        }
        if (!GuiUt.showSqlScript(allSQL)) {
            this.t = null;
            return;
        }
        this.tsNameComboBox.setEnabled(false);
        this.okButton.setVisible(false);
        this.cancelButton.setVisible(true);
        this.removeWindowListener(this.closeListener);
        ImageIcon working = DBAImageResource.getResource(this.getClass(), "/dbautimages/working.gif");
        final Rectangle re = this.infoTable1.getCellRect(0, 0, false);
        working.setImageObserver(new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if ((infoflags & 0x30) != 0) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(60L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    MoveTableSpaceDialog.this.infoTable1.repaint(re);
                }
                return (infoflags & 0xA0) == 0;
            }
        });
        ((DefaultTableCellRenderer)this.infoTable1.getCellRenderer(0, 0)).setIcon(working);
        this.infoTable1.repaint(re);
        for (int i = 0; i < this.tables.size(); ++i) {
            if (this.stopFlag.booleanValue()) {
                ((DefaultTableCellRenderer)this.infoTable1.getCellRenderer(0, 0)).setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/stop.jpg"));
                this.finishButton.setEnabled(true);
                this.addWindowListener(this.closeListener);
                return;
            }
            final int index = i;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MoveTableSpaceDialog.this.tableModel.setValueAt(new Integer(1), index, 1);
                    MoveTableSpaceDialog.this.tableModel.fireTableChanged(new TableModelEvent(MoveTableSpaceDialog.this.tableModel));
                }
            });
            this.refreshTableCell = i;
            sql = allsql[i];
            Statement stmt = null;
            try {
                stmt = con.createStatement();
                stmt.execute(sql);
                stmt.close();
            }
            catch (SQLException e1) {
                DbaObject.close(stmt);
                e1.printStackTrace();
                this.hasAlert = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MoveTableSpaceDialog.this.tableModel.setValueAt(new Integer(4), index, 1);
                        MoveTableSpaceDialog.this.tableModel.setValueAt(e1.getMessage(), index, 2);
                        MoveTableSpaceDialog.this.tableModel.fireTableChanged(new TableModelEvent(MoveTableSpaceDialog.this.tableModel));
                        MoveTableSpaceDialog.this.infoTable2.setValueAt(Integer.valueOf(MoveTableSpaceDialog.this.infoTable2.getValueAt(1, 1).toString()) - 1, 1, 1);
                        MoveTableSpaceDialog.this.infoTable2.setValueAt(Integer.valueOf(MoveTableSpaceDialog.this.infoTable2.getValueAt(0, 1).toString()) + 1, 0, 1);
                        MoveTableSpaceDialog.this.infoTable2.setValueAt(Integer.valueOf(MoveTableSpaceDialog.this.infoTable2.getValueAt(1, 3).toString()) + 1, 1, 3);
                    }
                });
                continue;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MoveTableSpaceDialog.this.tableModel.setValueAt(new Integer(2), index, 1);
                    MoveTableSpaceDialog.this.tableModel.fireTableChanged(new TableModelEvent(MoveTableSpaceDialog.this.tableModel));
                    MoveTableSpaceDialog.this.infoTable2.setValueAt(Integer.valueOf(MoveTableSpaceDialog.this.infoTable2.getValueAt(1, 1).toString()) - 1, 1, 1);
                    MoveTableSpaceDialog.this.infoTable2.setValueAt(Integer.valueOf(MoveTableSpaceDialog.this.infoTable2.getValueAt(0, 1).toString()) + 1, 0, 1);
                    MoveTableSpaceDialog.this.infoTable2.setValueAt(Integer.valueOf(MoveTableSpaceDialog.this.infoTable2.getValueAt(0, 3).toString()) + 1, 0, 3);
                }
            });
        }
        if (this.hasAlert.booleanValue()) {
            ((DefaultTableCellRenderer)this.infoTable1.getCellRenderer(0, 0)).setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/alert.gif"));
        } else {
            ((DefaultTableCellRenderer)this.infoTable1.getCellRenderer(0, 0)).setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/success.gif"));
        }
        this.okButton.setVisible(false);
        this.cancelButton.setEnabled(false);
        this.cancelButton.setVisible(false);
        this.finishButton.setVisible(true);
        this.addWindowListener(this.closeListener);
        this.finishButton.setEnabled(true);
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.t.suspend();
        int rc = GuiUt.showOptionDlg(this, this.res.getString("Warning"), this.res.getString("Do_You_Want_To_Stop"));
        if (rc != 0) {
            this.t.resume();
            return;
        }
        for (int i = this.refreshTableCell + 1; i < this.tables.size(); ++i) {
            this.tableModel.setValueAt(this.res.getString("Stop"), i, 1);
        }
        this.table.repaint();
        this.stopFlag = true;
        this.okButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.finishButton.setVisible(true);
        this.finishButton.setEnabled(false);
        this.t.resume();
    }

    public void finishButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    private void initTables() {
        if (this.isIndex.booleanValue()) {
            this.table.moveColumn(3, 0);
            for (int i = 0; i < this.tables.size(); ++i) {
                String[] data = this.tables.get(i);
                String ownName = data[0];
                String tbName = data[1];
                String indexName = data[2];
                this.tableModel.addRow(new Object[]{ownName + "." + tbName, new Integer(0), "", indexName});
            }
        } else {
            TableColumnModel colModel = this.table.getColumnModel();
            colModel.removeColumn(colModel.getColumn(3));
            for (int i = 0; i < this.tables.size(); ++i) {
                String[] data = this.tables.get(i);
                String ownName = data[0];
                String tbName = data[1];
                this.tableModel.addRow(new Object[]{ownName + "." + tbName, new Integer(0), ""});
            }
        }
        this.infoTable2.setValueAt(this.res.getString("Complete") + " :", 0, 0);
        this.infoTable2.setValueAt(0, 0, 1);
        this.infoTable2.setValueAt(this.res.getString("Remainder") + " :", 1, 0);
        this.infoTable2.setValueAt(this.tables.size(), 1, 1);
        this.infoTable2.setValueAt(this.res.getString("Success") + " :", 0, 2);
        this.infoTable2.setValueAt(0, 0, 3);
        this.infoTable2.setValueAt(this.res.getString("Fail") + " :", 1, 2);
        this.infoTable2.setValueAt(0, 1, 3);
        this.infoTable1.setValueAt(this.res.getString("Total") + " :", 0, 1);
        this.infoTable1.setValueAt(this.tables.size(), 0, 2);
    }

    public boolean isWindows() {
        String fileseparator = System.getProperty("file.separator");
        return fileseparator.equals("\\");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTSName() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "select TS_NAME from SYSTEM.SYSTABLESPACE WHERE TS_NAME NOT IN ('" + this.currentTsName + "','SYSTABLESPACE','TMPTABLESPACE') AND TS_TYPE!=2 AND TS_TYPE!=3";
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(sql);
            String tsName = null;
            while (rs.next()) {
                tsName = rs.getString(1).trim();
                this.tsNameComboBox.addItem(tsName);
            }
        }
        catch (SQLException e1) {
            GuiUt.showSQLException(DbFrame.frame, "", e1);
            e1.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.tsNameComboBox.setSelectedItem(this.defualtTsName);
    }

    private void initInfoPanel(JPanel infoPanel) {
        infoPanel.setLayout(new BorderLayout());
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/work.gif"));
        renderer.setHorizontalAlignment(4);
        this.infoTable1.getColumnModel().getColumn(0).setCellRenderer(renderer);
        DefaultTableCellRenderer rendererR = new DefaultTableCellRenderer();
        DefaultTableCellRenderer rendererL = new DefaultTableCellRenderer();
        rendererL.setHorizontalAlignment(2);
        rendererR.setHorizontalAlignment(4);
        this.infoTable1.setFont(rendererL.getFont().deriveFont(1));
        this.infoTable2.getColumnModel().getColumn(0).setCellRenderer(rendererR);
        this.infoTable2.getColumnModel().getColumn(1).setCellRenderer(rendererL);
        this.infoTable2.getColumnModel().getColumn(2).setCellRenderer(rendererR);
        this.infoTable2.getColumnModel().getColumn(3).setCellRenderer(rendererL);
        this.infoTable1.getColumnModel().getColumn(1).setCellRenderer(rendererR);
        this.infoTable1.getColumnModel().getColumn(2).setCellRenderer(rendererL);
        this.infoTable2.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.infoTable2.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.infoTable1.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.infoTable1.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.infoTable2.setRowHeight(25);
        this.infoTable1.setRowHeight(2 * this.infoTable2.getRowHeight());
        this.infoTable1.setEnabled(false);
        this.infoTable2.setEnabled(false);
        this.infoTable1.setShowVerticalLines(false);
        this.infoTable1.setShowHorizontalLines(false);
        this.infoTable2.setShowVerticalLines(false);
        this.infoTable2.setShowHorizontalLines(false);
        infoPanel.add((Component)this.infoTable1, "West");
        infoPanel.add((Component)this.infoTable2, "Center");
        infoPanel.setBackground(Color.white);
        infoPanel.setBorder(BorderFactory.createLoweredBevelBorder());
    }
}

