/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Table;

import dbatool.DbFrame;
import dbatool.Table.SchemaTableModel;
import dbatool.Table.SchemaType;
import dbatool.tableCell.BlobCellObject;
import dbatool.tableModel.ColumnSorting;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.textField.DBAHex;
import dbmaker.sql.JdbcOdbcPreparedStatement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class DataTableModel
extends AbstractTableModel
implements ColumnSorting {
    public boolean isEditable = false;
    private ArrayList data = new ArrayList();
    private Vector names = new Vector();
    private Vector defaults = new Vector();
    private Vector nullables = new Vector();
    public Vector types = new Vector();
    private String table_owner = "";
    private String table_name = "";
    private JTable table = null;
    private String insert_sql = null;

    public DataTableModel(TableModel schemaModel, String owner, String name) {
        this.table_owner = owner;
        this.table_name = name;
        int count = schemaModel.getRowCount();
        for (int i = 0; i < count; ++i) {
            this.names.addElement(schemaModel.getValueAt(i, SchemaTableModel.NAME));
            this.types.addElement(SchemaType.getDomainType((String)schemaModel.getValueAt(i, SchemaTableModel.TYPE)));
            this.defaults.addElement(schemaModel.getValueAt(i, SchemaTableModel.DEFAULT));
            this.nullables.addElement(schemaModel.getValueAt(i, SchemaTableModel.NULLABLE));
        }
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    @Override
    public int getColumnCount() {
        return this.names.size() + 1;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "";
        }
        return (String)this.names.elementAt(col - 1);
    }

    @Override
    public Object getValueAt(int row, int col) {
        ArrayList v = (ArrayList)this.data.get(row);
        return v.get(col);
    }

    public Class getColumnClass(int c) {
        Object o;
        ArrayList v = (ArrayList)this.data.get(0);
        if (v != null && (o = v.get(c)) != null) {
            return o.getClass();
        }
        return Object.class;
    }

    public void addValue(Object newData) {
        this.data.add(newData);
    }

    public void removeAll() {
        this.data.clear();
    }

    @Override
    public void switchOrder(int godown, int goup) {
        Object downRow = this.data.get(godown);
        Object upRow = this.data.get(goup);
        this.data.set(goup, downRow);
        this.data.set(godown, upRow);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        if (col > 0 && SchemaType.isBlobType((String)this.types.elementAt(col - 1))) {
            return true;
        }
        return this.isEditable;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            return;
        }
        if (!this.isEditable) {
            return;
        }
        if (row + 1 == this.getRowCount() && value != null && value.toString().length() > 0) {
            this.addEmptyRow();
        }
        if (this.getColumnCount() == 2 && row + 2 == this.getRowCount() && value != null && value.toString().length() > 0) {
            this.addEmptyRow();
        }
        ArrayList one_row = (ArrayList)this.data.get(row);
        String type = (String)this.types.elementAt(col - 1);
        if (this.isDataChanged(one_row.get(col), value, type)) {
            int col_count = this.getColumnCount();
            String oid = (String)one_row.get(0);
            if (oid.length() == 0) {
                one_row.set(col, value);
            } else {
                boolean nullable = (Boolean)this.nullables.elementAt(col - 1);
                if (SchemaType.isBlobType(type)) {
                    if (!(value instanceof BlobCellObject)) {
                        return;
                    }
                    BlobCellObject obj = (BlobCellObject)value;
                    if (!(obj.filename != null && obj.filename.length() > 0 || obj.size >= 0L && obj.isNull)) {
                        return;
                    }
                }
                String query = "UPDATE \"" + this.table_owner + "\".\"" + this.table_name + "\" " + "SET \"" + this.getColumnName(col) + "\" = ? " + "WHERE OID = '" + oid + "'x ";
                PreparedStatement pstmt = null;
                try {
                    pstmt = DbFrame.conn_DatabaseConnection.getDbConnection().prepareStatement(query);
                    this.pstmt_setData(pstmt, 1, value, type, nullable);
                    pstmt.executeUpdate();
                    pstmt.close();
                    pstmt = null;
                    one_row.set(col, value);
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                    DbaObject.close(pstmt);
                    GuiUt.showSQLException(DbFrame.frame, null, sqle);
                }
            }
        }
    }

    private boolean isDataChanged(Object oldValue, Object newValue, String type) {
        boolean result = false;
        if (SchemaType.isBlobType(type) && newValue instanceof BlobCellObject) {
            BlobCellObject newObj = (BlobCellObject)newValue;
            if (newObj.filename != null && newObj.filename.length() > 0 || newObj.size >= 0L && newObj.isNull) {
                result = true;
            }
        } else if (type.equalsIgnoreCase("binary") || type.equalsIgnoreCase("oid") || type.equalsIgnoreCase("char") || type.equalsIgnoreCase("nchar") || type.equalsIgnoreCase("date") || type.equalsIgnoreCase("decimal") || type.equalsIgnoreCase("double") || type.equalsIgnoreCase("real") || type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("bigint") || type.equalsIgnoreCase("serial") || type.equalsIgnoreCase("bigserial") || type.equalsIgnoreCase("smallint") || type.equalsIgnoreCase("time") || type.equalsIgnoreCase("timestamp") || type.equalsIgnoreCase("varchar") || type.equalsIgnoreCase("nvarchar")) {
            if (newValue == null && oldValue != null && oldValue.toString().length() > 0 || newValue != null && oldValue == null && newValue.toString().length() > 0 || newValue != null && oldValue != null && !oldValue.toString().equals(newValue.toString())) {
                result = true;
            }
        } else if (oldValue != newValue) {
            result = true;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pstmt_setData(PreparedStatement pstmt, int index, Object value, String type, boolean nullable) {
        try {
            FileInputStream in;
            BlobCellObject obj;
            if (SchemaType.isBlobType(type) && !type.equalsIgnoreCase("FILE")) {
                if (value instanceof BlobCellObject && value.toString().length() > 0) {
                    obj = (BlobCellObject)value;
                    if (obj.filename.length() > 0) {
                        in = null;
                        try {
                            in = new FileInputStream(obj.filename);
                            String cliLcode = DbFrame.conn_DatabaseConnection.getCliLcode();
                            if (type.equalsIgnoreCase("NCLOB")) {
                                InputStreamReader reader1 = new InputStreamReader((InputStream)in, cliLcode);
                                pstmt.setCharacterStream(index, (Reader)reader1, in.available());
                                return;
                            }
                            if (type.equalsIgnoreCase("jsoncols")) {
                                InputStreamReader reader1 = new InputStreamReader((InputStream)in, "UTF-8");
                                pstmt.setCharacterStream(index, (Reader)reader1, in.available());
                                return;
                            }
                            pstmt.setBinaryStream(index, (InputStream)in, in.available());
                            return;
                        }
                        catch (IOException e) {
                            DbaObject.close(in);
                            GuiUt.showErrorDlg(DbFrame.frame, e.getMessage(), null);
                        }
                    }
                    if (obj.isNull) {
                        if (type.equalsIgnoreCase("LONG VARCHAR") || type.equalsIgnoreCase("CLOB")) {
                            pstmt.setNull(index, -1);
                            return;
                        }
                        if (type.equalsIgnoreCase("NCLOB")) {
                            pstmt.setNull(index, -10);
                            return;
                        }
                        pstmt.setNull(index, -4);
                        return;
                    }
                    pstmt.setString(index, "");
                } else {
                    if (((String)this.defaults.elementAt(index - 1)).length() == 0) {
                        if (!nullable) {
                            pstmt.setString(index, "");
                            return;
                        }
                        if (type.equalsIgnoreCase("LONG VARCHAR") || type.equalsIgnoreCase("CLOB")) {
                            pstmt.setNull(index, -1);
                            return;
                        }
                        if (type.equalsIgnoreCase("NCLOB")) {
                            pstmt.setNull(index, -10);
                            return;
                        }
                        pstmt.setNull(index, -4);
                        return;
                    }
                    if (type.equalsIgnoreCase("LONG VARCHAR") || type.equalsIgnoreCase("CLOB")) {
                        ((JdbcOdbcPreparedStatement)pstmt).setDefault(index, -1);
                        return;
                    }
                    if (type.equalsIgnoreCase("NCLOB")) {
                        ((JdbcOdbcPreparedStatement)pstmt).setDefault(index, -10);
                        return;
                    }
                    ((JdbcOdbcPreparedStatement)pstmt).setDefault(index, -4);
                    return;
                }
            }
            if (type.equalsIgnoreCase("FILE")) {
                if (value instanceof BlobCellObject && value.toString().length() > 0) {
                    obj = (BlobCellObject)value;
                    if (obj.filename.length() > 0) {
                        if (!obj.asSystemFileObject) {
                            pstmt.setString(index, obj.filename);
                            return;
                        }
                        in = null;
                        try {
                            in = new FileInputStream(new File(obj.filename));
                            pstmt.setBinaryStream(index, (InputStream)in, in.available());
                            return;
                        }
                        catch (IOException ioe) {
                            DbaObject.close(in);
                            GuiUt.showErrorDlg(DbFrame.frame, ioe.getMessage(), null);
                            return;
                        }
                    }
                    if (obj.isNull) {
                        pstmt.setNull(index, 1);
                        return;
                    }
                    pstmt.setString(index, "");
                    return;
                }
                if (((String)this.defaults.elementAt(index - 1)).length() != 0) {
                    ((JdbcOdbcPreparedStatement)pstmt).setDefault(index, 1);
                    return;
                }
                if (nullable) {
                    pstmt.setNull(index, 1);
                    return;
                }
                pstmt.setString(index, "");
                return;
            }
            if (type.equalsIgnoreCase("binary") || type.equalsIgnoreCase("oid")) {
                if (value.toString().length() != 0) {
                    byte[] b = DBAHex.toBytes((String)value);
                    pstmt.setBytes(index, b);
                    return;
                }
                if (((String)this.defaults.elementAt(index - 1)).length() != 0) {
                    ((JdbcOdbcPreparedStatement)pstmt).setDefault(index, -2);
                    return;
                }
                if (nullable) {
                    pstmt.setNull(index, -2);
                    return;
                }
                pstmt.setString(index, "");
                return;
            }
            if (type.equalsIgnoreCase("char") || type.equalsIgnoreCase("nchar") || type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("bigint") || type.equalsIgnoreCase("serial") || type.equalsIgnoreCase("bigserial") || type.equalsIgnoreCase("smallint")) {
                if (value.toString().length() != 0) {
                    pstmt.setString(index, value.toString());
                    return;
                }
                if (((String)this.defaults.elementAt(index - 1)).length() != 0) {
                    ((JdbcOdbcPreparedStatement)pstmt).setDefault(index, 1);
                    return;
                }
                if (nullable) {
                    pstmt.setNull(index, 1);
                    return;
                }
                pstmt.setString(index, value.toString());
                return;
            }
            if (type.equalsIgnoreCase("date")) {
                if (value.toString().length() != 0) {
                    pstmt.setString(index, value.toString());
                    return;
                }
                if (((String)this.defaults.elementAt(index - 1)).length() != 0) {
                    ((JdbcOdbcPreparedStatement)pstmt).setDefault(index, 91);
                    return;
                }
                if (nullable) {
                    pstmt.setNull(index, 91);
                    return;
                }
                pstmt.setString(index, "");
                return;
            }
            if (type.equalsIgnoreCase("decimal")) {
                if (value.toString().length() != 0) {
                    pstmt.setString(index, value.toString());
                    return;
                }
                if (((String)this.defaults.elementAt(index - 1)).length() != 0) {
                    ((JdbcOdbcPreparedStatement)pstmt).setDefault(index, 3);
                    return;
                }
                if (nullable) {
                    pstmt.setNull(index, 3);
                    return;
                }
                pstmt.setString(index, "");
                return;
            }
            if (type.equalsIgnoreCase("double")) {
                if (value != null && value.toString().length() != 0) {
                    pstmt.setDouble(index, Double.valueOf(value.toString()));
                    return;
                }
                if (((String)this.defaults.elementAt(index - 1)).length() != 0) {
                    ((JdbcOdbcPreparedStatement)pstmt).setDefault(index, 8);
                    return;
                }
                if (nullable) {
                    pstmt.setNull(index, 8);
                    return;
                }
                pstmt.setString(index, "");
                return;
            }
            if (type.equalsIgnoreCase("real")) {
                if (value != null && value.toString().length() != 0) {
                    pstmt.setFloat(index, Float.valueOf(value.toString()).floatValue());
                    return;
                }
                if (((String)this.defaults.elementAt(index - 1)).length() != 0) {
                    ((JdbcOdbcPreparedStatement)pstmt).setDefault(index, 7);
                    return;
                }
                if (nullable) {
                    pstmt.setNull(index, 7);
                    return;
                }
                pstmt.setString(index, "");
                return;
            }
            if (type.equalsIgnoreCase("time")) {
                if (value.toString().length() != 0) {
                    pstmt.setString(index, value.toString());
                    return;
                }
                if (((String)this.defaults.elementAt(index - 1)).length() != 0) {
                    ((JdbcOdbcPreparedStatement)pstmt).setDefault(index, 92);
                    return;
                }
                if (nullable) {
                    pstmt.setNull(index, 92);
                    return;
                }
                pstmt.setString(index, "");
                return;
            }
            if (type.equalsIgnoreCase("timestamp")) {
                if (value.toString().length() != 0) {
                    pstmt.setString(index, value.toString());
                    return;
                }
                if (((String)this.defaults.elementAt(index - 1)).length() != 0) {
                    ((JdbcOdbcPreparedStatement)pstmt).setDefault(index, 93);
                    return;
                }
                if (nullable) {
                    pstmt.setNull(index, 93);
                    return;
                }
                pstmt.setString(index, "");
                return;
            }
            if (!type.equalsIgnoreCase("varchar") && !type.equalsIgnoreCase("nvarchar")) {
                pstmt.setString(index, value.toString());
                return;
            }
            if (value.toString().length() != 0) {
                pstmt.setString(index, value.toString());
                return;
            }
            if (((String)this.defaults.elementAt(index - 1)).length() != 0) {
                ((JdbcOdbcPreparedStatement)pstmt).setDefault(index, 12);
                return;
            }
            if (nullable) {
                pstmt.setNull(index, 12);
                return;
            }
            pstmt.setString(index, value.toString());
            return;
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private String getInsertSQL() {
        StringBuffer insert_sql_sb = new StringBuffer();
        insert_sql_sb.append("INSERT INTO \"").append(this.table_owner).append("\".\"").append(this.table_name).append("\" VALUES (?");
        int col_count = this.getColumnCount();
        for (int i = 2; i < col_count; ++i) {
            insert_sql_sb.append(", ?");
        }
        insert_sql_sb.append(")");
        return insert_sql_sb.toString();
    }

    public int insertNewRecord(int row) {
        if (this.insert_sql == null) {
            this.insert_sql = this.getInsertSQL();
        }
        PreparedStatement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        int col_count = this.getColumnCount();
        try {
            ArrayList one_row = (ArrayList)this.data.get(row);
            pstmt = DbFrame.conn_DatabaseConnection.getDbConnection().prepareStatement(this.insert_sql);
            for (int i = 1; i < col_count; ++i) {
                this.pstmt_setData(pstmt, i, one_row.get(i), (String)this.types.elementAt(i - 1), (Boolean)this.nullables.elementAt(i - 1));
            }
            pstmt.executeUpdate();
            pstmt.close();
            pstmt = null;
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "SELECT LAST_OID FROM SYSCONINFO";
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                String temp = rs.getString(1);
                one_row.set(0, rs.wasNull() ? "" : temp);
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            return 0;
        }
        catch (SQLException sqle) {
            DbaObject.close(pstmt);
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
            sqle.printStackTrace();
            return -1;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return -1;
        }
    }

    public int getFirstNewData() {
        int last = 0;
        int i = this.getRowCount() - 1;
        while (i >= 0 && this.isNewData(i)) {
            last = i--;
        }
        return last;
    }

    public boolean isNewData(int row) {
        ArrayList one_row = (ArrayList)this.data.get(row);
        return one_row.get(0).toString().length() <= 0;
    }

    public boolean withNewData(int row) {
        int col_count = this.getColumnCount();
        ArrayList one_row = (ArrayList)this.data.get(row);
        if (one_row.get(0).toString().length() > 0) {
            return false;
        }
        Object obj = null;
        for (int i = 1; i < col_count; ++i) {
            obj = one_row.get(i);
            if (obj == null || one_row.get(i).toString().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public void addEmptyRow() {
        int col_count = this.getColumnCount();
        ArrayList<Object> new_row = new ArrayList<Object>();
        new_row.add(new String(""));
        for (int i = 1; i < col_count; ++i) {
            if (SchemaType.isBlobType((String)this.types.elementAt(i - 1))) {
                new_row.add(new BlobCellObject("", this.table_owner, this.table_name, this.getColumnName(i), (String)this.types.elementAt(i - 1), -1L, false));
                continue;
            }
            new_row.add(new String(""));
        }
        this.addValue(new_row);
    }

    public void removeEmptyRow() {
        int oid_col = this.getColumnCount();
        int i = 0;
        while (i < this.getRowCount()) {
            String oid = (String)this.getValueAt(i, 0);
            if (oid == null || oid.length() == 0) {
                this.data.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void deleteRow(int row) {
        int oid_col = this.getColumnCount();
        String oid = (String)this.getValueAt(row, 0);
        if (oid.length() > 0) {
            Statement stmt = null;
            try {
                String query = "DELETE FROM \"" + this.table_owner + "\".\"" + this.table_name + "\" WHERE OID='" + oid + "'x";
                stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
                stmt.executeUpdate(query);
                stmt.close();
                stmt = null;
            }
            catch (SQLException e) {
                DbaObject.close(stmt);
                GuiUt.showSQLException(DbFrame.frame, null, e);
            }
        }
        this.data.remove(row);
    }
}

