/*
 * Decompiled with CFR 0.152.
 */
package dbatool.StoredCommand;

import dbatool.DbFrame;
import dbatool.StoredCommand.CommandParamObject;
import dbatool.StoredCommand.GetParameterDlg;
import dbatool.StoredCommand.ResultSetDlg;
import dbatool.tableCell.BlobCellObject;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.resource.DBAResourceBundle;
import dbaut.util.JdbcUtil;
import dbmaker.sql.JdbcOdbcPreparedStatement;
import java.awt.Frame;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class ExecuteCommand {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private String query = null;
    private int num_input_parm = 0;
    private int num_output_parm = 0;

    public ExecuteCommand(String query, int num_parm) {
        this.query = query;
        this.num_input_parm = num_parm;
    }

    public void execute() {
        Vector parameters = null;
        if (this.num_input_parm > 0) {
            GetParameterDlg dlg = DbFrame.isWindows ? new GetParameterDlg((Frame)DbFrame.frame, this.num_input_parm) : new GetParameterDlg((Frame)DbFrame.frame, "", true, this.num_input_parm);
            dlg.setTitle(this.res.getString("Get_Parameter_Value"));
            GuiUt.setCenterLocation(DbFrame.frame, dlg);
            dlg.show();
            if (dlg.getResult() != 0) {
                return;
            }
            parameters = dlg.getParameters();
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            Connection conn = DbFrame.conn_DatabaseConnection.getDbConnection();
            pstmt = conn.prepareStatement(this.query);
            for (int i = 0; i < this.num_input_parm; ++i) {
                CommandParamObject one_row = (CommandParamObject)parameters.elementAt(i);
                String value = one_row.getText();
                String c = one_row.getSelectedItem();
                if (c.equals("  ")) {
                    pstmt.setString(i + 1, value);
                    continue;
                }
                if (c.equals("NULL")) {
                    pstmt.setNull(i + 1, 1);
                    continue;
                }
                ((JdbcOdbcPreparedStatement)pstmt).setDefault(i + 1, 1);
            }
            if (!GuiUt.showSqlScript(this.query)) {
                return;
            }
            if (pstmt.execute()) {
                rs = pstmt.getResultSet();
                if (rs == null) {
                    pstmt.close();
                    GuiUt.showInformationDlg(DbFrame.frame, this.res.getString("Execute_successfully"));
                    return;
                }
                ResultSetMetaData rsmd = rs.getMetaData();
                int col_count = rsmd.getColumnCount();
                int[] rsmdt = new int[col_count];
                String[] rsmdv = new String[col_count];
                for (int i = 1; i <= col_count; ++i) {
                    rsmdv[i - 1] = rsmd.getColumnName(i);
                    rsmdt[i - 1] = rsmd.getColumnType(i);
                }
                DbaTableModel rsModel = new DbaTableModel(rsmdv);
                Vector<Object> one_row = null;
                boolean size = false;
                boolean type = false;
                while (rs.next()) {
                    one_row = new Vector<Object>();
                    for (int i = 0; i < col_count; ++i) {
                        one_row.addElement(this.getResultSetData(i + 1, rsmdt[i], rs));
                    }
                    rsModel.addValue(new DBARowInfo(one_row));
                }
                rs.close();
                pstmt.close();
                ResultSetDlg dlg = DbFrame.isWindows ? new ResultSetDlg((Frame)DbFrame.frame, rsModel, null) : new ResultSetDlg(DbFrame.frame, "", true, rsModel, null);
                dlg.setTitle(this.res.getString("Execute_Result"));
                GuiUt.setCenterLocation(DbFrame.frame, dlg);
                dlg.show();
            }
        }
        catch (SQLException ex) {
            DbaObject.close(rs);
            DbaObject.close(pstmt);
            GuiUt.showErrorDlg(DbFrame.frame, ex.getMessage(), null);
        }
    }

    public Object getResultSetData(int index, int type, ResultSet rs) {
        Object obj = null;
        long length = -1L;
        Blob b = null;
        try {
            switch (type) {
                case -10: {
                    b = rs.getBlob(index);
                    if (rs.wasNull()) {
                        obj = new BlobCellObject(null, null, null, null, "nclob", -1L, true);
                        break;
                    }
                    length = b != null ? b.length() : -1L;
                    obj = new BlobCellObject(null, null, null, null, "nclob", length, false);
                    break;
                }
                case -1: {
                    b = rs.getBlob(index);
                    if (rs.wasNull()) {
                        obj = new BlobCellObject(null, null, null, null, "long varchar", -1L, true);
                        break;
                    }
                    length = b != null ? b.length() : -1L;
                    obj = new BlobCellObject(null, null, null, null, "long varchar", length, false);
                    break;
                }
                case 301: {
                    b = rs.getBlob(index);
                    if (rs.wasNull()) {
                        obj = new BlobCellObject(null, null, null, null, "file", -1L, true);
                        break;
                    }
                    length = b != null ? b.length() : -1L;
                    obj = new BlobCellObject(null, null, null, null, "file", length, false);
                    break;
                }
                case -4: {
                    b = rs.getBlob(index);
                    if (rs.wasNull()) {
                        obj = new BlobCellObject(null, null, null, null, "blob", -1L, true);
                        break;
                    }
                    length = b != null ? b.length() : -1L;
                    obj = new BlobCellObject(null, null, null, null, "blob", length, false);
                    break;
                }
                default: {
                    String s = rs.getString(index);
                    obj = rs.wasNull() ? null : s;
                }
            }
            JdbcUtil.free(b);
        }
        catch (SQLException e) {
            GuiUt.showErrorDlg(DbFrame.frame, e.getMessage(), null);
            obj = new String("");
        }
        return obj;
    }
}

