/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Schedule;

import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.HelpButton;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class SynchronizeDlg
extends JDialog {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.ScheduleRes", LocaleManager.getLocale());
    private JRadioButton Wait = new JRadioButton();
    private JRadioButton No_Wait = new JRadioButton();
    private String dbname = null;
    private DbaButton OK_Button = new DbaButton(new Dimension(80, 24), this.res.getString("OK"), 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "OK_Button_actionPerformed"));

    public SynchronizeDlg(Frame frame, String title, boolean modal, String dbname) {
        super(frame, title, modal);
        this.dbname = dbname;
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SynchronizeDlg(Frame frame, String dbname) {
        super(frame);
        this.setModal(true);
        this.dbname = dbname;
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.OK_Button.requestFocus();
        }
    }

    void jbInit() throws Exception {
        HelpButton Help_Button = new HelpButton();
        JPanel panel1 = new JPanel(new BorderLayout());
        JPanel jPanel1 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        this.Wait.setSelected(true);
        this.Wait.setText(this.res.getString("Wait"));
        this.No_Wait.setText(this.res.getString("No_Wait"));
        jPanel1.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.res.getString("Synchronize_replication")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel1.setPreferredSize(new Dimension(300, 60));
        DbaButton Cancel_Button = new DbaButton(new Dimension(80, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        DbFrame.frame.enableDialogHelp(this.getRootPane(), Help_Button, "schedule.info.synchronous", null);
        panel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(panel1);
        panel1.add((Component)jPanel1, "Center");
        jPanel1.add(this.No_Wait);
        jPanel1.add(this.Wait);
        panel1.add((Component)jPanel2, "South");
        jPanel2.add((Component)this.OK_Button, null);
        jPanel2.add((Component)Cancel_Button, null);
        jPanel2.add((Component)Help_Button, null);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.Wait);
        bg.add(this.No_Wait);
        this.setName("RepScheduleSynDialog");
        this.OK_Button.setName("OKButton");
        Cancel_Button.setName("CancelButton");
        this.Wait.setName("WaitRadioButton");
        this.No_Wait.setName("NoWaitRadioButton");
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void OK_Button_actionPerformed(ActionEvent e) {
        String query = "SYNCHRONIZE REPLICATION TO \"" + this.dbname + "\"";
        query = this.Wait.isSelected() ? query + " WAIT" : query + " NO WAIT";
        boolean result = DatabaseConnection.executeMultiSQL(query);
        if (!result) {
            this.Cancel_Button_actionPerformed(null);
            return;
        }
        if (this.Wait.isSelected()) {
            GuiUt.showInformationDlg(this, this.res.getString("Replication_has_been_synchronized"));
        } else {
            GuiUt.showInformationDlg(this, this.res.getString("Replication_has_been_started"));
        }
        this.Cancel_Button_actionPerformed(null);
    }
}

