/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Qbe;

import dbatool.Qbe.ColumnInfo;
import dbatool.Qbe.QbeContainerDlg;
import dbatool.Qbe.UdfCompare;
import dbatool.Qbe.UdfFunctionInfo;
import dbaut.locale.LocaleManager;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class UdfFunctionsBuilder {
    private QbeContainerDlg parentDlg = null;
    final short BINARY = 0;
    final short STRING = 1;
    final short DATE = (short)2;
    final short NUMERIC = (short)3;
    final short FILE = (short)4;
    final short INTEGER = (short)5;
    final short BLOB = (short)6;
    final short CLOB = (short)7;
    final short TIME = (short)8;
    final short TIMESTAMP = (short)9;
    final short XMLTYPE = (short)10;

    public UdfFunctionsBuilder(QbeContainerDlg parentDlg) {
        this.parentDlg = parentDlg;
        this.init();
    }

    private void init() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = null;
            String udf_def_file = "/dbatool/Qbe/udfdef";
            switch (LocaleManager.getLanguageChoice()) {
                case 0: {
                    udf_def_file = udf_def_file + "_en_US.xml";
                    break;
                }
                case 1: {
                    udf_def_file = udf_def_file + "_zh_TW.xml";
                    break;
                }
                case 2: {
                    udf_def_file = udf_def_file + "_ja_JP.xml";
                    break;
                }
                case 3: {
                    udf_def_file = udf_def_file + "_zh_CN.xml";
                    break;
                }
                default: {
                    udf_def_file = udf_def_file + "_en_US.xml";
                }
            }
            document = builder.parse(this.getClass().getResourceAsStream(udf_def_file));
            Node search_node = null;
            Node udf_node = null;
            Node udf_desc_node = null;
            search_node = XPathAPI.selectSingleNode((Node)document, (String)"/root");
            UdfFunctionInfo ufi = null;
            for (udf_node = search_node.getFirstChild(); udf_node != null; udf_node = udf_node.getNextSibling()) {
                if (udf_node.getNodeType() != 1) continue;
                udf_desc_node = udf_node.getFirstChild();
                while (udf_desc_node.getNodeType() != 1) {
                    udf_desc_node = udf_desc_node.getNextSibling();
                }
                ufi = new UdfFunctionInfo(udf_desc_node);
                this.parentDlg.udf_ht.put(ufi.name, ufi);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    Vector getAggregateFunctionList() {
        Vector<UdfFunctionInfo> v = new Vector<UdfFunctionInfo>();
        UdfFunctionInfo ufi = null;
        Enumeration enum1 = this.parentDlg.udf_ht.elements();
        while (enum1.hasMoreElements()) {
            ufi = (UdfFunctionInfo)enum1.nextElement();
            if (!ufi.isAggregate) continue;
            v.add(ufi);
        }
        return v;
    }

    Vector getSuitableFunctionList(ColumnInfo ci, boolean b, boolean includeAggregateFunction) {
        int i;
        Vector<UdfFunctionInfo> v = new Vector<UdfFunctionInfo>();
        Vector<UdfFunctionInfo> vv = new Vector<UdfFunctionInfo>();
        Vector<UdfFunctionInfo> vvv = new Vector<UdfFunctionInfo>();
        Vector<UdfFunctionInfo> xmlTypeV = new Vector<UdfFunctionInfo>();
        UdfFunctionInfo ufi = null;
        Enumeration enum1 = this.parentDlg.udf_ht.elements();
        int type = -1;
        while (enum1.hasMoreElements()) {
            ufi = (UdfFunctionInfo)enum1.nextElement();
            if (ufi.isAggregate) {
                if (!includeAggregateFunction) continue;
                vvv.add(ufi);
                continue;
            }
            if (!ufi.isAppliedCol) {
                if (!b) continue;
                vv.add(ufi);
                continue;
            }
            type = ufi.checkTypeRange(ci.type);
            switch (type) {
                case 0: {
                    if (!ufi.isBinary) break;
                    v.add(ufi);
                    break;
                }
                case 1: {
                    if (!ufi.isString) break;
                    v.add(ufi);
                    break;
                }
                case 2: {
                    if (!ufi.isDate) break;
                    v.add(ufi);
                    break;
                }
                case 3: {
                    if (!ufi.isNumeric) break;
                    v.add(ufi);
                    break;
                }
                case 4: {
                    if (!ufi.isFile) break;
                    v.add(ufi);
                    break;
                }
                case 5: {
                    if (!ufi.isInt) break;
                    v.add(ufi);
                    break;
                }
                case 10: {
                    if (ufi.isXMLType()) {
                        xmlTypeV.add(ufi);
                    }
                }
                case 6: {
                    if (!ufi.isBlob) break;
                    v.add(ufi);
                    break;
                }
                case 7: {
                    if (!ufi.isClob) break;
                    v.add(ufi);
                    break;
                }
                case 8: {
                    if (!ufi.isTime) break;
                    v.add(ufi);
                    break;
                }
                case 9: {
                    if (!ufi.isTimeStamp) break;
                    v.add(ufi);
                }
            }
        }
        int len = vv.size();
        for (i = 0; i < len; ++i) {
            v.add((UdfFunctionInfo)vv.elementAt(i));
        }
        len = vvv.size();
        for (i = 0; i < len; ++i) {
            v.add((UdfFunctionInfo)vvv.elementAt(i));
        }
        for (i = 0; i < xmlTypeV.size(); ++i) {
            v.add((UdfFunctionInfo)xmlTypeV.elementAt(i));
        }
        Object[] o = v.toArray();
        Arrays.sort(o, new UdfCompare());
        Vector<Object> sortV = new Vector<Object>();
        for (int i2 = 0; i2 < o.length; ++i2) {
            sortV.add(o[i2]);
        }
        return sortV;
    }
}

