/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Monitor;

import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.Monitor.JournalStatus;
import dbatool.Monitor.JournalStatusTableModel;
import dbatool.Monitor.SQLCommandDlg;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.GuiUt;
import dbaut.alarm.Alarm2;
import dbaut.alarm.Sleeper;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.resource.HelpResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class JournalStatusUserPanel
extends DbaPanel
implements Sleeper {
    private static final long serialVersionUID = 5206916778974677553L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.MonitorRes", LocaleManager.getLocale());
    private JournalStatusTableModel model1 = new JournalStatusTableModel();
    private DBAToolAbstractTableModel absModel = new DBAToolAbstractTableModel(this.model1);
    private JTable table1 = new JTable(this.absModel);
    DbaButton ButtonReload2 = new DbaButton(new Dimension(120, 24), this.res.getString("JOURNAL_STATUS_GRAPH_BUTTON_REFRESH"), 'R', DBAImageResource.getResource(this.getClass(), "/jdbaimages/refresh.gif"), new ReflectionAction(this, "buttonReloadData"));
    DbaButton ButtonDelete = new DbaButton(new Dimension(140, 24), this.res.getString("JOURNAL_STATUS_DELETE_CONNECTION"), 'D', null, new ReflectionAction(this, "buttonDelete"));
    protected JCheckBox Auto_Refresh_Checkbox2 = new JCheckBox(this.res.getString("Auto_Refresh"));
    private Alarm2 clock = null;
    private boolean isRefreshing = false;
    private DbaTabbedPane parent = null;

    public JournalStatusUserPanel(HelpResourceBundle helpres, String helpid2, JournalStatus parent) {
        super(helpres, helpid2);
        this.parent = parent;
        try {
            this.getInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getInfo() throws Exception {
        this.Auto_Refresh_Checkbox2.addActionListener(new ReflectionAction(this, "Auto_Refresh_Checkbox_actionPerformed2"));
        if (DbFrame.frame.px.getAutoRefresh()) {
            this.Auto_Refresh_Checkbox2.setSelected(true);
        } else {
            this.Auto_Refresh_Checkbox2.setSelected(false);
        }
        this.table1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JournalStatusUserPanel.this.table1_mouseClicked(e);
            }
        });
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.table1.setSelectionMode(0);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table1_valueChanged"));
        this.setName("UpdateStatisticsPanel");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jScrollPane1, "Center");
        JPanel buttonBar = new JPanel(new FlowLayout(0));
        buttonBar.setName("SessionInfoToolBar");
        buttonBar.add((Component)this.ButtonReload2, null);
        buttonBar.add((Component)this.ButtonDelete, null);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)buttonBar, "West");
        buttonPanel.add((Component)this.Auto_Refresh_Checkbox2, "East");
        this.add((Component)buttonPanel, "North");
        this.initColumnSizes(this.table1);
        this.table1_valueChanged(null);
    }

    public void buttonReloadData(ActionEvent e) {
        if (this.parent instanceof JournalStatus) {
            ((JournalStatus)this.parent).buttonReloadData(e);
        } else {
            if (this.isRefreshing) {
                System.out.println("It's refreshing already.");
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.isRefreshing = true;
            this.reload();
            this.isRefreshing = false;
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected ArrayList<ArrayList<String>> reload() {
        ArrayList<ArrayList<String>> data2 = new ArrayList<ArrayList<String>>();
        ArrayList<String> b = null;
        try {
            String query = "select USER_NAME,cast(CONNECTION_ID as varchar(10)), cast(FIRST_W_JNR_FN as varchar(10)), cast(FIRST_W_JNR_BN as varchar(10)),TIME_OF_SQL_CMD,NUM_J_BLOCK_DURATN, CAST(SQL_CMD as char(100)) from SYSUSER where CONNECTION_ID in (select HOLD_LK_CONNECTION from SYSLOCK) and FIRST_W_JNR_BN <> 0 ;";
            Statement stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            ResultSet rs = stmt.executeQuery(query);
            int columnCounter = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                b = new ArrayList<String>();
                for (int i = 0; i < columnCounter; ++i) {
                    b.add(rs.getString(i + 1));
                }
                data2.add(b);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        this.append2(data2);
        return data2;
    }

    private void append2(ArrayList<ArrayList<String>> data) {
        this.model1.removeAll();
        for (ArrayList<String> b : data) {
            this.model1.addValue(b.toArray());
        }
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
    }

    public void Auto_Refresh_Checkbox_actionPerformed2(ActionEvent e) {
        if (this.Auto_Refresh_Checkbox2.isSelected()) {
            DbFrame.frame.px.updateVariables(3, "true");
        } else {
            DbFrame.frame.px.updateVariables(3, "false");
        }
        if (DbFrame.frame.px.getAutoRefresh()) {
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
            this.Auto_Refresh_Checkbox2.setSelected(true);
        } else {
            this.Auto_Refresh_Checkbox2.setSelected(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buttonDelete(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        int row = this.table1.getSelectedRow();
        if (row >= 0 && row < this.table1.getRowCount()) {
            int connectionid = Integer.parseInt((String)this.model1.getValueAt(row, 1));
            Statement stmt = null;
            try {
                stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
                stmt.executeUpdate("kill connection " + connectionid);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            GuiUt.showSuccessDlg(DbFrame.frame, this.res.getString("JOURNAL_STATUS_SUCCESS_DELETE_CONNECTION") + " " + connectionid, null);
            if (row >= this.table1.getRowCount()) {
                this.table1.getSelectionModel().clearSelection();
            }
            this.table1_valueChanged(null);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        int[] sizes = new int[]{50, 50, 50, 50, 100, 50, 300};
        for (int i = 0; i < sizes.length; ++i) {
            column = table.getColumnModel().getColumn(i);
            column.setPreferredWidth(sizes[i]);
        }
    }

    public void table1_valueChanged(ListSelectionEvent e) {
        if (this.isRefreshing) {
            return;
        }
        if (this.table1.getSelectionModel().isSelectionEmpty()) {
            this.ButtonDelete.setEnabled(false);
        } else {
            this.ButtonDelete.setEnabled(true);
        }
    }

    @Override
    public void wakeUp() {
    }

    private void table1_mouseClicked(MouseEvent e) {
        if (this.isRefreshing) {
            System.out.println("It's refreshing the monitor data right now.");
            return;
        }
        int row = this.table1.getSelectedRow();
        int col = this.table1.getSelectedColumn();
        if (row < 0 || row >= this.table1.getRowCount() || col < 0 || col >= this.table1.getColumnCount()) {
            return;
        }
        if (col == 6) {
            SQLCommandDlg dlg = DbFrame.isWindows ? new SQLCommandDlg((Frame)DbFrame.frame, "") : new SQLCommandDlg((Frame)DbFrame.frame, "", true, "");
            dlg.setSQLCommandText((String)this.model1.getValueAt(row, col));
            GuiUt.setCenterLocation(DbFrame.frame, dlg);
            dlg.setModal(true);
            dlg.show();
        }
    }
}

