/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Index;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.Index.MoveIndexDialog;
import dbatool.Index.RenameIndexDlg;
import dbatool.Table.PrimaryKeyVector;
import dbatool.tableModel.ColumnSorting;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import dbaut.textField.IntegerField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import wizard.idx.Wizard_idx;

public class IndexList
extends DbaTabbedPane
implements ComponentPrivilege {
    private DbaButton Prop_Create_Button;
    private DbaButton Prop_Rebuild_Button;
    private DbaButton Prop_Drop_Button;
    private DbaButton Statistics_Update_Button;
    private DbaButton moveButton;
    private DbaButton Rename_Button;
    private DbaButton Disable_Button;
    private IndexCols jIndexCols;
    private DBAToolAbstractTableModel absModel1;
    private JTable table1;
    private IndexStatCols jIndexStatCols;
    private DBAToolAbstractTableModel absModel2;
    private JTable table2;
    private IntegerField Statistics_Sample_Ratio;
    private int TB_OWNER;
    private int TB_NAME;
    private int INDEX;
    private int TS_NAME;
    private int UNIQUE;
    private int KEYS_STRING;
    private int CREATE_TIME;
    private int DISABLE_STATUS;
    private int DISABLE_STATUS1;
    private int PAGES;
    private int LEVEL;
    private int LEAF_PAGES;
    private int DIST_KEY;
    private int CLUSTER_COUNT;
    private int SPACE_RATE;
    private String table_owner;
    private String table_name;
    private boolean initTableSize;
    private static String EMPTY_KEYS = "...";
    private boolean isStopped;

    public void clean() {
        this.isStopped = true;
    }

    public IndexList(String table_owner, String table_name) {
        this.Prop_Create_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Prop_Create_Button_actionPerformed"));
        this.Prop_Rebuild_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Rebuild"), 'B', DBAImageResource.getResource(this.getClass(), "/jdbaimages/rebuild.gif"), new ReflectionAction(this, "Prop_Rebuild_Button_actionPerformed"));
        this.Prop_Drop_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Prop_Drop_Button_actionPerformed"));
        this.Statistics_Update_Button = new DbaButton(new Dimension(160, 24), DbFrame.frame.res.getString("Update_Statistics"), 'U', DBAImageResource.getResource(this.getClass(), "/jdbaimages/update_statistics.gif"), new ReflectionAction(this, "Statistics_Update_Button_actionPerformed"));
        this.moveButton = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Move"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/rebuild.gif"), new ReflectionAction(this, "moveButtonActionPerformed"));
        this.Rename_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Rename"), 'R', DBAImageResource.getResource(this.getClass(), "/jdbaimages/rename.gif"), new ReflectionAction(this, "Rename_Button_actionPerformed"));
        this.Disable_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Disable"), 'S', DBAImageResource.getResource(this.getClass(), "/jdbaimages/disable.gif"), new ReflectionAction(this, "Disable_Button_actionPerformed"));
        this.jIndexCols = null;
        this.absModel1 = null;
        this.table1 = null;
        this.jIndexStatCols = null;
        this.absModel2 = null;
        this.table2 = null;
        this.Statistics_Sample_Ratio = new IntegerField(0, 0, 3);
        this.TB_OWNER = 0;
        this.TB_NAME = 1;
        this.INDEX = 2;
        this.TS_NAME = 3;
        this.UNIQUE = 4;
        this.KEYS_STRING = 5;
        this.CREATE_TIME = 7;
        this.DISABLE_STATUS = 6;
        this.DISABLE_STATUS1 = 3;
        this.PAGES = 4;
        this.LEVEL = 5;
        this.LEAF_PAGES = 6;
        this.DIST_KEY = 7;
        this.CLUSTER_COUNT = 8;
        this.SPACE_RATE = 9;
        this.table_owner = null;
        this.table_name = null;
        this.initTableSize = false;
        this.isStopped = false;
        this.table_owner = table_owner;
        this.table_name = table_name;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IndexList() {
        this.Prop_Create_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Prop_Create_Button_actionPerformed"));
        this.Prop_Rebuild_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Rebuild"), 'B', DBAImageResource.getResource(this.getClass(), "/jdbaimages/rebuild.gif"), new ReflectionAction(this, "Prop_Rebuild_Button_actionPerformed"));
        this.Prop_Drop_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Prop_Drop_Button_actionPerformed"));
        this.Statistics_Update_Button = new DbaButton(new Dimension(160, 24), DbFrame.frame.res.getString("Update_Statistics"), 'U', DBAImageResource.getResource(this.getClass(), "/jdbaimages/update_statistics.gif"), new ReflectionAction(this, "Statistics_Update_Button_actionPerformed"));
        this.moveButton = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Move"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/rebuild.gif"), new ReflectionAction(this, "moveButtonActionPerformed"));
        this.Rename_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Rename"), 'R', DBAImageResource.getResource(this.getClass(), "/jdbaimages/rename.gif"), new ReflectionAction(this, "Rename_Button_actionPerformed"));
        this.Disable_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Disable"), 'S', DBAImageResource.getResource(this.getClass(), "/jdbaimages/disable.gif"), new ReflectionAction(this, "Disable_Button_actionPerformed"));
        this.jIndexCols = null;
        this.absModel1 = null;
        this.table1 = null;
        this.jIndexStatCols = null;
        this.absModel2 = null;
        this.table2 = null;
        this.Statistics_Sample_Ratio = new IntegerField(0, 0, 3);
        this.TB_OWNER = 0;
        this.TB_NAME = 1;
        this.INDEX = 2;
        this.TS_NAME = 3;
        this.UNIQUE = 4;
        this.KEYS_STRING = 5;
        this.CREATE_TIME = 7;
        this.DISABLE_STATUS = 6;
        this.DISABLE_STATUS1 = 3;
        this.PAGES = 4;
        this.LEVEL = 5;
        this.LEAF_PAGES = 6;
        this.DIST_KEY = 7;
        this.CLUSTER_COUNT = 8;
        this.SPACE_RATE = 9;
        this.table_owner = null;
        this.table_name = null;
        this.initTableSize = false;
        this.isStopped = false;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("IndexesTabbedPane");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "index.list.properties");
        DbaPanel jPanel2 = new DbaPanel(DbFrame.helpres, "index.list.statistics");
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JScrollPane jScrollPane1 = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        this.jIndexCols = new IndexCols();
        this.absModel1 = new DBAToolAbstractTableModel(this.jIndexCols);
        this.table1 = new JTable(this.absModel1);
        this.table1.setName("PropertiesIndexesTable");
        this.jIndexStatCols = new IndexStatCols();
        this.absModel2 = new DBAToolAbstractTableModel(this.jIndexStatCols);
        this.table2 = new JTable(this.absModel2);
        jPanel1.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout(5, 5));
        jLabel2.setText(DbFrame.frame.res.getString("Sample_Ratio_"));
        this.Statistics_Sample_Ratio.setText("100");
        jLabel3.setText("%");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.table1.setAutoResizeMode(4);
        this.add((Component)jPanel1, DbFrame.frame.res.getTitle("Properties"));
        jPanel1.add((Component)jPanel4, "North");
        jPanel4.setName("IndexesButtonPanel");
        this.Prop_Create_Button.setName("CreateButton");
        this.Prop_Drop_Button.setName("DropButton");
        this.Prop_Rebuild_Button.setName("RebuildButton");
        this.moveButton.setName("MoveButton");
        this.Rename_Button.setName("RenameButton");
        jPanel4.add((Component)this.Prop_Create_Button, null);
        jPanel4.add((Component)this.Prop_Drop_Button, null);
        jPanel4.add((Component)this.Prop_Rebuild_Button, null);
        jPanel4.add((Component)this.Rename_Button, null);
        jPanel4.add((Component)this.Disable_Button, null);
        jPanel1.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.add((Component)jPanel2, DbFrame.frame.res.getTitle("Statistics"));
        jPanel2.add((Component)jScrollPane2, "Center");
        jPanel2.add((Component)jPanel3, "North");
        jPanel3.add(this.Statistics_Update_Button);
        jPanel3.add(jLabel2);
        jPanel3.add(this.Statistics_Sample_Ratio);
        jPanel3.add(jLabel3);
        jScrollPane2.getViewport().add((Component)this.table2, null);
        this.table1.setSelectionMode(0);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table1_valueChanged"));
        this.table2.setSelectionMode(0);
        this.table2.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table2_valueChanged"));
        this.Statistics_Update_Button.setEnabled(false);
        this.Statistics_Sample_Ratio.setEnabled(false);
        this.getIndexInfo(this.table_owner, this.table_name);
        this.initIndexColumnSizes(this.table1);
        this.initIndexStatColumnSizes(this.table2);
        this.absModel1.addMouseListenerToHeaderInTable(this.table1);
        this.absModel2.addMouseListenerToHeaderInTable(this.table2);
        if (this.table_owner == null && this.table_name == null) {
            IndexMouseClickedListener indexMouseClickedListener = new IndexMouseClickedListener();
            this.table1.addMouseListener(indexMouseClickedListener);
        }
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
        if (this.table_owner != null && this.table_name != null) {
            this.hideColumn(this.table1, 0);
            this.hideColumn(this.table1, 1);
            this.hideColumn(this.table2, 0);
            this.hideColumn(this.table2, 1);
        }
    }

    void hideColumn(JTable table, int columnIndex) {
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        column.setMinWidth(0);
        column.setMaxWidth(0);
        column.setPreferredWidth(0);
    }

    @Override
    public int getComponentType() {
        return 12;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Prop_Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Prop_Drop_Button.setEnabled(enabled);
        boolean isFileVersionLater35 = enabled && DbFrame.conn_DatabaseConnection.isFileVersionLater35();
        this.Prop_Rebuild_Button.setEnabled(isFileVersionLater35);
        this.Rename_Button.setEnabled(isFileVersionLater35);
        int r = this.table1.getSelectedRow();
        if (r < 0 || this.jIndexCols.isDisable(r)) {
            this.Disable_Button.setEnabled(false);
        } else {
            this.Disable_Button.setEnabled(isFileVersionLater35);
        }
        boolean isFileVersionLater52 = enabled && DbFrame.conn_DatabaseConnection.isFileVersionLater52();
        this.moveButton.setEnabled(isFileVersionLater52);
    }

    public void table2_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.Statistics_Update_Button.setEnabled(false);
            this.Statistics_Sample_Ratio.setEnabled(false);
        } else {
            boolean isDisable = this.jIndexCols.isDisable(this.table2.getSelectedRow());
            this.Statistics_Update_Button.setEnabled(!isDisable);
            this.Statistics_Sample_Ratio.setEnabled(true);
        }
    }

    public void table1_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            int r = this.table1.getSelectedRow();
            String owner = "";
            if (this.table_owner != null) {
                owner = this.table_owner;
            } else {
                Object value = this.table1.getValueAt(r, 0);
                owner = (String)value;
            }
            this.authority.authorise(owner);
        }
    }

    private void initIndexColumnSizes(JTable table) {
        TableColumn column = null;
        int[] sizes = new int[]{80, 100, 100, 100, 60, 160, 120, 120};
        for (int i = 0; i < sizes.length; ++i) {
            column = table.getColumnModel().getColumn(i);
            column.setPreferredWidth(sizes[i]);
            if (i != 7) continue;
            column.setCellRenderer(new ColorfulTableCellRenderer(table, 7, "1970", new Color(255, 160, 170)));
        }
    }

    private void initIndexStatColumnSizes(JTable table) {
        TableColumn column = null;
        Object renderer = null;
        int LEFT = 2;
        int RIGHT = 4;
        int[] sizes = new int[]{100, 100, 120, 80, 80, 80, 80, 80, 80};
        int[] alignments = new int[]{LEFT, LEFT, LEFT, RIGHT, RIGHT, RIGHT, RIGHT, RIGHT, RIGHT};
        for (int i = 0; i < sizes.length; ++i) {
            column = table.getColumnModel().getColumn(i);
            column.setPreferredWidth(sizes[i]);
        }
    }

    private int getTableSize(String tb_owner, String tb_name) {
        int table_size = 0;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select NUM_PAGE from SYSTEM.SYSTABLE where TABLE_OWNER = '" + tb_owner + "' and TABLE_NAME = '" + tb_name + "'";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                table_size = rs.getInt(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        return table_size;
    }

    private int getTableSize(String tb_owner, String tb_name, ArrayList tableAL, ArrayList tbsizeAL) {
        String[] tbowner_name = null;
        int size = tableAL.size();
        for (int i = 0; i < size; ++i) {
            tbowner_name = (String[])tableAL.get(i);
            if (!tbowner_name[0].equals(tb_owner) && !tbowner_name[1].equals(tb_name)) continue;
            return (Integer)tbsizeAL.get(i);
        }
        return 0;
    }

    private void initTableSize(ArrayList tableAL, ArrayList tbsizeAL) {
        int table_size = 0;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String[] tbowner_name = null;
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select TABLE_OWNER, TABLE_NAME, NUM_PAGE from SYSTEM.SYSTABLE ";
            if (!DbFrame.frame.px.getShowSystemTable()) {
                query = query + "WHERE TABLE_OWNER != 'SYSTEM' ";
            }
            query = query + "ORDER BY TABLE_OWNER, TABLE_NAME ";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                tbowner_name = new String[]{GuiUt.rightTrim(rs.getString(1)), GuiUt.rightTrim(rs.getString(2))};
                table_size = rs.getInt(3);
                tableAL.add(tbowner_name);
                tbsizeAL.add(new Integer(table_size));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getIndexInfo(String table_owner, String table_name) {
        block13: {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                this.jIndexCols.removeAll();
                this.jIndexStatCols.removeAll();
                String query = "select idx.INDEX_NAME, idx.UNIQUE, idx.NUM_PAGE, idx.NUM_LEVEL, idx.NUM_LEAF, idx.DIST_KEY, idx.NUM_PAGE_KEY, idx.CLSTR_COUNT, DWTOSTR(idx.CREATE_TIME), idx.TABLE_OWNER, idx.TABLE_NAME, idx.RESERVE3, idx.NUM_COL, idx.TS_NAME , tb.NUM_PAGE from SYSTEM.SYSINDEX as idx, SYSTEM.SYSTABLE as tb ";
                String where = "";
                if (!DbFrame.frame.px.getShowSystemTable()) {
                    where = "WHERE idx.TABLE_OWNER != 'SYSTEM' ";
                }
                if (table_name != null) {
                    where = where.length() > 0 ? where + "AND " : "WHERE ";
                    where = table_owner != null ? where + "idx.TABLE_OWNER = '" + table_owner + "' " + "AND idx.TABLE_NAME = '" + table_name + "' " : where + "idx.TABLE_NAME = '" + table_name + "' ";
                }
                where = where.length() > 0 ? where + " AND idx.TABLE_OWNER = tb.TABLE_OWNER AND idx.TABLE_NAME = tb.TABLE_NAME " : " WHERE idx.TABLE_OWNER = tb.TABLE_OWNER AND idx.TABLE_NAME = tb.TABLE_NAME ";
                query = query + where;
                query = query + " order by idx.TABLE_OWNER, idx.TABLE_NAME, idx.UNIQUE DESC";
                Connection conn = DbFrame.conn_DatabaseConnection.getDbConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(query);
                ArrayList<String> keyUCList = new ArrayList<String>();
                ArrayList<IndexRowInfo> rowList = new ArrayList<IndexRowInfo>();
                List<String> columnList = null;
                String keys_String = null;
                while (rs.next()) {
                    String index_name = rs.getString(1);
                    String tb_owner = rs.getString(10);
                    String tb_name = rs.getString(11);
                    keyUCList.add(this.concat2UpperCase(tb_owner, tb_name, index_name));
                    keys_String = EMPTY_KEYS;
                    IndexRowInfo row = new IndexRowInfo(index_name, tb_owner, tb_name, rs.getString(14), rs.getShort(2), keys_String, rs.getString(9));
                    rowList.add(row);
                    IndexStatRowInfo statRow = new IndexStatRowInfo(index_name, tb_owner, tb_name, rs.getInt(3), rs.getInt(4), rs.getInt(5), rs.getInt(6), rs.getInt(7), rs.getInt(8), rs.getInt(15), row.disable);
                    this.jIndexStatCols.addValue(statRow);
                }
                if (table_name != null && table_owner != null) {
                    Map<String, List<String>> indexColumnMap = this.getIndexColumnMap(DbFrame.conn_DatabaseConnection.getDbConnection(), keyUCList, table_owner, table_name);
                    for (IndexRowInfo row1 : rowList) {
                        if (!indexColumnMap.containsKey(row1.getKeyUpperCase())) continue;
                        columnList = indexColumnMap.get(row1.getKeyUpperCase());
                        keys_String = this.concat(columnList, ", ");
                        row1.setKeysString(keys_String);
                    }
                }
                for (IndexRowInfo row1 : rowList) {
                    this.jIndexCols.addValue(row1);
                }
                if (this.jIndexCols.getRowCount() == 0) {
                    DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("No_data_found"));
                } else {
                    String s = GuiUt.mapStringForProperty(DbFrame.frame.res.getString("The_number_of_indexes_is"), Integer.toString(this.jIndexCols.getRowCount()));
                    DbFrame.frame.setStatusDisc(s);
                }
                rs.close();
                stmt.close();
                new GetColumns().start();
                DbaObject.close(rs);
            }
            catch (SQLException sqle) {
                GuiUt.showSQLException(DbFrame.frame, null, sqle);
                break block13;
            }
            finally {
                DbaObject.close(rs);
                DbaObject.close(stmt);
                rs = null;
                stmt = null;
            }
            DbaObject.close(stmt);
            rs = null;
            stmt = null;
        }
    }

    private String concat2UpperCase(String schema, String table, String index) {
        return this.concat(schema.trim(), table.trim(), index.trim(), "").toUpperCase();
    }

    private String concat(String schema, String table, String index, String interval) {
        StringBuffer result = new StringBuffer();
        result.append(schema).append(interval);
        result.append(table).append(interval);
        result.append(index);
        return result.toString();
    }

    private Map<String, Map<String, List<String>>> setSchemaTableIndexMap(Map<String, Map<String, List<String>>> schemaTableIndexMap, String schema, String table, String index) {
        Map<String, Map<String, List<String>>> result = schemaTableIndexMap;
        if (schema != null && schema.trim().length() != 0 && table != null && table.trim().length() != 0 && index != null && index.trim().length() != 0) {
            String indexKey;
            String schemaKey = schema.trim().toUpperCase();
            Map<Object, Object> tableIndexMap = null;
            tableIndexMap = schemaTableIndexMap.containsKey(schemaKey) ? schemaTableIndexMap.get(schemaKey) : new HashMap();
            String tableKey = table.trim().toUpperCase();
            List indexList = null;
            indexList = tableIndexMap.containsKey(tableKey) ? (List)tableIndexMap.get(tableKey) : new ArrayList();
            if (!indexList.contains(indexKey = index.trim().toUpperCase())) {
                indexList.add(indexKey);
            }
            tableIndexMap.put(tableKey, indexList);
            schemaTableIndexMap.put(schemaKey, tableIndexMap);
        }
        return result;
    }

    private Map<String, List<String>> getIndexColumnMap(Connection dbConnection, Map<String, Map<String, List<String>>> schemaTableIndexMap) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        int keyNum = 1;
        for (String schema : schemaTableIndexMap.keySet()) {
            Map<String, List<String>> tableIndexMap = schemaTableIndexMap.get(schema);
            for (String table : tableIndexMap.keySet()) {
                List<String> indexMap = tableIndexMap.get(table);
                Map<String, List<String>> tempResult = this.getIndexColumnMap(dbConnection, schema, table, indexMap, keyNum);
                result.putAll(tempResult);
            }
        }
        return result;
    }

    private Map<String, List<String>> getIndexColumnMap(Connection dbConnection, List<String> keyUCList, String table_owner, String table_name) {
        int keyNum = 3;
        return this.getIndexColumnMap(dbConnection, table_owner, table_name, keyUCList, keyNum);
    }

    private String concat(List<String> list, String interval) {
        StringBuffer result = new StringBuffer();
        for (String element : list) {
            result.append(element).append(interval);
        }
        result.delete(result.lastIndexOf(interval), result.length());
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> getIndexColumnMap(Connection dbConnection, String schema, String table, List<String> keyUCList, int keyNum) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ResultSet rs = null;
        try {
            rs = this.getIndexInfo(dbConnection, null, schema, table, false, false);
            int schemaIndex = rs.findColumn("TABLE_SCHEM");
            int tableIndex = rs.findColumn("TABLE_NAME");
            int indexIndex = rs.findColumn("INDEX_NAME");
            int columnIndex = rs.findColumn("COLUMN_NAME");
            int ascOrDescIndex = rs.findColumn("ASC_OR_DESC");
            while (rs.next()) {
                String tableSchema = rs.getString(schemaIndex);
                String tableName = rs.getString(tableIndex);
                String indexName = rs.getString(indexIndex);
                String key = null;
                if (tableSchema != null && tableName != null && indexName != null) {
                    key = this.concat2UpperCase(tableSchema, tableName, indexName);
                }
                String keyUC = null;
                keyUC = keyNum == 1 && indexName != null ? indexName.trim().toUpperCase() : key;
                if (keyUC == null || !keyUCList.contains(keyUC)) continue;
                String columnName = GuiUt.rightTrim(rs.getString(columnIndex));
                if (rs.getString(ascOrDescIndex).equals("D")) {
                    columnName = columnName.concat("(desc)");
                }
                if (key == null || key.length() == 0) continue;
                List columnList = null;
                columnList = result.containsKey(key) ? (List)result.get(key) : new ArrayList();
                columnList.add(columnName);
                result.put(key, columnList);
            }
            rs.close();
        }
        catch (SQLException ex) {
            try {
                GuiUt.showSQLException(DbFrame.frame, null, ex);
            }
            catch (Throwable throwable) {
                DbaObject.close(rs);
                rs = null;
                throw throwable;
            }
            DbaObject.close(rs);
            rs = null;
        }
        DbaObject.close(rs);
        rs = null;
        return result;
    }

    private ResultSet getIndexInfo(Connection dbConnection, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        ResultSet result = null;
        DatabaseMetaData dbmd = dbConnection.getMetaData();
        result = dbmd.getIndexInfo(catalog, schema, table, unique, approximate);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getIndexColumnList(Connection dbConnection, String schema, String table, String index) {
        ArrayList<String> result = new ArrayList<String>();
        ResultSet rs = null;
        if (schema != null) {
            schema = schema.trim();
        }
        if (table != null) {
            table = table.trim();
        }
        if (index != null) {
            index = index.trim();
        }
        try {
            rs = this.getIndexInfo(dbConnection, null, schema, table, false, false);
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                String keyUC = null;
                if (indexName != null) {
                    keyUC = indexName.trim().toUpperCase();
                }
                if (keyUC == null || !keyUC.equalsIgnoreCase(index)) continue;
                String columnName = GuiUt.rightTrim(rs.getString("COLUMN_NAME"));
                if (rs.getString("ASC_OR_DESC").equals("D")) {
                    columnName = columnName.concat("(desc)");
                }
                if (result.contains(columnName)) continue;
                result.add(columnName);
            }
            rs.close();
        }
        catch (SQLException ex) {
            try {
                GuiUt.showSQLException(DbFrame.frame, null, ex);
            }
            catch (Throwable throwable) {
                DbaObject.close(rs);
                rs = null;
                throw throwable;
            }
            DbaObject.close(rs);
            rs = null;
        }
        DbaObject.close(rs);
        rs = null;
        return result;
    }

    public static String getIndexKeys(Connection connectDB, Vector keys_Vector, short unique, String index_name, String tb_owner, String tb_name) {
        String keys_String = "";
        try {
            String[] keysInfo = null;
            DatabaseMetaData dbmd = connectDB.getMetaData();
            ResultSet rs_index = dbmd.getIndexInfo(null, tb_owner, tb_name, false, false);
            String name = null;
            while (rs_index.next()) {
                name = rs_index.getString("INDEX_NAME");
                if (name == null || index_name.compareToIgnoreCase(name.trim()) != 0) continue;
                keysInfo = new String[2];
                keysInfo[0] = GuiUt.rightTrim(rs_index.getString("COLUMN_NAME"));
                keys_String = keys_String.length() == 0 ? keysInfo[0] : keys_String + ", " + keysInfo[0];
                if (rs_index.getString("ASC_OR_DESC").equals("D")) {
                    keysInfo[1] = "desc";
                    keys_String = keys_String + "(desc)";
                } else {
                    keysInfo[1] = "asc";
                }
                if (keys_Vector == null) continue;
                if (unique == 3) {
                    keys_Vector.addElement(keysInfo[0]);
                    continue;
                }
                keys_Vector.addElement(keysInfo);
            }
            rs_index.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keys_String;
    }

    public static String getIndexKeys(Connection connectDB, Vector keys_Vector, String tb_owner, String tb_name) {
        String keys_String = "";
        try {
            DatabaseMetaData dbmd = connectDB.getMetaData();
            ResultSet rs_index = dbmd.getPrimaryKeys(null, tb_owner, tb_name);
            String name = null;
            while (rs_index.next()) {
                name = rs_index.getString("PK_NAME");
                if (name == null) continue;
                String columnName = GuiUt.rightTrim(rs_index.getString("COLUMN_NAME"));
                keys_String = keys_String.length() == 0 ? columnName : keys_String + ", " + columnName;
                if (keys_Vector == null) continue;
                keys_Vector.addElement(columnName);
            }
            rs_index.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keys_String;
    }

    private static String getIndexKeys(Connection connectDB, Vector keys_Vector, short unique, String dbname, String index_name, String tb_owner, String tb_name, byte[] reserve_bytes, short num_col) {
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        String keys_String = "";
        try {
            stmt = connectDB.createStatement();
            String[] keysInfo = null;
            for (int count = 0; count < num_col; ++count) {
                keysInfo = new String[2];
                byte litterBit = reserve_bytes[count * 2];
                byte bigBit = reserve_bytes[count * 2 + 1];
                int temp = 0;
                temp |= bigBit;
                temp <<= 8;
                int column_num = temp |= litterBit;
                if (column_num < 0) {
                    column_num += 32768;
                    keysInfo[1] = "desc";
                } else {
                    keysInfo[1] = "asc";
                }
                query = "select COLUMN_NAME from ";
                if (!dbname.equals(DbFrame.conn_DatabaseConnection.dbname)) {
                    query = query + dbname + ":";
                }
                if ((rs = stmt.executeQuery(query = query + "SYSTEM.SYSCOLUMN " + "where TABLE_OWNER = '" + tb_owner + "' and TABLE_NAME = '" + tb_name + "' and COLUMN_ORDER =" + column_num)).next()) {
                    keysInfo[0] = GuiUt.rightTrim(rs.getString(1));
                }
                if (keys_Vector != null) {
                    if (keys_Vector instanceof PrimaryKeyVector) {
                        keys_Vector.addElement(keysInfo[0]);
                    } else {
                        keys_Vector.addElement(keysInfo);
                    }
                }
                if (keys_String.length() == 0) {
                    keys_String = keysInfo[0] + " ";
                    if (keysInfo[1].equalsIgnoreCase("DESC")) {
                        keys_String = keys_String + "(" + keysInfo[1] + ")";
                    }
                } else {
                    keys_String = keys_String + "," + keysInfo[0] + " ";
                    if (keysInfo[1].equalsIgnoreCase("DESC")) {
                        keys_String = keys_String + "(" + keysInfo[1] + ")";
                    }
                }
                rs.close();
            }
            stmt.close();
        }
        catch (SQLException E) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            System.out.println("Transaction failed: " + E.getMessage());
        }
        return keys_String;
    }

    public static String getIndexKeys(Connection connectDB, Vector keys_Vector, short unique, String dbname, String index_name, String tb_owner, String tb_name) {
        Statement stmt = null;
        ResultSet rs = null;
        String keys_String = null;
        try {
            stmt = connectDB.createStatement();
            String query = "select NUM_COL, RESERVE3 from ";
            if (!dbname.equals(DbFrame.conn_DatabaseConnection.dbname)) {
                query = query + dbname + ":";
            }
            query = query + "SYSTEM.SYSINDEX " + "where UNIQUE=" + unique + " and TABLE_OWNER = '" + tb_owner + "' and TABLE_NAME = '" + tb_name + "'";
            if (index_name != null) {
                query = query + " and INDEX_NAME = '" + index_name + "'";
            }
            rs = stmt.executeQuery(query);
            short num_col = 0;
            byte[] reserve_bytes = null;
            while (rs.next()) {
                num_col = rs.getShort(1);
                reserve_bytes = rs.getBytes(2);
                keys_String = IndexList.getIndexKeys(connectDB, keys_Vector, unique, dbname, index_name, tb_owner, tb_name, reserve_bytes, num_col);
            }
            rs.close();
            stmt.close();
            stmt = null;
        }
        catch (SQLException E) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            System.out.println("Transaction failed: " + E.getMessage());
        }
        return keys_String;
    }

    public void Prop_Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        if (row >= this.table1.getRowCount() || row < 0) {
            return;
        }
        String tb_owner = (String)this.absModel1.getValueAt(row, 0);
        String tb_name = (String)this.absModel1.getValueAt(row, 1);
        String name = (String)this.absModel1.getValueAt(row, 2);
        String type = (String)this.absModel1.getValueAt(row, 3);
        String str1 = DbFrame.frame.res.getString("Do_you_want_to_drop_index");
        String str2 = GuiUt.mapStringForProperty(str1, GuiUt.getIDString(name));
        int reply = GuiUt.showOptionDlg(DbFrame.frame, DbFrame.frame.res.getString("Drop_Index"), str2 + " ?");
        if (reply != 0) {
            return;
        }
        String query = "";
        query = type.equals(DbFrame.frame.res.getString("Primary_Key")) ? "ALTER TABLE " + GuiUt.getIDString(tb_owner) + "." + GuiUt.getIDString(tb_name) + " DROP PRIMARY KEY" : "DROP INDEX " + GuiUt.getIDString(name) + " FROM " + GuiUt.getIDString(tb_owner) + "." + GuiUt.getIDString(tb_name);
        boolean result = DatabaseConnection.executeSQL(query);
        if (result) {
            GuiUt.showInformationDlg(DbFrame.frame, DbFrame.frame.res.getString("Index") + " " + GuiUt.getIDString(name) + DbFrame.frame.res.getString("has_been_droped"));
            DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("Index") + " " + GuiUt.getIDString(name) + DbFrame.frame.res.getString("has_been_droped"));
            DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
            this.jIndexCols.removeAll();
            this.jIndexStatCols.removeAll();
            System.gc();
            this.getIndexInfo(this.table_owner, this.table_name);
            if (row >= this.table1.getRowCount() || row < 0) {
                this.table1.clearSelection();
                this.table2.clearSelection();
                this.Prop_Drop_Button.setEnabled(false);
                this.Prop_Rebuild_Button.setEnabled(false);
                this.Rename_Button.setEnabled(false);
            }
            this.absModel1.fireTableChanged(new TableModelEvent(this.absModel1));
            this.absModel2.fireTableChanged(new TableModelEvent(this.absModel2));
            DbFrame.frame.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void Rename_Button_actionPerformed(ActionEvent e) {
        RenameIndexDlg dlg = null;
        dlg = new RenameIndexDlg(DbFrame.frame, DbFrame.frame.res.getString("Rename_Index"), true, this.table1.getValueAt(this.table1.getSelectedRow(), 0).toString().trim(), this.table1.getValueAt(this.table1.getSelectedRow(), 1).toString().trim(), this.table1.getValueAt(this.table1.getSelectedRow(), 2).toString().trim());
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.show();
    }

    public void Disable_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        if (row >= this.table1.getRowCount() || row < 0) {
            return;
        }
        String tb_owner = (String)this.absModel1.getValueAt(row, 0);
        String tb_name = (String)this.absModel1.getValueAt(row, 1);
        String name = (String)this.absModel1.getValueAt(row, 2);
        String type = (String)this.absModel1.getValueAt(row, 3);
        String str1 = DbFrame.frame.res.getString("Do_you_want_to_disable_index");
        int reply = GuiUt.showOptionDlg(DbFrame.frame, DbFrame.frame.res.getString("Disable_Index"), str1);
        if (reply != 0) {
            return;
        }
        String query = "";
        query = "DISABLE INDEX " + GuiUt.getIDString(name) + " FOR " + GuiUt.getIDString(tb_owner) + "." + GuiUt.getIDString(tb_name);
        boolean result = DatabaseConnection.executeSQL(query);
        if (result) {
            GuiUt.showInformationDlg(DbFrame.frame, DbFrame.frame.res.getString("Index") + " " + GuiUt.getIDString(name) + DbFrame.frame.res.getString("has_been_disabled"));
            DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("Index") + " " + GuiUt.getIDString(name) + DbFrame.frame.res.getString("has_been_droped"));
            DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
            this.jIndexCols.removeAll();
            this.jIndexStatCols.removeAll();
            System.gc();
            this.getIndexInfo(this.table_owner, this.table_name);
            if (row >= this.table1.getRowCount() || row < 0) {
                this.table1.clearSelection();
                this.table2.clearSelection();
                this.Prop_Drop_Button.setEnabled(false);
                this.Prop_Rebuild_Button.setEnabled(false);
                this.Rename_Button.setEnabled(false);
            }
            this.absModel1.fireTableChanged(new TableModelEvent(this.absModel1));
            this.absModel2.fireTableChanged(new TableModelEvent(this.absModel2));
            DbFrame.frame.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void moveButtonActionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        if (row < 0) {
            return;
        }
        String dtsName = null;
        String idxName = null;
        String tbName = null;
        String ownName = null;
        if (this.table_name != null) {
            tbName = this.table_name;
            ownName = this.table_owner;
            idxName = (String)this.absModel1.getValueAt(row, 0);
            dtsName = (String)this.absModel1.getValueAt(row, 1);
        } else {
            ownName = (String)this.absModel1.getValueAt(row, 0);
            tbName = (String)this.absModel1.getValueAt(row, 1);
            idxName = (String)this.absModel1.getValueAt(row, 2);
            dtsName = (String)this.absModel1.getValueAt(row, 3);
        }
        new MoveIndexDialog(DbFrame.frame, tbName, ownName, idxName, dtsName);
        this.getIndexInfo(this.table_owner, this.table_name);
        this.absModel1.fireTableChanged(null);
        this.absModel2.fireTableChanged(null);
        this.table1.setRowSelectionInterval(row, row);
    }

    public void Prop_Rebuild_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        if (row < 0) {
            return;
        }
        String index_name = (String)this.absModel1.getValueAt(row, 2);
        String tb_owner = (String)this.absModel1.getValueAt(row, 0);
        String tb_name = (String)this.absModel1.getValueAt(row, 1);
        String str1 = DbFrame.frame.res.getString("Do_you_want_to_rebuild_index");
        String str2 = GuiUt.mapStringForProperty(str1, GuiUt.getIDString(index_name));
        int reply = GuiUt.showOptionDlg(DbFrame.frame, DbFrame.frame.res.getString("Rebuild"), str2 + " ?");
        if (reply != 0) {
            return;
        }
        String query = "REBUILD INDEX " + GuiUt.getIDString(index_name) + " FOR " + GuiUt.getIDString(tb_owner) + "." + GuiUt.getIDString(tb_name);
        DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(DbFrame.frame.res.getString("Rebuilding_index"), GuiUt.getIDString(index_name)));
        boolean result = DatabaseConnection.executeSQL(query);
        DbFrame.frame.setStatusDisc("  ");
        if (result) {
            DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("Index_has_been"));
            GuiUt.showInformationDlg(DbFrame.frame, DbFrame.frame.res.getString("Index") + " " + GuiUt.getIDString(index_name) + " " + DbFrame.frame.res.getString("rebuild_successfully") + " !");
            this.getIndexInfo(this.table_owner, this.table_name);
            if (row >= this.table1.getRowCount() || row < 0) {
                this.table1.clearSelection();
                this.table2.clearSelection();
                this.Prop_Drop_Button.setEnabled(false);
                this.Prop_Rebuild_Button.setEnabled(false);
                this.Rename_Button.setEnabled(false);
            }
            this.absModel1.fireTableChanged(new TableModelEvent(this.absModel1));
            this.absModel2.fireTableChanged(new TableModelEvent(this.absModel2));
        }
    }

    public void Statistics_Update_Button_actionPerformed(ActionEvent e) {
        int reply = GuiUt.showOptionDlg(DbFrame.frame, DbFrame.frame.res.getString("Update_Statistics"), DbFrame.frame.res.getString("Do_you_want_to_update_index_statistics"));
        if (reply != 0) {
            return;
        }
        Integer ratio = new Integer(this.Statistics_Sample_Ratio.getText());
        if (ratio < 1 || ratio > 100) {
            DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("Sample_ratio_should"));
        }
        int row = this.table2.getSelectedRow();
        String index_name = (String)this.absModel2.getValueAt(row, 2);
        String tb_owner = (String)this.absModel2.getValueAt(row, 0);
        String tb_name = (String)this.absModel2.getValueAt(row, 1);
        String query = "UPDATE STATISTICS " + GuiUt.getIDString(tb_owner) + "." + GuiUt.getIDString(tb_name) + " ( INDEX " + GuiUt.getIDString(index_name) + ") SAMPLE = " + ratio.toString();
        DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("Updating_statistics_"));
        boolean result = DatabaseConnection.executeSQL(query);
        DbFrame.frame.setStatusDisc("  ");
        if (result) {
            GuiUt.showInformationDlg(DbFrame.frame, DbFrame.frame.res.getString("Statistics_has_been"));
            this.getIndexInfo(this.table_owner, this.table_name);
            this.absModel2.fireTableChanged(new TableModelEvent(this.absModel2));
            this.table2.setRowSelectionInterval(row, row);
        }
    }

    public void Prop_Create_Button_actionPerformed(ActionEvent e) {
        Wizard_idx dlg = this.table_name != null ? new Wizard_idx((Frame)DbFrame.frame, this.table_owner, this.table_name) : new Wizard_idx(DbFrame.frame);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.setModal(true);
        dlg.show();
        dlg = null;
        this.getIndexInfo(this.table_owner, this.table_name);
        this.absModel1.fireTableChanged(new TableModelEvent(this.absModel1));
        this.absModel2.fireTableChanged(new TableModelEvent(this.absModel2));
    }

    @Override
    public void this_stateChanged(ChangeEvent e) {
        super.this_stateChanged(e);
        int index = this.getSelectedIndex();
        if (index < 1 || index >= this.getComponentCount()) {
            return;
        }
        if (this.initTableSize) {
            return;
        }
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        int row_count = this.table1.getRowCount();
        int table_size = 0;
        int rate = 0;
        String num_page_str = null;
        if (row_count < 100) {
            for (int i = 0; i < row_count; ++i) {
                num_page_str = (String)this.jIndexStatCols.getValueAt(i, this.PAGES);
                if (num_page_str.equals("N/A")) {
                    this.jIndexStatCols.setValueAt(new String("N/A"), i, this.SPACE_RATE);
                    continue;
                }
                table_size = this.getTableSize((String)this.jIndexStatCols.getValueAt(i, 0), (String)this.jIndexStatCols.getValueAt(i, 1));
                if (table_size == 0) {
                    this.jIndexStatCols.setValueAt(new String("N/A"), i, this.SPACE_RATE);
                    continue;
                }
                rate = Integer.parseInt(num_page_str) * 100 / table_size;
                this.jIndexStatCols.setValueAt(new String(rate + "%"), i, this.SPACE_RATE);
            }
        } else {
            ArrayList tableAL = new ArrayList(200);
            ArrayList tbsizeAL = new ArrayList(200);
            this.initTableSize(tableAL, tbsizeAL);
            for (int i = 0; i < row_count; ++i) {
                num_page_str = (String)this.jIndexStatCols.getValueAt(i, this.PAGES);
                if (num_page_str.equals("N/A")) {
                    this.jIndexStatCols.setValueAt(new String("N/A"), i, this.SPACE_RATE);
                    continue;
                }
                table_size = this.getTableSize((String)this.jIndexStatCols.getValueAt(i, 0), (String)this.jIndexStatCols.getValueAt(i, 1), tableAL, tbsizeAL);
                if (table_size == 0) {
                    this.jIndexStatCols.setValueAt(new String("N/A"), i, this.SPACE_RATE);
                    continue;
                }
                rate = Integer.parseInt(num_page_str) * 100 / table_size;
                this.jIndexStatCols.setValueAt(new String(rate + "%"), i, this.SPACE_RATE);
            }
        }
        this.initTableSize = true;
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    private class IndexMouseClickedListener
    extends MouseInputAdapter {
        private IndexMouseClickedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            int rowIndex = IndexList.this.table1.getSelectedRow();
            if (rowIndex >= 0) {
                TableModel dataModel = IndexList.this.table1.getModel();
                Object value = dataModel.getValueAt(rowIndex, IndexList.this.KEYS_STRING);
                String keys = null;
                if (value != null) {
                    keys = value.toString();
                }
                if (EMPTY_KEYS.equals(keys)) {
                    DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        String schema = null;
                        String table = null;
                        String index = null;
                        value = dataModel.getValueAt(rowIndex, IndexList.this.TB_OWNER);
                        if (value != null) {
                            schema = value.toString();
                        }
                        if ((value = dataModel.getValueAt(rowIndex, IndexList.this.TB_NAME)) != null) {
                            table = value.toString();
                        }
                        if ((value = dataModel.getValueAt(rowIndex, IndexList.this.INDEX)) != null) {
                            index = value.toString();
                        }
                        List columnList = IndexList.this.getIndexColumnList(DbFrame.conn_DatabaseConnection.getDbConnection(), schema, table, index);
                        String keys_String = IndexList.this.concat(columnList, ", ");
                        dataModel.setValueAt(keys_String, rowIndex, IndexList.this.KEYS_STRING);
                        IndexList.this.table1.tableChanged(new TableModelEvent(dataModel, rowIndex, rowIndex, IndexList.this.KEYS_STRING));
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        }
    }

    private class IndexCols
    extends AbstractTableModel
    implements ColumnSorting {
        private String[] allColumnNames;
        private Vector data;

        public IndexCols() {
            this.allColumnNames = new String[]{DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Table_Name"), DbFrame.frame.res.getString("Index"), DbFrame.frame.res.getString("Tablespace"), DbFrame.frame.res.getString("Type"), DbFrame.frame.res.getString("Column_Names"), DbFrame.frame.res.getString("Disable_Status"), DbFrame.frame.res.getString("Creation_Time")};
            this.data = new Vector();
        }

        @Override
        public int getColumnCount() {
            return this.allColumnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.allColumnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            IndexRowInfo rowData = (IndexRowInfo)this.data.elementAt(row);
            return rowData.getValueAt(col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            IndexRowInfo rowData = (IndexRowInfo)this.data.elementAt(rowIndex);
            rowData.setValueAt(aValue, columnIndex);
        }

        public Class getColumnClass(int c) {
            IndexRowInfo rowData = (IndexRowInfo)this.data.elementAt(0);
            return rowData.getValueAt(c).getClass();
        }

        public void addValue(IndexRowInfo newData) {
            this.data.addElement(newData);
        }

        public void removeAll() {
            this.data.removeAllElements();
        }

        @Override
        public void switchOrder(int godown, int goup) {
            Object downRow = this.data.elementAt(godown);
            Object upRow = this.data.elementAt(goup);
            this.data.setElementAt(downRow, goup);
            this.data.setElementAt(upRow, godown);
        }

        public boolean isDisable(int row) {
            IndexRowInfo rowData = (IndexRowInfo)this.data.elementAt(row);
            return rowData.disable;
        }
    }

    private class IndexRowInfo {
        Object[] data = new Object[8];
        boolean disable = false;

        public IndexRowInfo(String name, String tb_owner, String tb_name, String ts_name, short unique, String keys_String, String create_time) {
            this.data[((IndexList)IndexList.this).TB_OWNER] = GuiUt.rightTrim(tb_owner);
            this.data[((IndexList)IndexList.this).TB_NAME] = GuiUt.rightTrim(tb_name);
            this.data[((IndexList)IndexList.this).INDEX] = GuiUt.rightTrim(name);
            this.data[((IndexList)IndexList.this).TS_NAME] = GuiUt.rightTrim(ts_name);
            switch (unique) {
                case 0: {
                    this.data[((IndexList)IndexList.this).UNIQUE] = new String(DbFrame.frame.res.getString("Not_Unique"));
                    this.data[((IndexList)IndexList.this).DISABLE_STATUS] = DbFrame.frame.res.getString("Enabled");
                    break;
                }
                case 1: {
                    this.data[((IndexList)IndexList.this).UNIQUE] = new String(DbFrame.frame.res.getString("Unique"));
                    this.data[((IndexList)IndexList.this).DISABLE_STATUS] = DbFrame.frame.res.getString("Enabled");
                    break;
                }
                case 3: {
                    this.data[((IndexList)IndexList.this).UNIQUE] = new String(DbFrame.frame.res.getString("Primary_Key"));
                    this.data[((IndexList)IndexList.this).DISABLE_STATUS] = DbFrame.frame.res.getString("Enabled");
                    break;
                }
                case 4: {
                    this.data[((IndexList)IndexList.this).UNIQUE] = new String(DbFrame.frame.res.getString("Auto_Index"));
                    this.data[((IndexList)IndexList.this).DISABLE_STATUS] = DbFrame.frame.res.getString("Enabled");
                    break;
                }
                case 8: {
                    this.data[((IndexList)IndexList.this).UNIQUE] = new String(DbFrame.frame.res.getString("Not_Unique"));
                    this.data[((IndexList)IndexList.this).DISABLE_STATUS] = DbFrame.frame.res.getString("Disabled");
                    this.disable = true;
                    break;
                }
                case 9: {
                    this.data[((IndexList)IndexList.this).UNIQUE] = new String(DbFrame.frame.res.getString("Unique"));
                    this.data[((IndexList)IndexList.this).DISABLE_STATUS] = DbFrame.frame.res.getString("Disabled");
                    this.disable = true;
                    break;
                }
                case 11: {
                    this.data[((IndexList)IndexList.this).UNIQUE] = new String(DbFrame.frame.res.getString("Primary_Key"));
                    this.data[((IndexList)IndexList.this).DISABLE_STATUS] = DbFrame.frame.res.getString("Disabled");
                    this.disable = true;
                    break;
                }
                case 12: {
                    this.data[((IndexList)IndexList.this).UNIQUE] = new String(DbFrame.frame.res.getString("Auto_Index"));
                    this.data[((IndexList)IndexList.this).DISABLE_STATUS] = DbFrame.frame.res.getString("Disabled");
                    this.disable = true;
                }
            }
            this.data[((IndexList)IndexList.this).KEYS_STRING] = keys_String;
            this.data[((IndexList)IndexList.this).CREATE_TIME] = create_time;
        }

        public Object getValueAt(int index) {
            return this.data[index];
        }

        public void setValueAt(Object value, int index) {
            this.data[index] = value;
        }

        public String getKeyUpperCase() {
            return IndexList.this.concat2UpperCase(this.data[IndexList.this.TB_OWNER].toString(), this.data[IndexList.this.TB_NAME].toString(), this.data[IndexList.this.INDEX].toString());
        }

        public void setKeysString(String value) {
            this.setValueAt(value, IndexList.this.KEYS_STRING);
        }
    }

    private class IndexStatCols
    extends AbstractTableModel
    implements ColumnSorting {
        private String[] allColumnNames;
        private ArrayList data;

        public IndexStatCols() {
            this.allColumnNames = new String[]{DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Table_Name"), DbFrame.frame.res.getString("Index"), DbFrame.frame.res.getString("Disable_Status"), DbFrame.frame.res.getString("Pages"), DbFrame.frame.res.getString("Level"), DbFrame.frame.res.getString("Leaf_Pages"), DbFrame.frame.res.getString("Distinct_Key"), DbFrame.frame.res.getString("Cluster_Count"), DbFrame.frame.res.getString("Space_Percentage")};
            this.data = new ArrayList();
        }

        @Override
        public int getColumnCount() {
            return this.allColumnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.allColumnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            IndexStatRowInfo rowData = (IndexStatRowInfo)this.data.get(row);
            return rowData.getValueAt(col);
        }

        public Class getColumnClass(int c) {
            IndexStatRowInfo rowData = (IndexStatRowInfo)this.data.get(0);
            return rowData.getValueAt(c).getClass();
        }

        public void addValue(IndexStatRowInfo newData) {
            this.data.add(newData);
        }

        public void removeAll() {
            this.data.clear();
        }

        @Override
        public void switchOrder(int godown, int goup) {
            Object downRow = this.data.get(godown);
            Object upRow = this.data.get(goup);
            this.data.set(goup, downRow);
            this.data.set(godown, upRow);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            IndexStatRowInfo rowData = (IndexStatRowInfo)this.data.get(row);
            rowData.setValueAt(value, col);
        }
    }

    private class IndexStatRowInfo {
        Object[] data = new Object[10];

        public IndexStatRowInfo(String index, String tb_owner, String tb_name, int num_page, int num_level, int num_leaf, int dist_key, int num_page_key, int clstr_count, int table_size, boolean disable_status) {
            this.data[((IndexList)IndexList.this).TB_OWNER] = GuiUt.rightTrim(tb_owner);
            this.data[((IndexList)IndexList.this).TB_NAME] = GuiUt.rightTrim(tb_name);
            this.data[((IndexList)IndexList.this).INDEX] = GuiUt.rightTrim(index);
            this.data[((IndexList)IndexList.this).DISABLE_STATUS1] = disable_status ? DbFrame.frame.res.getString("Disabled") : DbFrame.frame.res.getString("Enabled");
            if (num_page == -1) {
                this.data[((IndexList)IndexList.this).PAGES] = new String("N/A");
                this.data[((IndexList)IndexList.this).SPACE_RATE] = new String("N/A");
            } else {
                this.data[((IndexList)IndexList.this).PAGES] = new String(new Integer(num_page).toString());
                if (table_size == 0) {
                    this.data[((IndexList)IndexList.this).SPACE_RATE] = new String("N/A");
                } else {
                    int rate = num_page * 100 / table_size;
                    this.data[((IndexList)IndexList.this).SPACE_RATE] = new String(rate + "%");
                }
            }
            this.data[((IndexList)IndexList.this).LEVEL] = num_level == -1 ? new String("N/A") : new String(new Integer(num_level).toString());
            this.data[((IndexList)IndexList.this).LEAF_PAGES] = num_leaf == -1 ? new String("N/A") : new String(new Integer(num_leaf).toString());
            this.data[((IndexList)IndexList.this).DIST_KEY] = dist_key == -1 ? new String("N/A") : new String(new Integer(dist_key).toString());
            this.data[((IndexList)IndexList.this).CLUSTER_COUNT] = clstr_count == -1 ? new String("N/A") : new String(new Integer(clstr_count).toString());
        }

        public Object getValueAt(int index) {
            return this.data[index];
        }

        public void setValueAt(Object value, int index) {
            this.data[index] = value;
        }
    }

    class ColorfulTableCellRenderer
    extends DefaultTableCellRenderer {
        private final JTable table;
        private final int targetColumn;
        private final String targetValue;
        private final Color rowColor;
        private final ImageIcon icon;

        public ColorfulTableCellRenderer(JTable table, int targetColumn, String targetValue, Color rowColor) {
            this.table = table;
            this.targetColumn = targetColumn;
            this.targetValue = targetValue;
            this.rowColor = rowColor;
            this.icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancelwizard.gif");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                ((JLabel)c).setIcon(null);
            }
            if (table.getValueAt(row, this.targetColumn).toString().startsWith(this.targetValue)) {
                c.setBackground(this.rowColor);
                if (c instanceof JLabel) {
                    ((JLabel)c).setToolTipText("Advise rebuilding the index.");
                    ((JLabel)c).setIcon(this.icon);
                }
            } else {
                c.setBackground(table.getBackground());
            }
            if (isSelected) {
                c.setBackground(c.getBackground().darker());
                c.setForeground(table.getSelectionForeground());
            } else {
                c.setForeground(table.getForeground());
            }
            return c;
        }
    }

    class GetColumns
    extends Thread {
        GetColumns() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            TableModel dataModel = IndexList.this.table1.getModel();
            int rowCount = dataModel.getRowCount();
            Object value = null;
            String keys = null;
            String schema = null;
            String table = null;
            String index = null;
            List columnList = null;
            Connection conn = DbFrame.conn_DatabaseConnection.getDbConnection();
            String keys_String = null;
            for (int rowIndex = 0; rowIndex < rowCount && !IndexList.this.isStopped; ++rowIndex) {
                value = dataModel.getValueAt(rowIndex, IndexList.this.KEYS_STRING);
                if (value != null) {
                    keys = value.toString();
                }
                if (!EMPTY_KEYS.equals(keys)) continue;
                try {
                    value = dataModel.getValueAt(rowIndex, IndexList.this.TB_OWNER);
                    if (value != null) {
                        schema = value.toString();
                    }
                    if ((value = dataModel.getValueAt(rowIndex, IndexList.this.TB_NAME)) != null) {
                        table = value.toString();
                    }
                    if ((value = dataModel.getValueAt(rowIndex, IndexList.this.INDEX)) != null) {
                        index = value.toString();
                    }
                    columnList = IndexList.this.getIndexColumnList(conn, schema, table, index);
                    keys_String = IndexList.this.concat(columnList, ", ");
                    dataModel.setValueAt(keys_String, rowIndex, IndexList.this.KEYS_STRING);
                    if (rowIndex % 100 != 0 || !(dataModel instanceof DefaultTableModel)) continue;
                    ((DefaultTableModel)dataModel).fireTableDataChanged();
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (IndexList.this.isStopped) {
                System.out.println("GetColumns stopped!");
            }
        }
    }
}

