/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Database;

import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.GraphicPanel;
import dbatool.LoginDlg;
import dbatool.tableModel.BasicInfoTableModel;
import dbatool.tableModel.FileSize;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.comp.DbaPanel;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;

public class DatabaseInfo
extends DbaTabbedPane {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private BasicInfoTableModel databaseTableModel = new BasicInfoTableModel();
    private JTable table = new JTable(this.databaseTableModel);
    private JPanel jPanel3 = new JPanel();
    private long byteperpage;
    private long byteperframe;

    public DatabaseInfo() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("DatabaseInfo");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "home");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel1.setLayout(new BorderLayout());
        jPanel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.setBackground(Color.white);
        this.jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel2.setLayout(new BorderLayout());
        this.add((Component)jPanel1, this.res.getTitle("General_Information"));
        jPanel1.add((Component)this.jPanel3, "Center");
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.table, "Center");
        this.authority = DbaAuthorityFactory.create(null);
        this.byteperpage = DbFrame.conn_DatabaseConnection.getDbPageSize();
        this.byteperframe = DbFrame.conn_DatabaseConnection.getBlobFrameSize();
        this.getDatabaseSysInfo();
    }

    private String getServerAddress() {
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", LoginDlg.selectedDBName, "r");
        if (rc != 0) {
            config.fileClose();
            System.out.println("127.0.0.1@");
            return "127.0.0.1@";
        }
        String s = (String)config.getPara("DB_SVADR", 4096);
        System.out.println(s);
        config.fileClose();
        return s + "@";
    }

    private void getDatabaseSysInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.databaseTableModel.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = DbFrame.conn_DatabaseConnection.isDBTDE() ? "SELECT INFO, VALUE FROM SYSTEM.SYSINFO WHERE INFO IN ('VERSION','FILE_VERSION','PRODUCT_INFO','BUILD_VERSION','CREATE_DB_TIME','START_DB_TIME','FRAME_SIZE','TDE_STATUS') " : "SELECT INFO, VALUE FROM SYSTEM.SYSINFO WHERE INFO IN ('VERSION','FILE_VERSION','PRODUCT_INFO','BUILD_VERSION','CREATE_DB_TIME','START_DB_TIME','FRAME_SIZE') ";
            rs = stmt.executeQuery(query);
            Object[] new_row = null;
            while (rs.next()) {
                new_row = new Object[]{this.res.getString(rs.getString(1)), rs.getString(2)};
                this.databaseTableModel.addValue(new_row);
            }
            rs.close();
            rs = null;
            if (this.authority.isAboveDba()) {
                Integer objI = new Integer(this.databaseTableModel.getValueAt(0, 1).toString());
                DbFrame.conn_DatabaseConnection.setBlobFrameSize(objI);
                this.byteperframe = DbFrame.conn_DatabaseConnection.getBlobFrameSize();
            }
            if (DbFrame.conn_DatabaseConnection.isVersionLaterOrEqual36()) {
                query = "SELECT GETSYSINFO('DBDIR'), GETSYSINFO('LCODE'), GETSYSINFO('LICENSE') from SYSTEM.SYSINFO";
                rs = stmt.executeQuery(query);
                rs.next();
                new_row = new Object[2];
                new_row[0] = this.res.getString("DB_DIR");
                String ss = rs.getString(1);
                new_row[1] = DbFrame.frame.isLocalHost ? ss : this.getServerAddress() + ss;
                this.databaseTableModel.addValue(new_row);
                if (DbFrame.frame.isLocalHost) {
                    DbFrame.conn_DatabaseConnection.setDBDir(new_row[1].toString());
                } else {
                    DbFrame.conn_DatabaseConnection.setDBDir(this.getServerAddress() + new_row[1].toString());
                }
                new_row = new Object[2];
                new_row[0] = this.res.getString("Language_Code");
                String lang = rs.getString(2);
                if (lang.length() > 0) {
                    lang = lang.trim();
                    int lcode = new Integer(lang);
                    switch (lcode) {
                        case 0: {
                            new_row[1] = new String("0 - ASCII");
                            break;
                        }
                        case 1: {
                            new_row[1] = new String("1 - Chinese BIG5");
                            break;
                        }
                        case 2: {
                            new_row[1] = new String("2 - Japanese Shift JIS");
                            break;
                        }
                        case 3: {
                            new_row[1] = new String("3 - Simplified Chinese GB2312");
                            break;
                        }
                        case 4: {
                            new_row[1] = new String("4 - Latin ISO-8859-1");
                            break;
                        }
                        case 5: {
                            new_row[1] = new String("5 - Latin ISO-8859-2");
                            break;
                        }
                        case 6: {
                            new_row[1] = new String("6 - Cyrillic ISO-8859-5");
                            break;
                        }
                        case 7: {
                            new_row[1] = new String("7 - Greek ISO-8859-7");
                            break;
                        }
                        case 8: {
                            new_row[1] = new String("8 - Japanese EUC-JP");
                            break;
                        }
                        case 9: {
                            new_row[1] = new String("9 - Simplified Chinese GB18030");
                            break;
                        }
                        case 10: {
                            new_row[1] = new String("10 - UTF-8");
                            break;
                        }
                        default: {
                            new_row[1] = new String("");
                            break;
                        }
                    }
                } else {
                    new_row[1] = new String("");
                }
                this.databaseTableModel.addValue(new_row);
                new_row = new Object[]{this.res.getString("Num_Licenses"), rs.getString(3)};
                this.databaseTableModel.addValue(new_row);
            }
            rs.close();
            rs = null;
            if (this.authority.isAboveDba()) {
                query = "select SUM( NUM_PAGES ), SUM( NUM_FREE_PAGES ), SUM( NUM_FRAMES ), SUM( NUM_FREE_FRAMES ) from SYSTEM.SYSTABLESPACE ";
                rs = stmt.executeQuery(query);
                rs.next();
                long num_pages = rs.getInt(1);
                int num_free_pages = rs.getInt(2);
                long num_frames = rs.getInt(3);
                int num_free_frames = rs.getInt(4);
                long num_used_frames = num_frames - (long)num_free_frames;
                long num_used_pages = num_pages - (long)num_free_pages;
                float page_ratio = (float)num_used_pages / (float)num_pages * 100.0f;
                float frame_ratio = (float)num_used_frames / (float)num_frames * 100.0f;
                new_row = new Object[]{this.res.getString("Total_Pages"), new String(num_pages + " ( " + FileSize.sizeToStr(num_pages * this.byteperpage) + " )")};
                this.databaseTableModel.addValue(new_row);
                new_row = new Object[]{this.res.getString("Used_Pages"), new String(num_pages - (long)num_free_pages + " ( " + FileSize.sizeToStr((num_pages - (long)num_free_pages) * this.byteperpage) + " )")};
                this.databaseTableModel.addValue(new_row);
                new_row = new Object[]{this.res.getString("Total_Frames"), new String(num_frames + " ( " + FileSize.sizeToStr(num_frames * this.byteperframe) + " )")};
                this.databaseTableModel.addValue(new_row);
                new_row = new Object[]{this.res.getString("Used_Frames"), new String(num_frames - (long)num_free_frames + " ( " + FileSize.sizeToStr((num_frames - (long)num_free_frames) * this.byteperframe) + " )")};
                this.databaseTableModel.addValue(new_row);
                new_row = new Object[2];
                new_row[0] = this.res.getString("Expiration_Date");
                CallableStatement cstmt = DbFrame.conn_DatabaseConnection.getDbConnection().prepareCall("{call GETSYSTEMOPTION('lic_expiredate',?)}");
                cstmt.registerOutParameter(1, 12);
                cstmt.executeQuery();
                String lic_expiredate = cstmt.getString(1);
                cstmt.close();
                new_row[1] = lic_expiredate;
                this.databaseTableModel.addValue(new_row);
                rs.close();
                stmt.close();
                rs = null;
                stmt = null;
                this.databaseTableModel.moveRowWithSpecificValueToLast(this.res.getString("TDE_STATUS"));
                GraphicPanel pie_frame = new GraphicPanel(this.res.getString("Frames_Graphic"), this.res.getString("Total_Frames") + " " + FileSize.sizeToStr(num_frames * this.byteperframe), this.res.getString("Used") + " " + frame_ratio, frame_ratio);
                GraphicPanel pie_page = new GraphicPanel(this.res.getString("Pages_Graphic"), this.res.getString("Total_Pages") + " " + FileSize.sizeToStr(num_pages * this.byteperpage), this.res.getString("Used") + " " + page_ratio, page_ratio);
                this.jPanel3.add((Component)pie_frame, "Center");
                this.jPanel3.add((Component)pie_page, "West");
            }
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }
}

