/*
 * Decompiled with CFR 0.152.
 */
package datatransfer;

import datatransfer.DataTransferFrame;
import dbaut.preference.CorePreferences;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PreferencesXml
extends CorePreferences {
    private Point position = new Point(0, 0);
    private short import_odbc_option = 1;
    private String selected_directory = null;
    private Element syscom = null;
    public String orString = null;
    public boolean isWindows = true;
    public String user_dir = null;
    public String file_separator = null;
    public static final int IMPORT_ODBC_OPTION = 0;
    public static final int SELECTED_DIRECTORY = 1;
    private static PreferencesXml self = null;
    private HashMap<String, DataType> typeMap = new HashMap();

    public static void initPreferencesXml() {
        if (self == null) {
            self = new PreferencesXml();
        }
    }

    public static PreferencesXml getPreferencesXml() {
        if (self == null) {
            self = new PreferencesXml();
        }
        return self;
    }

    public PreferencesXml() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.file_separator = System.getProperty("file.separator");
        this.user_dir = System.getProperty("user.dir");
        this.isWindows = this.file_separator.equals("\\");
        this.init(CorePreferences.getConfigName());
    }

    private void init(String fileName) throws Exception {
        File f = new File(fileName);
        if (!f.exists()) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(fileName);
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        String temp = null;
        Node node = null;
        this.resetDOM(doc);
        node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/datatransfer");
        if (node != null && node.getNodeType() == 1 && (temp = ((Element)node).getAttribute("selected_directory")) != null && temp.length() > 0) {
            this.selected_directory = temp;
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/datatransfer/frame")) != null && node.getNodeType() == 1) {
            Element elm = (Element)node;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int xpos = 0;
            int ypos = 0;
            temp = elm.getAttribute("xpos");
            if (temp != null && temp.length() > 0 && ((xpos = Integer.parseInt(temp)) < 0 || (double)xpos > screenSize.getWidth())) {
                xpos = 0;
            }
            if ((temp = elm.getAttribute("ypos")) != null && temp.length() > 0 && ((ypos = Integer.parseInt(temp)) < 0 || (double)ypos > screenSize.getHeight())) {
                ypos = 0;
            }
            this.position = new Point(xpos, ypos);
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/datatransfer/options")) != null && node.getNodeType() == 1 && (temp = ((Element)node).getAttribute("import_odbc_option")) != null && temp.length() > 0) {
            this.import_odbc_option = Short.parseShort(temp);
        }
        NodeList list = XPathAPI.selectNodeList((Node)doc, (String)"/syscom/datatransfer/datatype");
        int precision = 0;
        int scale = 0;
        temp = null;
        if (list != null && list.getLength() > 0) {
            for (int i = 0; i < list.getLength(); ++i) {
                node = list.item(i);
                String type = ((Element)node).getAttribute("type");
                String dmType = ((Element)node).getAttribute("dmType");
                String udf = ((Element)node).getAttribute("udf");
                temp = ((Element)node).getAttribute("precision");
                precision = temp != null && temp.length() > 0 ? Integer.parseInt(temp) : 0;
                temp = ((Element)node).getAttribute("scale");
                scale = temp != null && temp.length() > 0 ? Integer.parseInt(temp) : 0;
                this.typeMap.put(type.toLowerCase(), new DataType(type, dmType, precision, scale, udf));
            }
        }
    }

    public void updateVariables(int options, String value) {
        switch (options) {
            case 0: {
                this.import_odbc_option = Short.parseShort(value);
                break;
            }
            case 1: {
                this.selected_directory = value;
            }
        }
    }

    public Point getLocation() {
        return this.position;
    }

    public short getImportOdbcOptionSetting() {
        return this.import_odbc_option;
    }

    public String getSelectedDirectory() {
        return this.selected_directory;
    }

    @Override
    public void save() {
        this.save(CorePreferences.getConfigName());
    }

    private void save(String fileName) {
        this.position = DataTransferFrame.frame.getLocationOnScreen();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = null;
        Node node = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Document doc = null;
        Element datatransfer = null;
        File file = new File(fileName);
        if (file.exists()) {
            try {
                doc = builder.parse(fileName);
            }
            catch (Exception pe) {
                doc = builder.newDocument();
            }
        } else {
            doc = builder.newDocument();
        }
        this.setDOM(doc);
        this.syscom = doc.getDocumentElement();
        if (this.syscom == null) {
            System.out.println("CorePreferences fails to save <syscom>");
        }
        try {
            node = XPathAPI.selectSingleNode((Node)this.syscom, (String)"datatransfer");
            if (node != null && node.getNodeType() == 1) {
                datatransfer = (Element)node;
            }
        }
        catch (Exception pe) {
            // empty catch block
        }
        if (datatransfer == null) {
            datatransfer = doc.createElement("datatransfer");
            this.syscom.appendChild(datatransfer);
        }
        if (this.selected_directory != null && this.selected_directory.length() > 0) {
            datatransfer.setAttribute("selected_directory", this.selected_directory);
        }
        Element frame = null;
        try {
            node = XPathAPI.selectSingleNode((Node)datatransfer, (String)"frame");
            if (node != null && node.getNodeType() == 1) {
                frame = (Element)node;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (frame == null) {
            frame = doc.createElement("frame");
            datatransfer.appendChild(frame);
        }
        frame.setAttribute("xpos", Integer.toString((int)this.position.getX()));
        frame.setAttribute("ypos", Integer.toString((int)this.position.getY()));
        Element options = null;
        try {
            node = XPathAPI.selectSingleNode((Node)datatransfer, (String)"frame");
            if (node != null && node.getNodeType() == 1) {
                options = (Element)node;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (options == null) {
            options = doc.createElement("options");
            datatransfer.appendChild(options);
        }
        System.out.println("PreferencesXml save method import_odbc_option valus is = " + this.import_odbc_option);
        options.setAttribute("import_odbc_option", Short.toString(this.import_odbc_option));
        Element type = null;
        DataType dt = null;
        for (Map.Entry<String, DataType> e : this.typeMap.entrySet()) {
            try {
                node = XPathAPI.selectSingleNode((Node)datatransfer, (String)("datatype[@type='" + e.getKey() + "']"));
                if (node != null && node.getNodeType() == 1) {
                    type = (Element)node;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (type == null) {
                type = doc.createElement("datatype");
                datatransfer.appendChild(type);
            }
            type.setAttribute("type", e.getKey());
            dt = e.getValue();
            if (dt.dmType != null && dt.dmType.length() > 0) {
                type.setAttribute("dmType", dt.dmType);
            }
            if (dt.udf != null && dt.udf.length() > 0) {
                type.setAttribute("udf", dt.udf);
            }
            if (dt.precision != 0) {
                type.setAttribute("precision", Integer.toString(dt.precision));
            }
            if (dt.scale == 0) continue;
            type.setAttribute("scale", Integer.toString(dt.scale));
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            StreamResult result = new StreamResult(out);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            out.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public String getUdfForType(String type) {
        DataType dt = this.getTypeMap(type);
        if (dt != null && dt.udf != null && dt.udf.length() > 0) {
            return dt.udf;
        }
        return null;
    }

    public String getDmTypeForType(String type) {
        DataType dt = this.getTypeMap(type);
        if (dt != null && dt.dmType != null) {
            if (dt.dmType.compareTo("char") == 0 || dt.dmType.compareTo("vchar") == 0 || dt.dmType.compareTo("nchar") == 0 || dt.dmType.compareTo("nvchar") == 0 || dt.dmType.compareTo("binary") == 0) {
                if (dt.precision > 0) {
                    return dt.dmType + "(" + dt.precision + ")";
                }
            } else if (dt.dmType.compareTo("decimal") == 0) {
                if (dt.precision > 0) {
                    if (dt.scale > 0) {
                        return dt.dmType + "(" + dt.precision + "," + dt.scale + ")";
                    }
                    return dt.dmType + "(" + dt.precision + ")";
                }
            } else {
                return dt.dmType;
            }
        }
        return null;
    }

    public DataType getTypeMap(String type) {
        DataType dt;
        if (type != null && (dt = this.typeMap.get(type.toLowerCase())) != null && dt.dmType != null) {
            return dt;
        }
        return null;
    }

    public class DataType {
        public String type = null;
        public String dmType = null;
        public int precision = 0;
        public int scale = 0;
        public String udf = null;

        DataType(String type, String dmType, int precision, int scale, String udf) {
            this.type = type;
            String string = this.dmType = dmType != null && dmType.length() == 0 ? null : dmType;
            if (this.dmType != null) {
                this.dmType = this.dmType.toLowerCase();
            }
            this.precision = precision;
            this.scale = scale;
            this.udf = udf != null && udf.length() == 0 ? null : udf;
        }
    }
}

