/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.annotation;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.annotation.AnnotationImpl;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.AnnotationsWriter;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.NoSuchClassError;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;

public class Annotation {
    private ConstPool a;
    private int b;
    private LinkedHashMap c;

    /*
     * WARNING - void declaration
     */
    public Annotation(int type, ConstPool cp) {
        void var1_1;
        void var2_2;
        this.a = var2_2;
        this.b = var1_1;
        this.c = null;
    }

    /*
     * WARNING - void declaration
     */
    public Annotation(String typeName, ConstPool cp) {
        this(cp.addUtf8Info(Descriptor.of((String)var1_1)), (ConstPool)var2_2);
        void var2_2;
        void var1_1;
    }

    public Annotation(ConstPool cp, CtClass clazz) throws NotFoundException {
        this(cp.addUtf8Info(Descriptor.of(clazz.getName())), cp);
        CtMethod[] ctMethodArray;
        if (!clazz.isInterface()) {
            throw new RuntimeException("Only interfaces are allowed for Annotation creation.");
        }
        if ((ctMethodArray = ctMethodArray.getDeclaredMethods()).length > 0) {
            this.c = new LinkedHashMap();
        }
        for (int i2 = 0; i2 < ctMethodArray.length; ++i2) {
            CtClass ctClass = ctMethodArray[i2].getReturnType();
            this.addMemberValue(ctMethodArray[i2].getName(), Annotation.createMemberValue(cp, ctClass));
        }
    }

    public static MemberValue createMemberValue(ConstPool cp, CtClass type) throws NotFoundException {
        ConstPool constPool;
        MemberValue memberValue;
        if (type == CtClass.booleanType) {
            return new BooleanMemberValue(cp);
        }
        if (type == CtClass.byteType) {
            return new ByteMemberValue(cp);
        }
        if (type == CtClass.charType) {
            return new CharMemberValue(cp);
        }
        if (type == CtClass.shortType) {
            return new ShortMemberValue(cp);
        }
        if (type == CtClass.intType) {
            return new IntegerMemberValue(cp);
        }
        if (type == CtClass.longType) {
            return new LongMemberValue(cp);
        }
        if (type == CtClass.floatType) {
            return new FloatMemberValue(cp);
        }
        if (type == CtClass.doubleType) {
            return new DoubleMemberValue(cp);
        }
        if (type.getName().equals("java.lang.Class")) {
            return new ClassMemberValue(cp);
        }
        if (type.getName().equals("java.lang.String")) {
            return new StringMemberValue(cp);
        }
        if (type.isArray()) {
            CtClass ctClass = type.getComponentType();
            memberValue = Annotation.createMemberValue(cp, ctClass);
            return new ArrayMemberValue(memberValue, cp);
        }
        if (((CtClass)((Object)memberValue)).isInterface()) {
            Annotation annotation = new Annotation(cp, (CtClass)((Object)memberValue));
            return new AnnotationMemberValue(annotation, cp);
        }
        EnumMemberValue enumMemberValue = new EnumMemberValue(constPool);
        enumMemberValue.setType(((CtClass)((Object)memberValue)).getName());
        return enumMemberValue;
    }

    /*
     * WARNING - void declaration
     */
    public void addMemberValue(int nameIndex, MemberValue value) {
        a a2;
        void var1_1;
        Object object = new a();
        new a().a = var1_1;
        ((a)object).b = a2;
        a2 = object;
        Annotation annotation = this;
        object = annotation.a.getUtf8Info(a2.a);
        if (annotation.c == null) {
            annotation.c = new LinkedHashMap();
        }
        annotation.c.put(object, a2);
    }

    /*
     * WARNING - void declaration
     */
    public void addMemberValue(String name, MemberValue value) {
        void var1_1;
        void var2_2;
        a a2 = new a();
        new a().a = this.a.addUtf8Info(name);
        a2.b = var2_2;
        if (this.c == null) {
            this.c = new LinkedHashMap();
        }
        this.c.put(var1_1, a2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("@");
        stringBuffer.append(this.getTypeName());
        if (this.c != null) {
            stringBuffer.append("(");
            Iterator iterator = this.c.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string).append("=").append(this.getMemberValue(string));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String getTypeName() {
        return Descriptor.toClassName(this.a.getUtf8Info(this.b));
    }

    public Set getMemberNames() {
        if (this.c == null) {
            return null;
        }
        return this.c.keySet();
    }

    public MemberValue getMemberValue(String name) {
        a a2;
        if (this.c == null) {
            return null;
        }
        if ((a2 = (a)this.c.get(a2)) == null) {
            return null;
        }
        return a2.b;
    }

    /*
     * WARNING - void declaration
     */
    public Object toAnnotationType(ClassLoader cl, ClassPool cp) throws ClassNotFoundException, NoSuchClassError {
        void var2_2;
        ClassLoader classLoader = cl;
        return AnnotationImpl.make(classLoader, MemberValue.a(classLoader, this.getTypeName()), (ClassPool)var2_2, this);
    }

    public void write(AnnotationsWriter writer) throws IOException {
        String string = this.a.getUtf8Info(this.b);
        if (this.c == null) {
            writer.annotation(string, 0);
            return;
        }
        writer.annotation(string, this.c.size());
        for (a a2 : this.c.values()) {
            writer.memberValuePair(a2.a);
            a2.b.write(writer);
        }
    }

    public boolean equals(Object obj) {
        Object object;
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Annotation)) {
            return false;
        }
        object = (Annotation)object;
        if (!this.getTypeName().equals(((Annotation)object).getTypeName())) {
            return false;
        }
        object = ((Annotation)object).c;
        if (this.c == object) {
            return true;
        }
        if (this.c == null) {
            return object == null;
        }
        if (object == null) {
            return false;
        }
        return this.c.equals(object);
    }

    static final class a {
        int a;
        MemberValue b;

        a() {
        }
    }
}

