/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.analysis;

import java.io.PrintStream;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.InstructionPrinter;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.Opcode;
import javassist.bytecode.analysis.Analyzer;
import javassist.bytecode.analysis.Frame;
import javassist.bytecode.analysis.Type;

public final class FramePrinter {
    private final PrintStream a;

    /*
     * WARNING - void declaration
     */
    public FramePrinter(PrintStream stream) {
        void var1_1;
        this.a = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void print(CtClass clazz, PrintStream stream) {
        CtClass ctClass;
        void var1_1;
        new FramePrinter((PrintStream)var1_1).print(ctClass);
    }

    public final void print(CtClass clazz) {
        CtMethod[] ctMethodArray = clazz.getDeclaredMethods();
        for (int i2 = 0; i2 < ctMethodArray.length; ++i2) {
            this.print(ctMethodArray[i2]);
        }
    }

    private static String a(CtMethod ctMethod) {
        try {
            return Modifier.toString(ctMethod.getModifiers()) + " " + ctMethod.getReturnType().getName() + " " + ctMethod.getName() + Descriptor.toString(ctMethod.getSignature()) + ";";
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
    }

    public final void print(CtMethod method) {
        Frame[] frameArray;
        this.a.println("\n" + FramePrinter.a(method));
        MethodInfo methodInfo = method.getMethodInfo2();
        ConstPool constPool = methodInfo.getConstPool();
        Opcode opcode = methodInfo.getCodeAttribute();
        if (opcode == null) {
            return;
        }
        try {
            frameArray = new Analyzer().analyze(frameArray.getDeclaringClass(), methodInfo);
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
        int n2 = String.valueOf(((CodeAttribute)opcode).getCodeLength()).length();
        opcode = ((CodeAttribute)opcode).iterator();
        while (((CodeIterator)opcode).hasNext()) {
            int n3;
            try {
                n3 = ((CodeIterator)opcode).next();
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException(badBytecode);
            }
            this.a.println(n3 + ": " + InstructionPrinter.instructionString((CodeIterator)opcode, n3, constPool));
            this.a(n2 + 3);
            Frame frame = frameArray[n3];
            if (frame == null) {
                this.a.println("--DEAD CODE--");
                continue;
            }
            this.a(frame);
            this.a(n2 + 3);
            this.b(frame);
        }
    }

    private void a(Frame frame) {
        this.a.print("stack [");
        int n2 = frame.getTopIndex();
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (i2 > 0) {
                this.a.print(", ");
            }
            Type type = frame.getStack(i2);
            this.a.print(type);
        }
        this.a.println("]");
    }

    private void b(Frame frame) {
        this.a.print("locals [");
        int n2 = frame.localsLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Type type;
            if (i2 > 0) {
                this.a.print(", ");
            }
            this.a.print((type = frame.getLocal(i2)) == null ? "empty" : type.toString());
        }
        this.a.println("]");
    }

    private void a(int n2) {
        while (n2-- > 0) {
            this.a.print(' ');
        }
    }
}

