/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.sql;

import dbmaker.sql.JdbcOdbc;
import dbmaker.sql.JdbcOdbcAPI;
import dbmaker.sql.JdbcOdbcConnection;
import dbmaker.sql.JdbcOdbcStatement;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ResourceBundle;

public class JdbcOdbcParameterMetaData
extends JdbcOdbc
implements ParameterMetaData {
    private JdbcOdbcAPI ODBCOBJ;
    private JdbcOdbcStatement myStatement = null;
    private int nParam;
    public static final int parameterModeIn = 1;
    public static final int parameterModeInOut = 2;
    public static final int parameterModeOut = 4;
    public static final int parameterModeUnknown = 0;
    public static final int parameterNoNulls = 0;
    public static final int parameterNullable = 1;
    public static final int parameterNullableUnknown = 2;

    public JdbcOdbcParameterMetaData(JdbcOdbcAPI jdbcOdbcAPI, JdbcOdbcStatement jdbcOdbcStatement, int n) throws SQLException {
        if (this.needTrace) {
            this.trace("new ParameterMetaData");
        }
        this.ODBCOBJ = jdbcOdbcAPI;
        this.myStatement = jdbcOdbcStatement;
        this.nParam = n;
    }

    public int getParameterCount() throws SQLException {
        if (this.needTrace) {
            this.trace("ParameterMetaData.getParameterCount()");
        }
        return this.nParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int isNullable(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ParameterMetaData.isNullable(" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", "ParameterMetaData.isNullable(" + n + ")");
        }
        int[] nArray = new int[1];
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.ODBCOBJ.jdbcDescribeParam(this.myStatement.getHSTMT(), n, null, null, null, nArray);
        }
        if (nArray[0] == 1) {
            return 1;
        }
        if (nArray[0] == 0) {
            return 0;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSigned(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ParameterMetaData.isSigned(" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", "ParameterMetaData.getPrecision(" + n + ")");
        }
        int[] nArray = new int[1];
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.ODBCOBJ.jdbcDescribeParam(this.myStatement.getHSTMT(), n, nArray, null, null, null);
        }
        return nArray[0] >= 2 && nArray[0] <= 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPrecision(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ParameterMetaData.getPrecision(" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", "ParameterMetaData.getPrecision(" + n + ")");
        }
        long[] lArray = new long[1];
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.ODBCOBJ.jdbcDescribeParam(this.myStatement.getHSTMT(), n, null, lArray, null, null);
        }
        return (int)lArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScale(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ParameterMetaData.getScale(" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", "ParameterMetaData.getPrecision(" + n + ")");
        }
        int[] nArray = new int[1];
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.ODBCOBJ.jdbcDescribeParam(this.myStatement.getHSTMT(), n, null, null, nArray, null);
        }
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getParameterType(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ParameterMetaData.getParameterType(" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", "ParameterMetaData.getPrecision(" + n + ")");
        }
        int[] nArray = new int[1];
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.ODBCOBJ.jdbcDescribeParam(this.myStatement.getHSTMT(), n, nArray, null, null, null);
        }
        return this.odbc2JavaType(nArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameterTypeName(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ParameterMetaData.getParameterTypeName(" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", "ParameterMetaData.getPrecision(" + n + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            return this.ODBCOBJ.jdbcDescParamTypename(this.myStatement.getHSTMT(), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameterClassName(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ParameterMetaData.getParameterClassName(" + n + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", "ParameterMetaData.getPrecision(" + n + ")");
        }
        int[] nArray = new int[1];
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.ODBCOBJ.jdbcDescribeParam(this.myStatement.getHSTMT(), n, nArray, null, null, null);
        }
        return this.mapClass(this.odbc2JavaType(nArray[0]));
    }

    public int getParameterMode(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ParameterMetaData.getParameterMode(" + n + ")");
        }
        return 1;
    }

    protected ResourceBundle getResourceBundle() {
        try {
            return ((JdbcOdbcConnection)this.myStatement.getConnection()).getResourceBundle();
        }
        catch (Exception exception) {
            return this.ODBCOBJ.getResourceBundle();
        }
    }
}

