/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.sql;

import dbmaker.sql.JdbcOdbc;
import dbmaker.sql.JdbcOdbcAPI;
import dbmaker.sql.JdbcOdbcConnection;
import dbmaker.sql.JdbcOdbcDriver;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ResourceBundle;
import javax.sql.DataSource;

public class JdbcOdbcDataSource
extends JdbcOdbc
implements DataSource {
    protected JdbcOdbcAPI ODBCOBJ;
    protected static JdbcOdbcDriver myDriver;
    protected JdbcOdbcConnection conn = null;
    protected long hENV;
    protected boolean isClose;
    protected SQLWarning lastWarning;
    protected String dbName = null;
    protected String dsName = new String("dbmaker.sql.JdbcOdbcDataSource");
    protected String descp;
    protected String uid = null;
    protected String passwd = null;

    public JdbcOdbcDataSource() throws SQLException {
        if (myDriver == null) {
            myDriver = new JdbcOdbcDriver();
        }
        this.ODBCOBJ = JdbcOdbcDataSource.myDriver.getDriver().ODBCOBJ;
        this.isClose = false;
    }

    public void setDatabaseName(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("setDatabaseName (" + string + ")");
        }
        this.checkClosed(this.isClose);
        this.dbName = string;
    }

    public String getDatabaseName() throws SQLException {
        if (this.needTrace) {
            this.trace("getDatabaseName ()");
        }
        this.checkClosed(this.isClose);
        return this.dbName;
    }

    public void setDataSourceName(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("setDataSourceName (" + string + ")");
        }
        this.checkClosed(this.isClose);
        this.dsName = string;
    }

    public String getDataSourceName() throws SQLException {
        if (this.needTrace) {
            this.trace("getDataSourceName ()");
        }
        this.checkClosed(this.isClose);
        return this.dsName;
    }

    public void setDescription(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("setDescription (" + string + ")");
        }
        this.checkClosed(this.isClose);
        this.descp = string;
    }

    public String getDescription() throws SQLException {
        if (this.needTrace) {
            this.trace("getDescription ()");
        }
        this.checkClosed(this.isClose);
        return this.descp;
    }

    public void setUser(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("setUser (" + string + ")");
        }
        this.checkClosed(this.isClose);
        this.uid = string;
    }

    public String getUser() throws SQLException {
        if (this.needTrace) {
            this.trace("getUser ()");
        }
        this.checkClosed(this.isClose);
        return this.uid;
    }

    public void setPassword(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("setPassword (" + string + ")");
        }
        this.checkClosed(this.isClose);
        this.passwd = string;
    }

    public void setPortNumber(int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "JdbcOdbcDataSource.setPortNumber(int pn)", null);
    }

    public int getPortNumber() throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "JdbcOdbcDataSource.getPortNumber()", null);
    }

    public void setServerName(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "JdbcOdbcDataSource.setServerNumber(String sn)", null);
    }

    public String getServerName() throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "JdbcOdbcDataSource.getServerNumber()", null);
    }

    public void setNetworkProtocol(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "JdbcOdbcDataSource.setNetworkProtocol(String np)", null);
    }

    public String getNetworkProtocol() throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "JdbcOdbcDataSource.getNetworkProtocol()", null);
    }

    public Connection getConnection() throws SQLException {
        if (this.needTrace) {
            this.trace("getConnection()");
        }
        return this.getConnection(this.uid, this.passwd);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (this.needTrace) {
            this.trace("setConnection(String username, String password)");
        }
        this.checkClosed(this.isClose);
        JdbcOdbcDriver.Driver driver = myDriver.getDriver();
        this.conn = new JdbcOdbcConnection(this.dbName, string, string2, driver);
        this.hENV = driver.hENV;
        this.ODBCOBJ = driver.ODBCOBJ;
        return this.conn;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "JdbcOdbcDataSource.setLogWriter(PrintWriter out)", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoginTimeout(int n) throws SQLException {
        block7: {
            if (this.needTrace) {
                this.trace("setLoginTimeout (" + n + ")");
            }
            this.checkClosed(this.isClose);
            try {
                if (this.conn != null) {
                    JdbcOdbcConnection jdbcOdbcConnection = this.conn;
                    synchronized (jdbcOdbcConnection) {
                        this.ODBCOBJ.jdbcSetConnectAttrInt(this.conn.getHDBC(), 103, n);
                        break block7;
                    }
                }
                throw this.JDBCError("JERR_CONN_NOT_OPEN", "setLoginTimeout(int seconds)", null);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLoginTimeout() throws SQLException {
        int n;
        block7: {
            n = 0;
            if (this.needTrace) {
                this.trace("getLoginTimeout ()");
            }
            this.checkClosed(this.isClose);
            try {
                if (this.conn != null) {
                    JdbcOdbcConnection jdbcOdbcConnection = this.conn;
                    synchronized (jdbcOdbcConnection) {
                        n = this.ODBCOBJ.jdbcGetConnectAttrInt(this.conn.getHDBC(), 103);
                        break block7;
                    }
                }
                throw this.JDBCError("JERR_CONN_NOT_OPEN", "getLoginTimeout()", null);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return n;
    }

    protected ResourceBundle getResourceBundle() {
        return this.conn.getResourceBundle();
    }
}

