#!/bin/sh
#
# The startup and shutdown script for DBMaker database
#
# chkconfig: 2345 90 10
# description: Starts and stops the DBMaker dmserver daemons at boot time \
#              and shutdown.  DBMaker provides you with a professional \
#              database system with multimedia capabilities, a native ODBC \
#              interface, large database features, and cross-platform support.
# processname: dmserver
# config: /etc/dminit.conf
#

app_name=dbmaker
app_home=`awk -F: '$1~/^'${app_name}'$/ {print $6}' /etc/passwd`
app_conf=/etc/dminit.conf

linux_start() {
  printf "Starging ${app_name}: "
  awk -F: '$1!~/^#/ {print $1,$2,$3 }' ${app_conf} |
  while read app_db arg2 app_owner; do
    [ -n "${app_db}" -a -n "${arg2}" -a -n "${app_owner}" ] || continue
    app_cmd="${app_home}/${arg2}/bin/dmserver"
    [ "`echo ${arg2} | cut -c1`" = "/" ] && app_cmd="${arg2}"
    su -m ${app_owner} -c "${app_cmd} ${app_db} 2>&1 >/dev/null" && \
      printf "${app_db} " || printf "${app_db}:FAILED "
  done
  touch /var/lock/subsys/dminit && success || failure
  echo
  return 0
}

linux_stop() {
  printf "Shutting down ${app_name}: "
  awk -F: '$1!~/^#/ {print $1,$2,$3 }' ${app_conf} |
  while read app_db arg2 app_owner; do
    [ -n "${app_db}" -a -n "${arg2}" -a -n "${app_owner}" ] || continue
    app_cmd="${app_home}/${arg2}/bin/dmserver"
    [ "`echo ${arg2} | cut -c1`" = "/" ] && app_cmd="${arg2}"
    ${app_cmd} -k ${app_db} > /dev/null 2>&1 && \
      printf "${app_db} " || printf "${app_db}:FAILED "
  done
  killproc dmserver.bin -TERM
  rm -f /var/lock/subsys/dminit && success || failure
  echo
  return 0
}

# Source function library
if [ -f /etc/init.d/functions ]; then
  . /etc/init.d/functions
elif [ -f /etc/rc.d/init.d/functions ]; then
  . /etc/rc.d/init.d/functions
else
  exit 0
fi

# Check that $app_conf exists.
[ -f ${app_conf} ] || exit 0

case "$1" in
  start)
    linux_start
    ;;
  stop)
    linux_stop
    ;;
  restart)
    linux_stop
    sleep 5
    linux_start
    ;;
  *)
    echo "Usage: `basename $0` { start | stop | restart }"
    exit 64
    ;;
esac

exit $?

