#!/bin/sh
#
# The startup and shutdown script for DBMaker database
#
# FreeBSD rcNG script:
# PROVIDE: dbmaker
# REQUIRE: NETWORKING SERVERS
# BEFORE: DAEMON
# KEYWORD: FreeBSD shutdown
# Add the following lines to /etc/rc.conf to enable dbmaker:
#  dbmaker_enable="YES"
#

app_name=dbmaker
app_home=`awk -F: '$1~/^'${app_name}'$/ {print $6}' /etc/passwd`
app_conf=/usr/local/etc/dminit.conf

app_start() {
  printf "Starging ${app_name}: "
  awk -F: '$1!~/^#/ {print $1,$2,$3 }' ${app_conf} |
  while read app_db arg2 app_owner; do
    [ -n "${app_db}" -a -n "${arg2}" -a -n "${app_owner}" ] || continue
    app_cmd="${app_home}/${arg2}/bin/dmserver"
    [ "`echo ${arg2} | cut -c1`" = "/" ] && app_cmd="${arg2}"
    su -m ${app_owner} -c "${app_cmd} ${app_db} 2>&1 >/dev/null" && \
      printf "${app_db} " || printf "${app_db}:FAILED "
  done
  echo
}

app_stop() {
  printf "Stopping ${app_name}: "
  awk -F: '$1!~/^#/ {print $1,$2,$3 }' ${app_conf} |
  while read app_db arg2 app_owner; do
    [ -n "${app_db}" -a -n "${arg2}" -a -n "${app_owner}" ] || continue
    app_cmd="${app_home}/${arg2}/bin/dmserver"
    [ "`echo ${arg2} | cut -c1`" = "/" ] && app_cmd="${arg2}"
    ${app_cmd} -k ${app_db} 2>&1 >/dev/null && \
      printf "${app_db} " || printf "${app_db}:FAILED "
  done
  echo
}

rcNG() {
  # Source function library
  if [ -f /etc/rc.subr ]; then
    . /etc/rc.subr
  elif [ -f /usr/local/etc/rc.subr ]; then
    . /usr/local/etc/rc.subr
  else
    exit 0
  fi
  dbmaker_enable=${dbmaker_enable:-"NO"}
  name=${app_name}
  rcvar=`set_rcvar`
  required_files=${app_conf}
  start_cmd="app_start"
  stop_cmd="app_stop"
  load_rc_config ${name}
  run_rc_command "$1"
}

rcNG "$1"
