/*************************************************************************
 * demo4: demonstrate Database Objects Privilege
 *************************************************************************/
set printto usrgrp04.txt;

connect to dbsample5 sysadm;

grant connect to dbausr;
grant dba to dbausr;	//user dbausr is granted DBA database authority

grant connect to resusr;
grant resource to resusr;	//user resusr is granted RESOURCE database authority

grant connect to connusr1;	//user connusr1 only has CONNECT database authority
grant connect to connusr2;
grant connect to connusr3;

create group selectgp;
create group updategp;
add connusr1 to group selectgp;
add connusr2 to group updategp;
add connusr2 to group selectgp;

disconnect;
connect to dbsample5 resusr; //resusr has RESOURCE privilege

create table resusr.t1(c1 int,c2 double,c3 char(10));
insert into resusr.t1 values(?,?,?);
1,123.456,'aaa bbb';
2,234.567,'bbb ccc';
end;

grant select on resusr.t1 to selectgp;	//the users of selectgp can select on resusr.t1
grant insert,update on resusr.t1 to updategp; 
//the users of updategp can perform INSERT or UPDATE operation on resusr.t1

create view resusr.v1 as select * from resusr.t1;
grant all privileges on resusr.v1 to connusr3;

create command resusr.cmdsel as select * from resusr.t1;
create command resusr.cmdins as insert into resusr.t1 values(?,?,?);
grant execute on command resusr.cmdsel to selectgp,connusr3;
grant execute on command resusr.cmdins to updategp;

disconnect;
connect to dbsample5 connusr1;
select * from resusr.t1;
insert into resusr.t1 values(123,456.789,'adcd ef');
select * from resusr.v1;
execute command resusr.cmdsel;
execute command resusr.cmdins(123,45.67,'aaa bbb');

disconnect;
connect to dbsample5 connusr2;
select * from resusr.t1;
insert into resusr.t1 values(123,456.789,'adcd ef');
select * from resusr.v1;
execute command resusr.cmdsel;
execute command resusr.cmdins(123,45.67,'aaa bbb');

disconnect;
connect to dbsample5 connusr3;
select * from resusr.t1;
insert into resusr.t1 values(123,456.789,'adcd ef');
select * from resusr.v1;
execute command resusr.cmdsel;
execute command resusr.cmdins(123,45.67,'aaa bbb');

// resusr has all privileges on its own objects
disconnect;
connect to dbsample5 resusr;
select * from resusr.t1;
insert into resusr.t1 values(123,456.789,'adcd ef');
select * from resusr.v1;
execute command resusr.cmdsel;
execute command resusr.cmdins(123,45.67,'aaa bbb');

//DBA and SYSADM has all privileges on any user's objects
disconnect;
connect to dbsample5 dbausr;
select * from resusr.t1;
insert into resusr.t1 values(123,456.789,'adcd ef');
select * from resusr.v1;
execute command resusr.cmdsel;
execute command resusr.cmdins(123,45.67,'aaa bbb');

//clear
disconnect;
connect to dbsample5 sysadm;
drop command resusr.cmdsel;
drop command resusr.cmdins;
drop view resusr.v1;
drop table resusr.t1;
revoke connect from connusr1;
revoke connect from connusr2;
revoke connect from connusr3;
revoke connect from resusr;
revoke connect from dbausr;
//drop default schema after delete the user
drop schema dbausr;
drop schema resusr;
drop schema connusr1;
drop schema connusr2;
drop schema connusr3;
drop group selectgp;
drop group updategp;

set printto off;
disconnect;
q;