/******************************************************************************
 * Copyright(c) 1998-2010 SYSCOM
 * All rights reserved.
 ******************************************************************************
 * 1. Sample purpose:
 *    (1) Demonstrate CALL a SQL SP in JAVA.
 * 2. To Compile and run a JAVA program
 *    Please refer to JDBC sample.
 * Note: 
 *   Compiling this program need JDK 1.5 or later.
 *   Please firstly start database DBSAMPLE5 and create related table and 
 *   SQL SP. The dependency relationship like below:
 *      CallSqlSp(Java) 
 *           +--> sqlsp_nest1(SQL SP) -> sqlsp_student(TABLE).
 *           +--> sqlsp_resultset(SQL SP) -> sqlsp_alltype(TABLE).
 *
 * For more information, see the README file in the same directory.
 ******************************************************************************/

import java.io.*;
import java.sql.*;
import java.util.*;

public class CallSqlSp
{
  public String Driver;
  public String Url;
  public String Uid;
  public String Pwd;
  
  public CallSqlSp(String driver, String url, String uid, String pwd)
  {
    this.Driver = driver;
    this.Url = url;
    this.Uid = uid;
    this.Pwd = pwd;
  }
  public CallSqlSp()
  {
    this("dbmaker.sql.JdbcOdbcDriver","jdbc:dbmaker:DBSAMPLE5","SYSADM","");
  }
  
  public void TestInOutParam(int iSid) throws Exception
  {
    Connection cn = null;
    CallableStatement stmt = null;
    
    try
    {
      Class.forName(Driver);
      cn = DriverManager.getConnection(Url, Uid, Pwd);
      stmt = cn.prepareCall("call sqlsp_nest1(?,?)");
      stmt.setInt(1,iSid);
      stmt.registerOutParameter(2,Types.CHAR);
      stmt.execute();
      
      System.out.println("sname = " + stmt.getString(2));
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
    finally
    {
      if (cn != null)
        cn.close();
    }
  }
  
  public void TestResultSet() throws Exception
  {
    Connection cn = null;
    CallableStatement stmt = null;
    ResultSet rs = null;
    ResultSetMetaData rsmd = null;
   
    try
    {
      Class.forName(Driver);
      cn = DriverManager.getConnection(Url, Uid, Pwd);
      stmt = cn.prepareCall("call sqlsp_resultset(?)");
      stmt.setInt(1,2);
      stmt.execute();
      rs = stmt.getResultSet();
      rsmd = rs.getMetaData();
    
      for(int i=1; i<=rsmd.getColumnCount(); i++)
        System.out.print('\t' + rsmd.getColumnName(i));
      System.out.println();
      while(rs.next())
      {
        for(int i=1; i<=rsmd.getColumnCount(); i++)
        {
          Object obj = rs.getObject(i);
          if (rs.wasNull())
            System.out.print("\t" + "NULL");
          else
            System.out.print("\t" + obj);
        }
        System.out.println();
      }
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
    finally
    {
      if (cn != null)
        cn.close();
    }
  }
  
  public static void main(String[] args) throws Exception
  {
    CallSqlSp sp = new CallSqlSp();
    
    sp.TestInOutParam(1);
    sp.TestInOutParam(2);
    
    sp.TestResultSet();
  }
}
