#!/usr/bin/env python
import sys
from string import *
import mx.ODBC.DBMaker
from mx.ODBC.DBMaker import SQL
DB=mx.ODBC.DBMaker

# -----------
# show table
# -----------

dbh=DB.Connect('dbsample5','SYSADM','')
sth=dbh.cursor()

print ''
print "Now, We are connecting to DB 'dbsample5'..."
print ''

def show(query):
   sth.execute(query)
   des=sth.description
   result=sth.fetchall()

# sth.description:
# ( column name , column type , None , None , column length , scale , null? )

# print column name 
# --------------------------------------
   
   col = []
   for i in range(len(des)):
      sz=des[i][4]
      if des[i][1] < 0:                 # long varchar, long varbinary, file
         sz=len(des[i][0])
      if sz < len(des[i][0]):
         sz=len(des[i][0])
      col.append((des[i][0],sz))

   for i in range(len(des)): 
      print '+ %s' % ('-'*col[i][1],),
   print '+'
   
   for i in range(len(des)): 
      buf = center(col[i][0], col[i][1])
      print '| %s' % (buf,),
   print '|'

   for i in range(len(des)): 
      print '+ %s' % ('-'*col[i][1],),
   print '+'
# --------------------------------------


# print result set
# --------------------------------------

   for i in range(len(result)):
      for j in range(len(result[i])):
         buf = ljust(str(result[i][j])[:col[j][1]], col[j][1])
         print '| %s' % (buf,),
      print '|'

   for i in range(len(des)): 
      print '+ %s' % ('-'*col[i][1],),
   print '+\n'
# --------------------------------------

while 1:
   command=raw_input("Type 'go' to enter or 'quit' to exit...")
   if command == 'go':
      sql=raw_input('Please input SQL select statement...')
      show(sql)
   elif command == 'quit':
      print 'bye!!'
      break
   else:
      print 'Command Error, Please input again...'
      print ''
