#!/usr/bin/env python
# ----------------------------------------------------------
# show how to use connection handle method 'datetimeformat'
# ----------------------------------------------------------

import sys
import mx.ODBC.DBMaker
from mx.ODBC.DBMaker import SQL
DB=mx.ODBC.DBMaker
from mx.DateTime import *

table='py_test'
field1='c1 timestamp'

# build a connection handle 'dbh'
dbh=DB.Connect('dbsample5','SYSADM','')

# build a cursor handle 'sth'
sth=dbh.cursor()

# create table for testing
try:
   sth.execute("drop table %s" % table)
except DB.Error, data:
   print "Error message:", data
sth.execute("create table %(table)s (%(field1)s)" %(vars()))

try:
   print "insert data into %s(%s)" % (table, field1)
   print "... insert now()"
   sth.execute("insert into %s values(?)"%table,(now(),))
except DB.Warning:
   pass

print "... insert an integer - 924072246"
sth.execute("insert into %s values(?)"%table,(924072246,))

print "... insert a tuple data - (1980,12,10,9,35,40)"
date=(1980,12,10,9,35,40)
sth.execute("insert into %s values(?)"%table,(date,))

print "... insert a string - '1998/10/1 8:59:30'"
sth.execute("insert into %s values(?)"%table,('1998/10/1 8:59:30.000 PM',))

print "... insert a DateTime object - Timestamp(2000, 1, 1, 0, 0, 0)"
date = Timestamp(2000, 1, 1, 0, 0, 0)
sth.execute("insert into %s values(?)"%table,(date,))

print
print 'Show the result'
sth.execute("select * from %s" % table)
r = sth.fetchall()
for i in range(len(r)):
   if i == 0:
      print '... as a DateTime object'
      print r[i],
   elif i == 1:
      print '... as a string'
      print r[i][0],
   elif i == 2:
      print '... as a tuple'
      print r[i][0].tuple(),
   else:
      if i == 3:
         print '... as a formated string'
      print r[i][0].strftime(),
   if r[i][0].is_leapyear == 1:
      print ' is a leap year'
   else:
      print

print
print 'Timezone: %s' % r[0][0].tz
