#!/usr/bin/env python
import mx.ODBC.DBMaker
from mx.ODBC.DBMaker import SQL
DB=mx.ODBC.DBMaker

# build a connection handle 'dbh'
dbh=DB.Connect('dbsample5','SYSADM','')

# --------------------------------------------------
# show how to use connection handle method 'cursor'
# --------------------------------------------------
print 'Try how many Corsor objects can DBMaker create ...'
i=0
cursors=[]
try:
   while 1:
      cursors.append(dbh.cursor())
      i = i+1
except:
   cnt1 = i
   print '(1) The maximum number of DBMaker cursors is ',i

print 'Free all Cursors created ...'
for j in range(i):
   cursors[j].close()
print

print 'Second round ...'
i=0
cursors=[]
try:
   while 1:
      cursors.append(dbh.cursor())
      i = i+1
except:
   cnt2 = i
   print '(2) The maximum number of DBMaker cursors is ',i

print 'Free all Cursors created ...'
for j in range(i):
   cursors[j].close()
print

if cnt1 != cnt2:
   print 'Not all Cursors createed are released successfully!!'
else:
   print 'All Cursors created can be released successfully.'

print

# ------------------------------------------------------------------------
# show how to use cursor handle method 'getcursorname' & 'setcursorname'
# ------------------------------------------------------------------------

print "Try to get and set Cursor's name ..."

sth=dbh.cursor()

# show the cursorname now
str=sth.getcursorname()
print 'cursorname = ', str

# modify the cursorname
sth.setcursorname('cursor_now')
str=sth.getcursorname()
print 'cursorname after modified = ', str
sth.close()
print

# ------------------------------------------------------------
# show how to use 2 cursor to handle 'update' & 'delete' data
# ------------------------------------------------------------

print "Use 2 cursor to handle 'update' & 'delete' data"
sth1=dbh.cursor()
sthu=dbh.cursor()
sthd=dbh.cursor()
# show the cursorname now
str=sth1.getcursorname()
print 'cursorname = ', str

# create table for test
print 'Create table: py_cursor'
try:
  sth1.execute("drop table py_cursor")
except:
  pass
sth1.execute("create table py_cursor(c1 int, c2 varchar(20))")
print 'Insert data into py_cursor'
for i in range(10):
   rv = sth1.execute("insert into py_cursor values (?,?)", (i, 'test cursor'))
# show data
print 'show data before update & delete'
sth1.execute("select * from py_cursor")
print "c1          c2"
print "== ===================="
while 1:
   buf = sth1.fetchone()
   if not buf:
      break
   print "%2s %20s" % buf

sth1.execute("select * from py_cursor for update")
str=sth1.getcursorname()

# update & delete data
while 1:
   buf = sth1.fetchone()
   if not buf:
      break
   if (buf[0]%2==0):
      sthu.execute("update py_cursor set c2=? where current of %s" % str, ('***'+buf[1]+'***',))
   else:
      sthd.execute("delete from py_cursor where current of %s" % str)

# show data
print 'show data after update & delete'
sth1.execute("select * from py_cursor")
print "c1          c2"
print "== ===================="
while 1:
   buf = sth1.fetchone()
   if not buf:
      break
   print "%2s %20s" % buf
sth1.execute("drop table py_cursor")
