/*****************************************************************
 *  Copyright(C) 1995 - 2007 CASEMaker Inc. All rights reserved.
 *
 *  DbBean - offer the functions called by JSP page request
 *****************************************************************/
package bean;

import java.sql.*;
import java.io.*;
import java.util.*;

public class DbBean 
{
	private String dbURL;
	private String dbDriver = "dbmaker.sql.JdbcOdbcDriver";
	private Connection dbCon;
	private String sUID = "";
	private String sPWD = "";
	
	public DbBean() 
	{
		super();
	}
	
	protected void finalize() throws SQLException
	{
		close();
	}
	
	/***************************************************************
	 *  connect to database
	 ***************************************************************/
	public boolean connect() throws ClassNotFoundException, SQLException
	{
		Class.forName(this.getDbDriver());
		if (sUID == "")
		{
			dbCon = DriverManager.getConnection(this.getDbURL());
		}
		else
		{
			dbCon = DriverManager.getConnection(this.getDbURL(), this.getUID(), this.getPWD());
		}
		
		return true;
	}
	
	/***************************************************************
	 *  close connect to database
	 ***************************************************************/	
	public void close() throws SQLException
	{
		dbCon.close();
	}

	/***************************************************************
	 *  execute query and return a statement object
	 ***************************************************************/	
	public ResultSet execQuery(String sql) throws SQLException
	{
		Statement s = dbCon.createStatement();
		ResultSet r = s.executeQuery(sql);
		return (r == null) ? null:r;
	}

	/***************************************************************
	 *  execute query table
	 ***************************************************************/
	public ResultSet Tables(String catalog, String schema, String pattern, String[] type) throws SQLException
	{
		DatabaseMetaData dbmd = dbCon.getMetaData();
		return dbmd.getTables(catalog, schema, pattern, type);
	}
	
	public String getDbDriver()
	{
		return this.dbDriver;
	}
	
	public void setDbDriver(String value)
	{
		this.dbDriver = value;
	}
	
	public String getDbURL()
	{
		return this.dbURL;
	}
	
	public String getUID()
	{
		return this.sUID;
	}

	public String getPWD()
	{
		return this.sPWD;
	}
	
	public void setDbURL(String value)
	{
		this.dbURL = value;
	}

	public void setUID(String value)
	{
		this.sUID = value;
	}

	public void setPWD(String value)
	{
		this.sPWD = value;
	}

	/***************************************************************
	 *  execute SQL operation
	 ***************************************************************/
	public boolean execute(String sql) throws SQLException
	{
		Statement s = dbCon.createStatement();
		return s.execute(sql);
	}

	/***************************************************************
	 *  execute mutiple SQL operation
	 ***************************************************************/	
	public int executeMutiple(String sql, String delimiter) throws SQLException
	{
		int count = 0;
		StringTokenizer tokens = new StringTokenizer(sql, delimiter);
		Statement s = dbCon.createStatement();
		int [] updateCounts;
		String cmd;
		
		if (tokens.countTokens() == 0)
		{
			count = s.executeUpdate(sql);
		}
		else
		{
			while (tokens.hasMoreTokens())
			{
				cmd = tokens.nextToken();
				System.out.println(cmd);
				count += s.executeUpdate(cmd);
			}
		}
		
		return count;
	}
}
