/*****************************************************************
 *  Copyright(C) 1995 - 2007 CASEMaker Inc. All rights reserved.
 *
 *  ex_Resultset_update - show how to update data
 *
 *  Descriptor - This sample demostrates the usage of updating
 *               data and retrieving data.
 *  Table Name - jdbc_employee
 *  Table Schema - four columns (id int, name char(20), salary float, hired_date date)
 *  Insert data - We will insert 6 tuples into jdbc_employee.
 *                (1, 'Charles Brown', 555.32, '1999/01/01')
 *                (2, 'Bart Simpson', 232555.3332, '1988/01/01')
 *                (3, 'Homer Simpson', 1232555.3332, '1970/01/01')
 *                (4, 'Mickey Mouse', 32322555.3332, '1950/01/01')
 *                (5, 'Donald Duck', 322555.3332, '1960/01/01')
 *                (6, 'Goofy Dog', 44322555.3332, '1983/01/01')
 *  Function =
 *      1. register dbmaker driver
 *      2. connect to database
 *      3. create table jdbc_employee
 *      4. insert data into table jdbc_employee
 *      5. update data
 *      6. select data from table jdbc_employee
 *      7. close statements
 *      8. close connection
 *
 *****************************************************************/
import java.io.*;
import java.sql.*;
import java.util.*;

public class ex_Resultset_update {

    /***************************************************************
    *  main()
    ***************************************************************/
    public static void main(String[] argc)
    {
        Connection con;
        String driver = "dbmaker.sql.JdbcOdbcDriver";
        String url = "jdbc:dbmaker:DBSAMPLE5";
        ResultSet rs = null;
        DatabaseMetaData dbmd = null;
        String database = "DBSAMPLE5";
        String user = "SAMPLEUSER";
        String pattern = "%";
        String[] type = {"TABLE"};
        ResultSetMetaData rsmd = null;
        int cols, i;

        System.out.println("+----------------------------------------------------+\n");
        System.out.println("+-------- ex_Resultset_update JDBC example ----------+\n");
        System.out.println("+----------------------------------------------------+\n");

        try
	    {
        /***************************************************************
         *  register dbmaker driver
         ***************************************************************/
        System.out.println("1. register dbmaker driver \n");

        Class.forName(driver);

        /***************************************************************
         *  connect dbmaker
         ***************************************************************/
        System.out.println("2. connect to database \n");

        con = DriverManager.getConnection(url, user, "");

        /***************************************************************
         *  get a statement object to create table jdbc_employee
         ***************************************************************/
        System.out.println("3. create table jdbc_employee \n");
        Statement stmt = con.createStatement(ResultSet.TYPE_SCROLL_SENSITIVE, ResultSet.CONCUR_UPDATABLE);
        stmt.executeUpdate("create table jdbc_employee (id int, name char(20), salary float, hired_date date)");

        /***************************************************************
         *  insert records
         ***************************************************************/
        System.out.println("4. insert data into table jdbc_employee \n");

        System.out.println("   (1) insert tuple (1, 'Charles Brown', 555.32, '1999/01/01') \n");
        stmt.executeUpdate("insert into jdbc_employee values (1, 'Charles Brown', 555.32, '1999/01/01')");

        System.out.println("   (2) insert tuple (2, 'Bart Simpson', 232555.3332, '1988/01/01') \n");
        stmt.executeUpdate("insert into jdbc_employee values (2, 'Bart Simpson', 232555.3332, '1988/01/01')");

        System.out.println("   (3) insert tuple (3, 'Homer Simpson', 1232555.3332, '1970/01/01') \n");
        stmt.executeUpdate("insert into jdbc_employee values (3, 'Homer Simpson', 1232555.3332, '1970/01/01')");

        System.out.println("   (4) insert tuple (4, 'Mickey Mouse', 32322555.3332, '1950/01/01') \n");
        stmt.executeUpdate("insert into jdbc_employee values (4, 'Mickey Mouse', 32322555.3332, '1950/01/01')");

        System.out.println("   (5) insert tuple (5, 'Donald Duck', 322555.3332, '1960/01/01') \n");
        stmt.executeUpdate("insert into jdbc_employee values (5, 'Donald Duck', 322555.3332, '1960/01/01')");

        System.out.println("   (6) insert tuple (6, 'Goofy Dog', 44322555.3332, '1983/01/01') \n");
        stmt.executeUpdate("insert into jdbc_employee values (6, 'Goofy Dog', 44322555.3332, '1983/01/01')");

        /***************************************************************
         *  update resultset -- raise each employee's salary 1000 dollar
         ***************************************************************/
         rs = stmt.executeQuery("select * from jdbc_employee");

         while(rs.next())
            {
            float salary = rs.getFloat(3);
            salary = salary + 1000.00f;
            rs.updateFloat(3, salary);
            rs.updateRow();
            }

        /***************************************************************
         * retrieve updated resultset
         ***************************************************************/
         System.out.println("6. show updated result \n");

         rs.first();

         //show updated resultset
         rsmd = rs.getMetaData();
         cols = rsmd.getColumnCount();

         //get column name
         for (i = 1;i <= cols;++i)
            {
                System.out.print(rsmd.getColumnName(i) + '\t');
            }

         System.out.println();

	       //get a tuple
         while(rs.next())
            {
                //get a column in a tuple
                for(i = 1;i <= cols;++i)
                {
                    switch (i)
                    {
                        case 1:
                            System.out.print(String.valueOf(rs.getInt(i)) + '\t');
                            break;
                        case 2:
                            System.out.print(rs.getString(i) + '\t');
                            break;
                        case 3:
                            System.out.print(String.valueOf(rs.getFloat(i)) + '\t');
                            break;
                        case 4:
                            System.out.print(String.valueOf(rs.getDate(i)) + '\t');
                            break;
                        default:
                            System.out.print("warning: wrong column number" + '\t');
                            break;
                    }
                }

            System.out.println();
            }

	       System.out.println();
  	 rs.close();

         /***************************************************************
          *  drop table ,close statement and connection
          ***************************************************************/
         System.out.println("7. drop table jdbc_employee \n");

         stmt.executeUpdate("drop table jdbc_employee");

         System.out.println("8. close statement \n");
         stmt.close();

         System.out.println("9. close connection \n");
         con.close();
        }
        catch (Exception ex){
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }

      /***************************************************************
       *  print program end title
       ***************************************************************/
      System.out.println("+----------------------------------------------------+\n");
      System.out.println("+---------- END of ex_Resultset_update --------------+\n");
      System.out.println("+----------------------------------------------------+\n");


    }//end of main
}//end of class
