/****************************************************************************
 *  Copyright(C) 1997 - 2007 CaseMaker Inc. All rights reserved.
 *
 *	04dynamic.ec:
 *      This sample is mainly concerned of dynamic ESQL. Including
 *      1. type 1 : insert, update, delete
 *      2. type 2 : insert, update, delete
 *      3. type 3 : select
 *      4. type 4 : select  *
 *
 *	Referenced Table:
 *		sample.Card(id integer,fname varchar(30),lname varchar(30)
 *				title varchar(30), photo long varbinary)
 *
 ****************************************************************************/
/* 04dynamic.ec
 * This sample program is mainly concerned of dynamic ESQL
 * including :
 *    1. type 1 : insert, update, delete
 *    2. type 2 : insert, update, delete
 *    3. type 3 : select
 *    4. type 4 : select 
 */

EXEC SQL include sqlca;
EXEC SQL include dbenvca;
EXEC SQL include sqlda;
#define STRING_LEN 128

#define chkErr() \
        { \
        if (SQLCODE && SQLCODE != SQL_NO_DATA_FOUND) \
           { \
           if (SQLCODE == SQL_SUCCESS_WITH_INFO) \
              printf("WARN(%d):%s\n", sqlca.sqlerrd[0], sqlca.sqlerrmc); \
           else \
              { \
              printf("ERR(%d):%s\n", sqlca.sqlerrd[0], sqlca.sqlerrmc); \
              } \
           } \
        }

void ViewCardTable();
void demo_type1_dynamic_esql_insert();
void demo_type1_dynamic_esql_update();
void demo_type1_dynamic_esql_delete();
void demo_type2_dynamic_esql_insert();
void demo_type2_dynamic_esql_update();
void demo_type2_dynamic_esql_delete();
void demo_type3_dynamic_esql();
void demo_type4_dynamic_esql();

int main()
{
   EXEC SQL begin declare section;
   char user[8], passwd[8];           /* connection information         */
   char dbname[18];                   /* char type is fix length string */
   EXEC SQL end declare section;

   strcpy(dbname, "DBSAMPLE5");          /* get db,user,password info */
   strcpy(user, "SYSADM");
   strcpy(passwd, "");
 
   /* you can also directly type EXEC SQL connect to db_name user_id passwd */
   EXEC SQL connect to :dbname :user :passwd;

   ViewCardTable();

   printf("<<< demo_type1_dynamic_esql_insert >>>\n");
   demo_type1_dynamic_esql_insert();
   ViewCardTable();

   printf("<<< demo_type1_dynamic_esql_update >>>\n");
   demo_type1_dynamic_esql_update();
   ViewCardTable();

   printf("<<< demo_type1_dynamic_esql_delete >>>\n");
   demo_type1_dynamic_esql_delete();
   ViewCardTable();

   printf("<<< demo_type2_dynamic_esql_insert >>>\n");
   demo_type2_dynamic_esql_insert();
   ViewCardTable();

   printf("<<< demo_type2_dynamic_esql_update >>>\n");
   demo_type2_dynamic_esql_update();
   ViewCardTable();

   printf("<<< demo_type2_dynamic_esql_delete >>>\n");
   demo_type2_dynamic_esql_delete();
   ViewCardTable();

   printf("<<< demo_type3_dynamic_esql >>>\n");
   demo_type3_dynamic_esql();

   printf("<<< demo_type4_dynamic_esql >>>\n");
   demo_type4_dynamic_esql();

   EXEC SQL disconnect;
   if (SQLCODE)
      printf("ERR(%d):%s\n", sqlca.sqlerrd[0], sqlca.sqlerrmc);    
   return 0;
}

void ViewCardTable()
{
   EXEC SQL begin declare section;
      int ID;
      char LName[30+1];
      char FName[30+1];
   EXEC SQL end declare section;

   EXEC SQL declare card_cursor cursor for 
            select ID, LName, FName from sample.Card into :ID, :LName, :FName;

   chkErr();
   EXEC SQL open card_cursor;
   chkErr();
   printf("ID   LName                       FName\n");
   printf("===== ============================== ==============================\n");
   while (1)
   {
     EXEC SQL fetch card_cursor;
     if (sqlca.sqlcode == SQL_SUCCESS || 
         sqlca.sqlcode == SQL_SUCCESS_WITH_INFO)
	printf("%5d %-30s %-30s\n", ID, LName, FName);
     else
        break;
   };
   printf("\n");
   EXEC SQL close card_cursor;
   chkErr();
}

/* Type 1 dynamic ESQL is a non-SELECT statement without input host variables.
 * Method: Execute Immediate
 */
void demo_type1_dynamic_esql_insert()
{
   EXEC SQL begin declare section;
      varchar stmt_str[128];
   EXEC SQL end declare section;

   sprintf(stmt_str.arr, "INSERT INTO sample.Card (ID, LName, FName) \
                          VALUES (100, '007', 'James')");
   stmt_str.len = strlen(stmt_str.arr);
   EXEC SQL execute immediate from :stmt_str;
   EXEC SQL commit work;
}

void demo_type1_dynamic_esql_update()
{
   EXEC SQL begin declare section;
      varchar stmt_str[128];
   EXEC SQL end declare section;

   sprintf(stmt_str.arr, "UPDATE sample.Card SET LName='*007' \
                          WHERE FName = 'James'");
   stmt_str.len = strlen(stmt_str.arr);
   EXEC SQL execute immediate from :stmt_str;
   EXEC SQL commit work;  
}

void demo_type1_dynamic_esql_delete()
{
   EXEC SQL begin declare section;
      varchar stmt_str[128];
   EXEC SQL end declare section;

   sprintf(stmt_str.arr, "DELETE FROM sample.Card WHERE ID = 100");
   stmt_str.len = strlen(stmt_str.arr);
   EXEC SQL execute immediate from :stmt_str;
   EXEC SQL commit work;   
}

/* Type 2 dynamic ESQL is a non SELECT statement with a known IDber of 
 * input host variables
 * Method: Prepare/Execute
 */
void demo_type2_dynamic_esql_insert()
{
   /* Declare all input variables in the declare section. */
   EXEC SQL begin declare section;
      varchar stmt_str[128];
      int ID;
      char LName[30+1];
      char FName[30+1];
      SQLLEN indvalue = SQL_NTS;
   EXEC SQL end declare section;

   sprintf(stmt_str.arr, "INSERT INTO sample.Card (ID, LName, FName) \
                         VALUES (:iVoid, :sVoid1 :indvalue, :sVoid2 :indvalue)");
   /* Prepare statement */ 
   EXEC SQL prepare stmt from :stmt_str;
   chkErr();
   /* Set value of all input host and indicate variables */
   ID=100;
   strcpy(LName, "007");
   strcpy(FName, "James");
   /* Execute this statement */
   EXEC SQL execute stmt using :ID, :LName :indvalue, :FName :indvalue;
   chkErr();
   EXEC SQL commit work;
   chkErr();
}

void demo_type2_dynamic_esql_update()
{
   EXEC SQL begin declare section;
      varchar stmt_str[128];
      int ID;
      char LName[30+1];
      char FName[30+1];
      SQLLEN indvalue = SQL_NTS;
   EXEC SQL end declare section;

   sprintf(stmt_str.arr, "UPDATE sample.Card SET LName = :sVoid1 \
                          WHERE FName = :sVoid2");
   EXEC SQL prepare stmt from :stmt_str;
   chkErr();
   strcpy(LName, "*007");
   strcpy(FName, "James");
   EXEC SQL execute stmt using :LName :indvalue, :FName :indvalue;
   chkErr();
   EXEC SQL commit work;
   chkErr();
}

void demo_type2_dynamic_esql_delete()
{
   EXEC SQL begin declare section;
      varchar stmt_str[128];
      int ID;
      char LName[30+1];
      char FName[30+1];
      SQLLEN indvalue = SQL_NTS;
   EXEC SQL end declare section;

   sprintf(stmt_str.arr, "DELETE From sample.Card WHERE ID = :iVoid");
   EXEC SQL prepare stmt from :stmt_str;
   chkErr();
   ID = 100;
   EXEC SQL execute stmt using :ID;
   chkErr();
   EXEC SQL commit work;
   chkErr();
}

/* Type 3 dynamic ESQL is a SELECT statement with a known IDber of input 
 * and ouput host variables.
 * Method: Cursor
 */
void demo_type3_dynamic_esql()
{
   EXEC SQL begin declare section;
      varchar stmt_str[128];
      int ID;
      char LName[30+1];
      char FName[30+1];
      char Title[30+1];
      SQLLEN indvalue = SQL_NTS;
   EXEC SQL end declare section;

   /* Put a build statement string inside a host variable, including one
      place holder (or '?') for each input variable. */
   sprintf(stmt_str.arr, "SELECT ID, LName, FName FROM sample.Card \
            WHERE Title = :sVoid ");
   stmt_str.len = strlen(stmt_str.arr);

   /* Execute an ESQL PREPARE statement specifying the statement name and 
      statement string. */
   EXEC SQL prepare stmt from :stmt_str;
   chkErr();

   /* Execute the ESQL DECLARE CURSOR statement specifying the cursor name 
      and the statement name */

   EXEC SQL declare card_cursor cursor for stmt;
   chkErr();

   /* specify a value for each input variable. */
   strcpy(Title, "Software Engineer");

   /* Open the cursor with a list of input variables. */
   EXEC SQL open card_cursor using :Title :indvalue;
   chkErr();

   printf("ID   LName                       FName\n");
   printf("===== ============================== ==============================\n");
   while (1)
   {
     /* In a loop, fetch the result to a list of output variables. */    
     EXEC SQL fetch card_cursor into :ID, :LName, :FName;
     chkErr();
     if (sqlca.sqlcode == SQL_SUCCESS || 
         sqlca.sqlcode == SQL_SUCCESS_WITH_INFO)
	printf("%5d %-30s %-30s\n", ID, LName, FName);
     else
        break;
   };
   printf("\n");
   /* Close the cursor. */
   EXEC SQL close card_cursor;
}

/* Type 4 dynamic ESQL is unknown IDber of input or output host variables
 * Method: SQLDA
 */
void demo_type4_dynamic_esql()
{
   EXEC SQL begin declare section;
      varchar stmt_str[128];
   EXEC SQL end declare section;

   /* Declare descriptor variables*/
   char *input_descriptor, *select_descriptor;
   long maxIDber = 10;
   long nHv=0, nCol=0;
   char *pColName, *pData;
   long *pLongData;
   long colType = 0, colScale = 0, colNullable = 0;
   long colLen = 0, colNameLen = 0, dataType = 0;
   SQLLEN colPrec = 0, datalen = 0;
   short i;
   char buf[STRING_LEN];

   /* Allocate SQLDA for dynamic input/output host variables by max IDber */
   allocate_descriptor_storage(maxIDber, &input_descriptor);
   chkErr();
   allocate_descriptor_storage(maxIDber, &select_descriptor);
   chkErr();

   /* Execute a SQL PREPARE statement specifying the statement name and 
      statement string */
   sprintf(stmt_str.arr, "SELECT ID, LName, FName FROM sample.Card \
            WHERE Title = :sVoid");  
   stmt_str.len = strlen(stmt_str.arr);
   EXEC SQL prepare stmt from :stmt_str;

   /* Declare a cursor for the statememt */
   EXEC SQL declare demo_cursor cursor for stmt;

   /* Bind the descriptor variables used in the statement */
   EXEC SQL describe bind variables for stmt into input_descriptor;
   GetSQLDA(input_descriptor, 0, SQLDA_NUM_OF_HV, &nHv);
   printf("There are %d returned input host variables:\n \n", nHv);

   /* Set the length of input host variables. */
   /* Set the data type of input host variables. */
   /* Allocate storage for the value of input host variables. */
   /* Set the value of input host variables. */
   /* Set the value of indicated variables */
   for (i=1; i<=nHv; i++)
   {
      GetSQLDA(input_descriptor, i, SQLDA_COLTYPE, &colType);
      GetSQLDA(input_descriptor, i, SQLDA_COLLEN, &colLen);
      switch(colType)
      {
      case SQL_VARCHAR:
      case SQL_CHAR:
           pData = (char*) malloc(colLen+1);
           SetSQLDA(input_descriptor, i, SQLDA_DATABUF, pData);
           SetSQLDA(input_descriptor, i, SQLDA_DATABUF_LEN,colLen+1);
              /* +1 for null terminate */
           SetSQLDA(input_descriptor, i, SQLDA_DATABUF_TYPE, SQL_C_CHAR);
           strcpy(pData, "Software Engineer");
           datalen = strlen(pData);
           SetSQLDA(input_descriptor, i, SQLDA_INDICATOR, datalen);
           break;
      case SQL_INTEGER:
           pLongData = (long*) malloc(4);
           SetSQLDA(input_descriptor, i, SQLDA_DATABUF, pLongData);
           SetSQLDA(input_descriptor, i, SQLDA_DATABUF_LEN, 4);
           SetSQLDA(input_descriptor, i, SQLDA_DATABUF_TYPE, SQL_C_LONG);
           printf( "Input a integer as 3: " );   
           scanf( "%s", buf );           
           *pLongData=atol(buf);
           break;
      }	
   }

   /* Open the cursor and specify the descriptor variables the cursor should use */
   EXEC SQL open demo_cursor using descriptor input_descriptor;
   chkErr();

   /* Describe output host variables */
   EXEC SQL describe select list for stmt into select_descriptor;
   chkErr();
   GetSQLDA(select_descriptor, 0, SQLDA_NUM_OF_HV, &nCol);
   printf("There are %d returned columns: \n \n", nCol);
   for (i=1; i <= nCol; i++)
   {
     printf("column %d : \n", i);
     GetSQLDA(select_descriptor, i, SQLDA_COLNAME_LEN, &colNameLen);
     GetSQLDA(select_descriptor, i, SQLDA_COLNAME, &pColName);
     GetSQLDA(select_descriptor, i, SQLDA_COLTYPE, &colType);
     GetSQLDA(select_descriptor, i, SQLDA_COLLEN, &colLen);
     GetSQLDA(select_descriptor, i, SQLDA_COLPREC, &colPrec);
     GetSQLDA(select_descriptor, i, SQLDA_COLSCALE, &colScale);
     GetSQLDA(select_descriptor, i, SQLDA_COLNULLABLE, &colNullable);
     printf(" column name length = %ld \n", colNameLen);
     printf(" column name = %s \n", pColName);
     printf(" column type = %ld \n", colType);
     printf(" column length = %ld \n", colLen);
     printf(" column precision = %ld \n", colPrec);
     printf(" column scale = %ld \n", colScale);
     printf(" column nullable = %ld \n", colNullable);
   }

   /* Set the length of the output host variables. */
   /* Set the data type of output host variables. */
   /* Allocate storage for the value of output host variables. */
   for (i= 1; i <= nCol; i++)
   {
     GetSQLDA(select_descriptor, i, SQLDA_COLTYPE, &colType);
     GetSQLDA(select_descriptor, i, SQLDA_COLLEN, &colLen);
     switch(colType)
     {
     case SQL_VARCHAR:
     case SQL_CHAR: 
          pData = (char*) malloc(colLen+1);
          SetSQLDA(select_descriptor, i, SQLDA_DATABUF, pData);
          SetSQLDA(select_descriptor, i, SQLDA_DATABUF_LEN,colLen+1);
              /* +1 for null terminate */
          SetSQLDA(select_descriptor, i, SQLDA_DATABUF_TYPE, SQL_C_CHAR);
          break;
     case SQL_INTEGER:
          pData = (char*) malloc(4);
          SetSQLDA(select_descriptor, i, SQLDA_DATABUF, pData);
          SetSQLDA(select_descriptor, i, SQLDA_DATABUF_LEN, 4);
          SetSQLDA(select_descriptor, i, SQLDA_DATABUF_TYPE, SQL_C_LONG);
          break;
     }
   }

   printf("ID   LName                       FName\n");
   printf("===== ============================== ==============================\n");
   /* Fetch data. */
   do {
     EXEC SQL fetch demo_cursor using select_descriptor;
     chkErr();
     if(sqlca.sqlcode!=SQL_SUCCESS && sqlca.sqlcode!=SQL_SUCCESS_WITH_INFO)
       break;
     for(i = 1; i <= nCol; i++)
     {
       GetSQLDA(select_descriptor, i, SQLDA_DATABUF, &pData);
       GetSQLDA(select_descriptor, i, SQLDA_DATABUF_TYPE, &dataType);
       switch (dataType)
       {
       case SQL_C_CHAR:
         printf(" %-30s", pData);
         break;
       case SQL_C_LONG:
         printf("%5ld", *pData);
         break;
       }
     }
     printf("\n");
   } while (sqlca.sqlcode==SQL_SUCCESS|| sqlca.sqlcode==SQL_SUCCESS_WITH_INFO);

   /* Close the cursor. */    
   EXEC SQL close demo_cursor;
   chkErr();

   /* Free allocated buffer of SQLDA */
   for (i = 1; i <= nHv; i++)
   {
      GetSQLDA(input_descriptor, i, SQLDA_DATABUF, &pData);
      free(pData);
   }
   for (i = 1; i <= nCol; i++)
   {
      GetSQLDA(select_descriptor, i, SQLDA_DATABUF, &pData);
      free(pData);
   }

   /* De-allocatefree descriptor */
   free_descriptor_storage(input_descriptor);
   free_descriptor_storage(select_descriptor);
}

