<!-----------------------------------------------------------------------
	Copyright(c) 1997 - 2007 CaseMaker Inc. All rights reserved
-------------------------------------------------------------------------
NOTE:
1. This sample insert text(is from page) into CLOB, BLOB, NCLOB, FILE fields
2. Use following methods insert text into database:
	a. Use System.Text.Encoding.Default.GetBytes method to encode text to
	   byte array,then insert byte stream into CLOB, BLOB, FILE fields
	   via OleDbType.LongVarBinary OleDbParameter object.
	b. Insert text into database via OleDbType.LongVarChar,
	   OleDbType.LongVarWChar OleDbParameter object respectively.
	c. Use pure SQL Insert text into database without OleDbParameter object.
3. This sample mixed server scripts and HTML elements in single page file.
4. This sample used database DBSAMPLE5 and table sample.LargeType.

------------------------------------------------------------------------->
<%@ Page Language="C#" AutoEventWireup="True"  validateRequest=false %>
<%@ Import namespace=System.Data.OleDb %>

<html>
<head>
	<title></title>
	<script language="C#" runat="server">
	
		string connString = System.Configuration.ConfigurationSettings.AppSettings["OleDbConnectionString"];
		
		private void Page_Load(object sender,EventArgs e)
		{
			if(!IsPostBack)
			{
				FillCurrentData();
				
				lstField.Items.Add(new ListItem("c1_clob","c1_clob"));
				lstField.Items.Add(new ListItem("c2_blob","c2_blob"));
				lstField.Items.Add(new ListItem("c3_nclob","c3_nclob"));
				lstField.Items.Add(new ListItem("c4_file","c4_file"));
			}
		}
		
		private void FillCurrentData()
		{
			OleDbConnection myCN = new OleDbConnection(connString);
			string queryString = "select c0_id,bloblen(c1_clob),bloblen(c2_blob)," + 
								"bloblen(c3_nclob),filelen(c4_file) from sample.LargeType";
			OleDbCommand myCM = new OleDbCommand(queryString,myCN);
			OleDbDataReader myDR;
			
			try
			{
				myCN.Open();
				myDR = myCM.ExecuteReader();
				grdCurData.DataSource = myDR;
				grdCurData.DataBind();
				myDR.Close();
				myCN.Close();
			}
			catch(Exception ex)
			{
				lblMessage.Text += "<br>Read Current Data Error: " + ex.Message;
				if( myCN != null) myCN.Close();
			}		
		}
		
		void InsertBytes(System.Text.Encoding encoding)
		{
			byte[] buff = encoding.GetBytes(txtData.Text);
			
			string cmdString = "Insert into sample.LargeType(c0_id," + lstField.SelectedValue.Trim() +
									" ) values(?,?);";
			OleDbConnection myCN = new OleDbConnection(connString);
			OleDbCommand myCM = new OleDbCommand(cmdString,myCN);
			
			lblInfo.Text = "Command String: " + myCM.CommandText;
			
			try
			{
				if(txtID.Text.Trim()=="")
				{
					myCM.Parameters.Add("@c0_id",OleDbType.Integer).Value =DBNull.Value;
				}
				else
				{
					myCM.Parameters.Add("@c0_id",OleDbType.Integer).Value =Convert.ToInt32(txtID.Text);
				}
				//myCM.Parameters.Add("@para",OleDbType.LongVarBinary,buff.Length).Value = buff;
				myCM.Parameters.Add("@para",OleDbType.LongVarBinary,2147483647).Value = buff;
				
				myCN.Open();
				int inserted = myCM.ExecuteNonQuery();
				lblMessage.Text += "<br>" + inserted + " row inserted";
				myCN.Close();
				
				
			}catch(Exception ex){
				lblMessage.Text += "<br>Insert Error: " + ex.Message;
				if(myCN != null) myCN.Close();
			}
		
		}
		
		void btnSaveLongVarBinary_Click(object sender,EventArgs e)
		{
			if(txtData.Text.Length <= 0)
			{
				lblMessage.Text += "<br> Text is null";
				return;
			}
			
			InsertBytes(System.Text.Encoding.Default);
			
			FillCurrentData();
		}
		
		
		void InsertString(OleDbType paramOleDbType)
		{
			string cmdString = "Insert into sample.LargeType(c0_id," + lstField.SelectedValue.Trim() +
									" ) values(?,?);";
			OleDbConnection myCN = new OleDbConnection(connString);
			OleDbCommand myCM = new OleDbCommand(cmdString,myCN);

			lblInfo.Text = "Command String: " + myCM.CommandText;
			
			try
			{
				if(txtID.Text.Trim()=="")
				{
					myCM.Parameters.Add("@c0_id",OleDbType.Integer).Value =DBNull.Value;
				}
				else
				{
					myCM.Parameters.Add("@c0_id",OleDbType.Integer).Value =Convert.ToInt32(txtID.Text);
				}
				//myCM.Parameters.Add("@para",paramOleDbType,2147483647).Value = txtData.Text;
				myCM.Parameters.Add("@para",paramOleDbType,txtData.Text.Length).Value = txtData.Text;
				
				myCN.Open();
				int inserted = myCM.ExecuteNonQuery();
				lblMessage.Text += "<br>" + inserted + " row inserted";
				myCN.Close();
				
			}catch(Exception ex){
				lblMessage.Text += "<br>Insert Error: " + ex.Message;
				if(myCN != null) myCN.Close();
			}
		}
		
			
		void btnSaveLongVarChar_Click(object sender,EventArgs e)
		{
			if(txtData.Text.Length <= 0)
			{
				lblMessage.Text += "<br> Text is null";
				return;
			}
			
			InsertString(OleDbType.LongVarChar);
			
			FillCurrentData();
		}
		
		void btnSaveLongVarWChar_Click(object sender,EventArgs e)
		{
			if(txtData.Text.Length <= 0)
			{
				lblMessage.Text += "<br> Text is null";
				return;
			}
			
			InsertString(OleDbType.LongVarWChar);
			
			FillCurrentData();
		}

		void btnSaveString_Click(object sender,EventArgs e)
		{
			if(txtData.Text.Length <= 0)
			{
				lblMessage.Text += "<br> Text is null";
				return;
			}
			
			string cmdString = "Insert into sample.LargeType(c0_id," + lstField.SelectedValue.Trim() +
									" ) values(";
			OleDbConnection myCN = new OleDbConnection(connString);
			OleDbCommand myCM = new OleDbCommand(cmdString,myCN);
			
			try
			{
				if(txtID.Text.Trim()=="")
				{
					myCM.CommandText += "null";
				}
				else
				{
					myCM.CommandText += Convert.ToInt32(txtID.Text);
				}
				myCM.CommandText += ",'" + txtData.Text + "')";
				lblInfo.Text = "Command String: " + myCM.CommandText;
				myCN.Open();
				int inserted = myCM.ExecuteNonQuery();
				lblMessage.Text += "<br>" + inserted + " row inserted";
				myCN.Close();
				
			}catch(Exception ex){
				lblMessage.Text += "<br>Insert Error: " + ex.Message;
				if(myCN != null) myCN.Close();
			}
			
			FillCurrentData();
		}	
				
	</script>
</head>
<body>
	<form method="post" runat="server" >
		<h3>Insert text into CLOB,BLOB,NCLOB,FILE fileds<br>
		[OleDbCommand,OleDbParameter]</h3><hr>
		Database Name: DBSAMPLE5<br>
		Table Name: sample.LargeType<br>
		Current Data:<br>
		<asp:DataGrid id = "grdCurData" runat = "server" />
		<hr><p>
		Row ID:
		<asp:TextBox id="txtID" runat="server" width=30px EnableViewState="false"></asp:TextBox>
		&nbsp;
		Field:
		<asp:DropDownList id="lstField" runat="server" width="80px"></asp:DropDownList>
		<p>
		<asp:TextBox id="txtData" runat="server" width="100%" height="300px" TextMode="MultiLine"/><p>
		
		<asp:Button id="btnSaveLongVarBinary" runat="server" 
			Text="Insert(OleDbType.LongVarBinary)" OnClick="btnSaveLongVarBinary_Click"
			Width="220px">
		</asp:Button>

		<asp:Button id="btnSaveLongVarChar" runat="server" Text="Insert (OleDbType.LongVarChar)" 
			OnClick="btnSaveLongVarChar_Click"
			Width="220px">
		</asp:Button>
		
		<asp:Button id="btnSaveLongVarWChar" runat="server" Text="Insert (OleDbType.LongVarWChar)" 
			OnClick="btnSaveLongVarWChar_Click"
			Width="220px">
		</asp:Button>
		
		<asp:Button id="btnSaveString" runat="server" Text="Insert(pure SQL)" 
			OnClick="btnSaveString_Click"
			Width="220px">
		</asp:Button>				
		<br>
		<asp:Label id="lblMessage" runat="server" EnableViewState=false/>
		<br>
		<asp:Label id="lblInfo" runat="server" EnableViewState="false"/>
	</form>
</body>
</html>