#!/bin/sh
#
# The startup and shutdown script for DBMaker database
#

app_name=dbmaker
app_home=`awk -F: '$1~/^'${app_name}'$/ {print $6}' /etc/passwd`
app_conf=/etc/dminit.conf

hpux_start() {
  awk -F: '$1!~/^#/ {print $1,$2,$3 }' ${app_conf} |
  while read app_db arg2 app_owner; do
    [ -n "${app_db}" -a -n "${arg2}" -a -n "${app_owner}" ] || continue
    app_cmd="${app_home}/${arg2}/bin/dmserver"
    [ "`echo ${arg2} | cut -c1`" = "/" ] && app_cmd="${arg2}"
    su ${app_owner} -c "${app_cmd} ${app_db} 2>&1 >/dev/null" && \
      printf "${app_db} " || printf "${app_db} FAILED "
  done
}

hpux_stop() {
  awk -F: '$1!~/^#/ {print $1,$2,$3 }' ${app_conf} |
  while read app_db arg2 app_owner; do
    [ -n "${app_db}" -a -n "${arg2}" -a -n "${app_owner}" ] || continue
    app_cmd="${app_home}/${arg2}/bin/dmserver"
    [ "`echo ${arg2} | cut -c1`" = "/" ] && app_cmd="${arg2}"
    ${app_cmd} -k ${app_db} 2>&1 >/dev/null && \
      printf "${app_db} " || printf "${app_db}:FAILED "
  done
}

rcHPUX() {
  SUCCESS=0
  FAILURE=1
  WARNING=2

  if [ -f /etc/rc.config.d/dminit.rc ]; then
    . /etc/rc.config.d/dminit.rc
  else
    echo "ERROR: Config file /etc/rc.config.d/dminit.rc missing."
    exit $FAILURE
  fi

  rval=$SUCCESS

  case "$1" in
    start_msg)
      echo "Starting DBMaker service"
      ;;
    stop_msg)
      echo "Stopping DBMaker service"
      ;;
    start)
      if [ "DBMAKER_START" -eq 1 ]; then
        hpux_start
      else
        rval=$WARNING
      fi
      ;;
    stop)
      if [ "DBMAKER_START" -eq 1 ]; then
        hpux_stop
      else
        rval=$WARNING
      fi
      ;;
    *)
      echo "Usage: `basename $0` {start|stop|start_msg|stop_msg}"
      rval=$FAILURE
      ;;
  esac

  exit $rval
}

rcHPUX "$1"

