################################################################################
# Copyright(c) 1998-2010 SYSCOM
# All rights reserved.
################################################################################
# 1. Sample purpose:
#    (1) Demonstrate EXECUTE IMMEDIATE statement.
#    (2) Demonstrate PREPARE statement.
#    (3) Demonstrate EXECUTE statement.
#    (4) Demonstrate DEALLOCATE PREPARE statement.
# 2. To create the SQL Stored Procedure
#    (1) Run the script "createtable.sql" to create the schema objects which be 
#        used in this Procedure in advance. For more information, please see
#        the file "createtable.sql".
#    (2) Use DMSQL tool to create the SQL SP, SQL command like:
#        connect to "DBSAMPLE5" "SYSADM" "";
#        // for Windows:
#        create procedure from '@APP_HOME@\samples\SQLSP\dynamic1.sp';
#        // for Linux:
#        create procedure from '/APP_HOME/samples/SQLSP/dynamic1.sp';
#    (3) use JDBATool to create the SQL SP:
#        connect to the database.
#        create-procedure-wizard => select language SQL => import dynamic1.sp 
#        => finish.
# 3. To call the SQL Stored Procedure
#    (1) use DMSQL tool
#        CALL SQLSP_INSERT(?);
#
# For more information, see the README file in the same directory.
################################################################################

CREATE PROCEDURE SQLSP_INSERT(OUT oInserted INT)
LANGUAGE SQL
BEGIN
  DECLARE sqlStr VARCHAR(1024);
  DECLARE i INT DEFAULT 0;
  
  # execute immediate, no input parameter, no return value
  SET sqlStr = 'DELETE FROM SQLSP_T1';
  EXECUTE IMMEDIATE sqlStr;
  
  # prepate, execute, no input parameter, no return value
  SET sqlStr = 'INSERT INTO SQLSP_T1 VALUES(0)';
  PREPARE stmt1 FROM sqlStr;
  EXECUTE stmt1;
  DEALLOCATE PREPARE stmt1;
  
  # prepare, execute, has input parameter, no return value
  SET sqlStr = 'INSERT INTO SQLSP_T1 VALUES(?)';
  PREPARE stmt1 FROM sqlStr;
  WHILE i < 100 DO # insert 1 ~ 100
    SET i = i + 1;
    EXECUTE stmt1 USING i;
  END WHILE;
  DEALLOCATE PREPARE stmt1;
  
  # prepare, execute, has input parameter, has return value
  SET sqlStr = 'SELECT COUNT(*) FROM SQLSP_T1 WHERE c1 >= ?';
  PREPARE stmt1 FROM sqlStr;
  SET i = 0;
  EXECUTE stmt1 INTO oInserted USING i;
  DEALLOCATE PREPARE stmt1;
END;
