#!/usr/bin/perl

use strict;
use DBI;
 
if (not defined $ARGV[0]) {
   print "Usage: storefile.pl input_file_name\n";
   exit;
}

my $InFile = $ARGV[0];
my $DB   = "DBSAMPLE5";
my $USER = "SYSADM";
my $PASS = "";

# Connect to database DBSAMPLE5
my $dbh = DBI->connect( "dbi:DBMaker:$DB", $USER, $PASS)
          ||die "Database connection not made:$DBI::errstr";

# turn off print error for create table
$dbh->{PrintError} = 0;

# create a table with 3 column filename and file's data
# To differ the usage of BLOB input via file name (one without quote, one with single quote)
# two columns are both declared as long varchar type
$dbh->do("create table pl_filetab (fname varchar(20), data1 long varchar, data2 long varchar)");

# turn on print error
$dbh->{PrintError} = 1;

# Add single quote for the input file name
my $qInFile = "'".$InFile."'";

# Display input value
print "Input File name : $InFile, $qInFile\n";

# Insert file name and file's content into pl_filetab table
my $sql=qq{INSERT INTO pl_filetab values(?,?,?)};
my $sth = $dbh->prepare($sql);
$sth->bind_param(1, $InFile);
$sth->bind_param(2, $InFile);
$sth->bind_param(3, $qInFile);
$sth->execute();

$dbh->disconnect();


