/**************************************************************************
 *
 *  Copyright(C) 1995 - 2007 CaseMaker Inc. All rights reserved.
 *
 *      Module Name      = ex1.c
 *      Goal: An ODBC Example program to connect to database and fetch data
 *
 *      Function =
 *
 *          1. connect to database
 *          2. define a permanent table odbc_tb1
 *          3. insert tuples into table odbc_tb1
 *          4. define a permanent table odbc_tb2
 *          5. insert tuples into table odbc_tb2 using paramters 
 *          6. execute a select command on odbc_tb1
 *          7. fetch all tuples from table odbc_tb1
 *          8. execute a select command on odbc_tb2
 *          9. fetch all tuples from table odbc_tb2
 *         10. drop tables odbc_tb1 and odbc_tb2
 *         11. end transaction 
 *         12. terminate db
 *
 ************************************************************************/
#include "ex.h"

void main()
{
   HDBC    hdbc;  
   HSTMT   cmdp1;
   HENV    henv;
   SQLLEN  rc=0, cbInt = 0,cbChar = SQL_NTS;

   UCHAR   str1[200];
   SWORD   bc1, bc2;
   SDWORD  bc3;
   UCHAR   bc4[11];
   SQLLEN  szbc1,szbc2,szbc3,szbc4;
   SDWORD  par1;
   UCHAR   par2[11];
   int     i,j;

   printf("+----------------------------------------------------------+\n");
   printf("+--------------  Ex1. ODBC example program  ---------------+\n");
   printf("+----------------------------------------------------------+\n");

   rc = SQLAllocEnv(&henv);
   if (rc) printf("allocate envrionment handle fail !! \n");
   rc = SQLAllocConnect(henv,&hdbc);
   if (rc) printf("allocate connection handle fail !! \n");

   /*============  start database  =======================================*/
   printf("  1. connect to the database \n");
   rc = SQLConnect(hdbc,(UCHAR *)DSN,SQL_NTS,(UCHAR *)UID,SQL_NTS,
				   (UCHAR *)PWD,SQL_NTS);
   checkrc(RTN_OK, NULL, hdbc, NULL);

   /*============    set autocommit off   ================================*/
   rc = SQLSetConnectOption(hdbc, SQL_AUTOCOMMIT, SQL_AUTOCOMMIT_OFF);
   checkrc(RTN_OK,NULL,hdbc,NULL);

   /*============    allocate a statement handle   =======================*/  
   rc = SQLAllocStmt(hdbc,&cmdp1);
   checkrc(RTN_OK,NULL,hdbc,NULL);

    /*============  define a permanent table odbc_tb1  =========================*/
   printf("  2. define a permanent table odbc_tb1\n");
   strcpy((char *)str1,"create table odbc_tb1(c1 smallint,\
                                         c2 smallint)");  
   rc = SQLExecDirect(cmdp1,str1,SQL_NTS);
   checkrc(RTN_OK,NULL,NULL,cmdp1);

   /*============  insert 5 tuples into table  ===========================*/
   printf("  3. insert 5 tuples into table odbc_tb1\n");
   rc = SQLExecDirect(cmdp1,(UCHAR *)"insert into odbc_tb1 values(1,1)",SQL_NTS);
   checkrc(RTN_OK,NULL,NULL,cmdp1);

   rc = SQLExecDirect(cmdp1,(UCHAR *)"insert into odbc_tb1 values(2,1)",SQL_NTS);
   checkrc(RTN_OK,NULL,NULL,cmdp1);

   rc = SQLExecDirect(cmdp1,(UCHAR *)"insert into odbc_tb1 values(3,1)",SQL_NTS);
   checkrc(RTN_OK,NULL,NULL,cmdp1);

   rc = SQLExecDirect(cmdp1,(UCHAR *)"insert into odbc_tb1 values(4,1)",SQL_NTS);
   checkrc(RTN_OK,NULL,NULL,cmdp1);
   
   rc = SQLExecDirect(cmdp1,(UCHAR *)"insert into odbc_tb1 values(5,1)",SQL_NTS);
   checkrc(RTN_OK,NULL,NULL,cmdp1);

   /*============  define another permanent table odbc_tb2  ====================*/
   printf("  4. define another permanent table odbc_tb2\n");
   strcpy((char *)str1,"create table odbc_tb2(c1 int,\
                                         c2 varchar(10))");  
   rc = SQLExecDirect(cmdp1,str1,SQL_NTS);
   checkrc(RTN_OK,NULL,NULL,cmdp1);

   /*============  insert tuples into table odbc_tb2 by parmamter  ============*/
   printf("  5. insert tuples into table odbc_tb2 \n");
   strcpy((char *)str1,"insert into odbc_tb2 values(?,?)");
   rc = SQLPrepare(cmdp1,str1,SQL_NTS);
   checkrc(RTN_OK,NULL,NULL,cmdp1);

   rc = SQLBindParameter(cmdp1, 1, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER,
                         0, 0, &par1, 0, &cbInt);
   checkrc(RTN_OK,NULL,NULL,cmdp1);

   rc = SQLBindParameter(cmdp1, 2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR,
                         10, 0, &par2, 10, &cbChar);
   checkrc(RTN_OK,NULL,NULL,cmdp1);

   for (i = 1; i <= ntb2;++i)
       {
       par1 = i;
	   strcpy((char *)par2,"");
	   for (j = 1; j <= i; j++)
		  strcat((char *)par2,"a");
	   strcat((char *)par2,"\0"); /* null termination */

       rc = SQLExecute(cmdp1);
	   checkrc(RTN_OK,NULL,NULL,cmdp1);

	   rc = SQLFreeStmt(cmdp1, SQL_CLOSE);
	   checkrc(RTN_OK,NULL,NULL,cmdp1);
       }

   /*============    select data from table odbc_tb1   =========================*/
   printf("  6. execute a select command on odbc_tb1\n");
   strcpy((char *)str1,"select * from odbc_tb1");
   rc = SQLExecDirect(cmdp1,str1,SQL_NTS);
   checkrc(RTN_OK,NULL,NULL,cmdp1);

   printf("  7. fetch all data from odbc_tb1\n");
   rc = SQLBindCol(cmdp1, 1,SQL_C_SHORT,&bc1,sizeof(SWORD),&szbc1);
   rc = SQLBindCol(cmdp1, 2,SQL_C_SHORT,&bc2,sizeof(SWORD),&szbc2);   
   printf("    c1       c2  \n");
   printf("  ======   ======\n");
   for (i = 0; i < ntb1; i++)
	  {
	  rc = SQLFetch(cmdp1);
	  printf("  %4d     %4d\n",bc1,bc2);		 
	  }
      
   rc = SQLFreeStmt(cmdp1, SQL_CLOSE);
   checkrc(RTN_OK,NULL,NULL,cmdp1);
   
   /*============    select data from table odbc_tb2   =========================*/
   printf("  8. execute a select command on odbc_tb2\n");
   strcpy((char *)str1,"select * from odbc_tb2");
   rc = SQLExecDirect(cmdp1,str1,SQL_NTS);
   checkrc(RTN_OK,NULL,NULL,cmdp1);

   printf("  9. fetch all data from odbc_tb2\n");
   rc = SQLBindCol(cmdp1, 1,SQL_C_LONG,&bc3,sizeof(SDWORD),&szbc3);
   rc = SQLBindCol(cmdp1, 2,SQL_C_CHAR,bc4,11,&szbc4);   

   printf("    c1         c2     \n");
   printf("  ======   ===========\n");

   for (i = 0; i < ntb2; i++)
	  {
	  rc = SQLFetch(cmdp1);
	  printf("  %4d     %-10s\n",bc3,bc4);		 
	  }
      
   rc = SQLFreeStmt(cmdp1, SQL_CLOSE);
   checkrc(RTN_OK,NULL,NULL,cmdp1);
				
   /*============  drop table odbc_tb1 and odbc_tb2  ===================*/
   printf("  10. drop tables odbc_tb1 and odbc_tb2\n");
   strcpy((char *)str1,"drop table odbc_tb1");
   rc = SQLExecDirect(cmdp1,str1,SQL_NTS);
   checkrc(RTN_OK,NULL,NULL,cmdp1);
   strcpy((char *)str1,"drop table odbc_tb2");
   rc = SQLExecDirect(cmdp1,str1,SQL_NTS);
   checkrc(RTN_OK,NULL,NULL,cmdp1);

   /*============  commit transaction and terminate db  ===================*/
   printf("  11. commit the transaction \n");
   rc = SQLTransact(henv,hdbc,SQL_COMMIT);
   checkrc(RTN_OK,NULL,hdbc,NULL);

   /*============  disconnect database  ==================================*/
   printf("  12. disconnect from the database\n");

EXIT:    
   rc = SQLFreeStmt(cmdp1,SQL_DROP);
   if (rc) printf("free statement fail !! \n");

   rc = SQLDisconnect(hdbc);
   if (rc) printf("disconnect database fail !!\n");

   /* Free the connection handle and environment handle      */
   rc = SQLFreeConnect(hdbc);
   if (rc) printf("free connection fail !! \n");
   rc = SQLFreeEnv(henv);
   if (rc) printf("free envrionment fail !! \n");

   printf(" +----------------------------------------------------+\n");
   printf(" +--            END of ODBC Example ex1              -+\n");
   printf(" +----------------------------------------------------+\n");
   return;                                     
  
} /* end of main */
